/*
 * Copyright (C) 2000 Richard Groult <rgroult@jalix.org>
 *
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include "fileitem.h"

FileItem::FileItem(QIconView *parent, const char* path, const char* filename, const char* icon)
	:KFileIconViewItem (parent, filename, BarIcon (icon, 48), new KFileViewItem(-1, -1, KURL(QString("file:")+path+filename), false))

{
	haspreview=false;
}

void
FileItem::setName(QString n){
	myName=n;
};

FileItem::~FileItem()
{
}

void 
FileItem::setPixmap ( const QPixmap & icon, bool haspreview )
{
	KFileIconViewItem::setPixmap(icon, true, true);
	this->haspreview=haspreview;
}

bool 
FileItem::hasPreview ()
{
	return haspreview;
}

FileItem*
FileItem::nextItem ()
{
	return (FileItem*)KFileIconViewItem::nextItem();
}
FileItem*
FileItem::prevItem ()
{
	return (FileItem*)KFileIconViewItem::prevItem();
}


QString 
FileItem::name()
{
	return myName;
};

QString FileItem::fullName(){
	return "";
};

bool 
FileItem::suppression(bool)
{
	return false;
};

bool 
FileItem::suppression()
{
	return false;
};

bool 
FileItem::moveToTrash()
{
	return false;
};

bool 
FileItem::shred()
{
	return false;
}
  
QString
FileItem::text(int i) const
{
	return QString();
}

QString
FileItem::text() const
{
	return text(0);
}

void
FileItem::setWallpaper()
{
}

QString 
FileItem::getFileName(QString fullName)
{
	return QString();
};

QString
FileItem::getFileExt(QString fullName)
{
	return QString();
};

QString
FileItem::getFullName(QString fullName)
{
	return QString();
};

QString
FileItem::getFullPath(QString fullName)
{
	return QString();
};


QString 
FileItem::getFileName(QString *fullName)
{
	int debut = fullName->findRev ("/");
	int fin = fullName->findRev (".");
	return fullName->mid(debut+1, fin-debut-1);
}


QString 
FileItem::getFileExt(QString *fullName)
{
	int pos = fullName->findRev (".");
	return  fullName->right (fullName->length () - pos-1);
}

QString 
FileItem::getFullName(QString *fullName)
{
	int pos = fullName->findRev ("/");
	return fullName->right (fullName->length () - pos-1);
}

QString 
FileItem::getFullPath(QString *fullName)
{
		int pos = fullName->findRev ("/");
		return fullName->left(pos+1);
}

QString 
FileItem::mimetype() const
{
	return fileInfo()->mimetype();
}


void
FileItem::setKey ( const QString & k )
{
	if(k=="name")
		QIconViewItem::setKey(text());
	else
	if(k=="size")
		QIconViewItem::setKey(*size);
	else
	if(k=="type")
		QIconViewItem::setKey(getFileExt(new QString(name())));
	else
	if(k=="date")
		QIconViewItem::setKey(*date);
	else
		QIconViewItem::setKey(text());

}
