/*
 * Copyright (C) 2000 Richard Groult <rgroult@jalix.org>
 *
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include "displayCompare.h"

#include <qlayout.h> 
#include <qfileinfo.h> 
#include <qimage.h>
#include <qpixmap.h>
#include <qpushbutton.h>
#include <qapplication.h>
#include <qgroupbox.h>
#include <qwhatsthis.h>

DisplayCompare::DisplayCompare(QWidget* parent, QDict < QVector < QFile > >* cmp )
:KDialog(parent,"DisplayCompare",true)
{
    this->cmp=cmp;

    resize( 571, 509 );
    setFixedSize( 571, 509 );

    setCaption(i18n( "Comparison"  ) );

    GroupBox2_2 = new QGroupBox( this, "GroupBox2_2" );
    GroupBox2_2->setGeometry( QRect( 300, 10, 260, 200 ) );
    GroupBox2_2->setTitle(i18n( "Preview"  ) );

    preview2 = new QLabel( GroupBox2_2, "preview2" );
    preview2->setGeometry( QRect( 10, 20, 240, 170 ) );
    preview2->setScaledContents( TRUE );

    GroupBox2 = new QGroupBox( this, "GroupBox2" );
    GroupBox2->setGeometry( QRect( 20, 10, 250, 200 ) );
    GroupBox2->setTitle(i18n( "Preview"  ) );

    preview1 = new QLabel( GroupBox2, "preview1" );
    preview1->setGeometry( QRect( 10, 20, 230, 170 ) );
    preview1->setScaledContents( TRUE );
      
    GroupBox8 = new QGroupBox( this, "GroupBox8" );
    GroupBox8->setGeometry( QRect( 10, 220, 551, 231 ) );
    GroupBox8->setTitle(i18n( "Identic files"  ) );
 
    listName = new QListView( GroupBox8, "listName" );
    listName->addColumn(i18n( "Files" ) );
    listName->setGeometry( QRect( 10, 20, 251, 201 ) );
    QWhatsThis::add(  listName,i18n( "Contains the list of files\nthat appear several times" ) );
 
    listEq = new QListView( GroupBox8, "listEq" );
    listEq->addColumn(i18n( "Identic to" ) );
    listEq->setGeometry( QRect( 291, 20, 240, 201 ) );
    QWhatsThis::add(  listEq,i18n( "Files identical to those on the right" ) );
 
    delettePushButton = new QPushButton( this, "delettePushButton" );
    delettePushButton->setGeometry( QRect( 320, 460, 111, 31 ) );
    delettePushButton->setText(i18n( "&Delete"  ) );
 
    closePushButton = new QPushButton( this, "closePushButton" );
    closePushButton->setGeometry( QRect( 450, 460, 111, 31 ) );
    closePushButton->setText(i18n( "&Close"  ) );
 
    // signals and slots connections
    connect( delettePushButton, SIGNAL( clicked() ), this, SLOT( suppression() ) );
    connect( closePushButton, SIGNAL( clicked() ), this, SLOT( accept() ) );

	///////////////////////
	QDictIterator < QVector < QFile > >itres (*cmp);	// iterator for res
	while (itres.current ())
	{
		listName->insertItem ( new QListViewItem(listName, (const char *) itres.currentKey ()) );
		++itres;     
	}   
	connect(listName, SIGNAL(selectionChanged ( QListViewItem * )), this, SLOT(slotDisplayLeft(QListViewItem *))); 
	connect(listEq, SIGNAL(selectionChanged ( QListViewItem * )), this, SLOT(slotDisplayRight(QListViewItem *))); 
}


DisplayCompare::~DisplayCompare()
{
}

void DisplayCompare::accept(){done(true);};
void DisplayCompare::reject(){done(false);};

void DisplayCompare::suppression()
{
	QListViewItem* item = listEq->selectedItem (); 
	if(item)
	{
		QFile::remove ((const char*)item->text(0) );
		listEq->takeItem (item);
	}

};


void DisplayCompare::slotDisplayLeft(QListViewItem * item)
{
	QApplication::setOverrideCursor( waitCursor );

	listEq->clear();
	QVector < QFile > *list = (QVector < QFile > *)cmp->find((const char*)item->text(0));
	QImage im = QImage((const char*)item->text(0));
	im = im.smoothScale(preview1->width(), preview1->height());
	QPixmap pix;
	pix.convertFromImage(im);
	preview1->setPixmap(pix);
	QListViewItem *it, *last=NULL;
	QFile *f;
	QString fn;

	for (unsigned int i = 0; i < list->size (); i++)
	        {
	      f=(QFile*)list->at(i);
	      fn =  QFileInfo(*f).absFilePath ();
	      it=new QListViewItem(listEq,(const char*)fn);
	      listEq->insertItem (it);
	      if(!last)
		  last=it;
	  }
	preview2->setPixmap(QPixmap());
	listEq->setSelected(last, true);

	QApplication::restoreOverrideCursor(); 
}


void DisplayCompare::slotDisplayRight(QListViewItem * item)
{
	QApplication::setOverrideCursor( waitCursor );

	QImage im = QImage((const char*)item->text(0));
	im = im.smoothScale(preview2->width(), preview2->height());
	QPixmap pix;
	pix.convertFromImage(im);
	preview2->setPixmap(pix);

	QApplication::restoreOverrideCursor(); 
    }



void DisplayCompare::resizeEvent ( QResizeEvent *e)
{
	QDialog::resizeEvent(e);
}
