/*
 * Copyright (C) 2000 Richard Groult <rgroult@jalix.org>
 *
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifndef __DESCRIBE_H__
#define __DESCRIBE_H__

#include "imagefileinfo.h"

#include <qvariant.h>
#include <kdialog.h>

class QVBoxLayout; 
class QHBoxLayout; 
class QGridLayout; 
class QGroupBox;
class QLabel;
class QLineEdit;
class QMultiLineEdit;
class QPushButton;

class ImageFileInfo;

class Describe : public KDialog
{ 
    Q_OBJECT

public:
    Describe( QWidget* parent, QString imafefile, const char* name = 0, bool modal = FALSE, WFlags fl = 0 );
    ~Describe();
    
    
protected slots:
    void accept();

protected:
    ImageFileInfo *iinfo;
    
    QGroupBox* GroupBox2;
    QLabel* TextLabel2_2;
    QLabel* TextLabel3_2;
    QLabel* TextLabel4_2;
    QLabel* TextLabel5_2;
    QLineEdit* event;
    QLineEdit* location;
    QLineEdit* people;
    QLineEdit* date;
    QGroupBox* GroupBox6;
    QMultiLineEdit* longDescr;
    QLabel* TextLabel1;
    QLineEdit* LineEdit1;
    QPushButton* okButton;
    QPushButton* cancelButton;

    QHBoxLayout* Layout4;
    QHBoxLayout* Layout5;
    QVBoxLayout* Layout14;
    QVBoxLayout* Layout16;
    QHBoxLayout* Layout3;
};

#endif // Describe_H
