/*
 * Copyright (C) 2000 Richard Groult <rgroult@jalix.org>
 *
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/* compressedfile.h*/



#ifndef __COMPRESSEDFILE_H__
#define __COMPRESSEDFILE_H__

#include "showimg.h"
#include "compressedimagefile.h"
#include "imagelisteview.h"
#include "mainwindow.h" 
#include "directoryview.h" 
#include "directory.h" 

#include <qlistview.h>
#include <qfile.h>
#include <qlist.h>


class CompressedImageFileItem;
class ImageListeView;
class ImageViewer;
class Directory;
class DirectoryView;
class MainWindow;

class CompressedFileItem:public QListViewItem
{
public:
	CompressedFileItem (Directory * parent, const char *filename, const char *path,
		      MainWindow *mw, DirectoryView* dirView,
		      ImageViewer * iv, ImageListeView * imageList);

	QString text (int column) const;
	QString key (int column, bool ascending) const;

	void loadArchive (bool refresh=true);
	void unLoadArchive ();
	void removeImage (CompressedImageFileItem * imf);

	void setSelected (bool s);

	QString fullName ();

	const QPixmap *pixmap (int column) const;

private:
	MainWindow *mw;
	DirectoryView *dirView;

	QFile f;
	Directory *p;
	bool readable;

	QCString *size;
	QCString *extension;

	ImageListeView *imageList;
	QString full;
	ImageViewer *iv;

	QPixmap *p_open;
	QPixmap *p_none;

	QList < CompressedImageFileItem > list;
};


#endif
