/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * Written (W) 2010 Soeren Sonnenburg
 * Copyright (C) 2010 Berlin Institute of Technology
 */

#ifndef __DATATYPE_H__
#define __DATATYPE_H__
namespace shogun
{
/* Datatypes that shogun supports. */
enum SGDataType
{
	DT_UNDEFINED=0,

	///simple scalar/string types
	DT_SCALAR_BOOL=100,
	DT_SCALAR_BYTE,
	DT_SCALAR_CHAR,
	DT_SCALAR_INT,
	DT_SCALAR_UINT,
	DT_SCALAR_LONG,
	DT_SCALAR_ULONG,
	DT_SCALAR_REAL,
	DT_SCALAR_SHORTREAL,
	DT_SCALAR_LONGREAL,
	DT_SCALAR_SHORT,
	DT_SCALAR_WORD,

	///vector type
	DT_VECTOR_BOOL=200,
	DT_VECTOR_BYTE,
	DT_VECTOR_CHAR,
	DT_VECTOR_INT,
	DT_VECTOR_UINT,
	DT_VECTOR_LONG,
	DT_VECTOR_ULONG,
	DT_VECTOR_REAL,
	DT_VECTOR_SHORTREAL,
	DT_VECTOR_LONGREAL,
	DT_VECTOR_SHORT,
	DT_VECTOR_WORD,

	///dense matrices 
	DT_DENSE_BOOL=300,
	DT_DENSE_BYTE,
	DT_DENSE_CHAR,
	DT_DENSE_INT,
	DT_DENSE_UINT,
	DT_DENSE_LONG,
	DT_DENSE_ULONG,
	DT_DENSE_REAL,
	DT_DENSE_SHORTREAL,
	DT_DENSE_LONGREAL,
	DT_DENSE_SHORT,
	DT_DENSE_WORD,

	///dense nd arrays
	DT_NDARRAY_BOOL=400,
	DT_NDARRAY_BYTE,
	DT_NDARRAY_CHAR,
	DT_NDARRAY_INT,
	DT_NDARRAY_UINT,
	DT_NDARRAY_LONG,
	DT_NDARRAY_ULONG,
	DT_NDARRAY_REAL,
	DT_NDARRAY_SHORTREAL,
	DT_NDARRAY_LONGREAL,
	DT_NDARRAY_SHORT,
	DT_NDARRAY_WORD,

	///sparse matrices
	DT_SPARSE_BOOL=500,
	DT_SPARSE_BYTE,
	DT_SPARSE_CHAR,
	DT_SPARSE_INT,
	DT_SPARSE_UINT,
	DT_SPARSE_LONG,
	DT_SPARSE_ULONG,
	DT_SPARSE_REAL,
	DT_SPARSE_SHORTREAL,
	DT_SPARSE_LONGREAL,
	DT_SPARSE_SHORT,
	DT_SPARSE_WORD,

	///strings of arbitrary type
	DT_STRING_BOOL=600,
	DT_STRING_BYTE,
	DT_STRING_CHAR,
	DT_STRING_INT,
	DT_STRING_UINT,
	DT_STRING_LONG,
	DT_STRING_ULONG,
	DT_STRING_REAL,
	DT_STRING_SHORTREAL,
	DT_STRING_LONGREAL,
	DT_STRING_SHORT,
	DT_STRING_WORD,

	/// structures
	DT_ATTR_STRUCT=700,

	/// shogun objects
	DT_SHOGUN_OBJECT=1000
};
}
#endif // __DATATYPE_H__
