#!/bin/bash


current_dir="$( cd "$( dirname "$0" )" && pwd )"


get_submodule () {
    name=$1
    version=$2
    package_name="shinken-"${name}
    echo "Get ${package_name} ${version}"
    wget https://github.com/shinken-monitoring/${name}/archive/${version}.tar.gz -O /tmp/${package_name}-${version}.tar.gz
    mkdir -p ${current_dir}/submodules/${name}
    cd /tmp && tar xf ${package_name}-${version}.tar.gz -C ${current_dir}/submodules/${name} --strip-components=1
}


# Mod auth cfg password
get_submodule "mod-auth-cfg-password" "2.0.1"
# Mod sqlitedb
get_submodule "mod-sqlitedb" "1.4.1"
