/* $Id: streams.c,v 1.3 1998/07/05 16:57:03 sverrehu Exp $ */
/**************************************************************************
 *
 *  FILE            streams.c
 *  MODULE OF       shhmsg - library for displaying messages.
 *
 *  DESCRIPTION     Routines for handling the stream that output goes to.
 *                  This allows using streams other than stderr and stdout.
 *
 *  WRITTEN BY      Sverre H. Huseby <sverrehu@online.no>
 *                  This file is mainly contributed by
 *                    Louis W. Erickson <loue@skylight.com>
 *
 **************************************************************************/

#include <stdio.h>
#include <string.h>

#include "internal.h"
#include "shhmsg.h"

/**************************************************************************
 *                                                                        *
 *                    P U B L I C    F U N C T I O N S                    *
 *                                                                        *
 **************************************************************************/

/*-------------------------------------------------------------------------
 *
 *  NAME          msgSetErrorStream
 *
 *  FUNCTION      Specify the file stream error values should go to.
 *
 *  SYNOPSIS      #include "shhmsg.h"
 *                FILE *msgSetErrorStream(FILE *f);
 *
 *  INPUT         f       pointer to a FILE that holds stream to write to.
 *
 *  RETURNS       Pointer to the old stream used for output.
 *
 *  DESCRIPTION   The stream passed is used to write all errors to.
 */
FILE *
msgSetErrorStream(FILE *f)
{
    FILE *ret = _msgErrorStream;

    _msgErrorStream = f ? f : MSG_DEFAULT_ERROR_STREAM;
    return ret;
}



/*-------------------------------------------------------------------------
 *
 *  NAME          msgSetVerboseStream
 *
 *  FUNCTION      Specify the file stream verbose output should go to.
 *
 *  SYNOPSIS      #include "shhmsg.h"
 *                FILE *msgSetVerboseStream(FILE *f);
 *
 *  INPUT         f       pointer to a FILE that holds stream to write to.
 *
 *  RETURNS       Pointer to the old stream used for output.
 *
 *  DESCRIPTION   The stream passed is used to write all verbose output to.
 */
FILE *
msgSetVerboseStream(FILE *f)
{
    FILE *ret = _msgVerboseStream;

    _msgVerboseStream = f ? f : MSG_DEFAULT_VERBOSE_STREAM;
    return ret;
}



/*-------------------------------------------------------------------------
 *
 *  NAME          msgSetMessageStream
 *
 *  FUNCTION      Specify the file stream message output should go to.
 *
 *  SYNOPSIS      #include "shhmsg.h"
 *                FILE *msgSetMessageStream(FILE *f);
 *
 *  INPUT         f       pointer to a FILE that holds stream to write to.
 *
 *  RETURNS       Pointer to the old stream used for output.
 *
 *  DESCRIPTION   The stream passed is used to write all "messages" to.
 */
FILE *
msgSetMessageStream(FILE *f)
{
    FILE *ret = _msgMessageStream;

    _msgMessageStream = f ? f : MSG_DEFAULT_MESSAGE_STREAM;
    return ret;
}
