
/* Sherman's aquarium - Preferences dialog */

/* This file was generated by Glade, but I've changed alot */

#ifdef GNOME

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <gtk/gtk.h>

#ifdef GNOME2
#include <panel-applet.h>
#include <libgnomeui/libgnomeui.h>
#include <libgnomeui/gnome-window-icon.h>
#include <libgnome/libgnome.h>
#include "gnome2-applet.h"
#else
#include <gnome.h>
#include <libgnomeui/gnome-window-icon.h>
#include <applet-widget.h>
#include "gnome-applet.h"
#endif

#include "preferences.h"
#include "defines.h"
#include "aquarium.h"

/* Widgets that needs to be global */

/* Check boxes */
GtkWidget *eat_check;
GtkWidget *explode_check;
GtkWidget *clock_check;
GtkWidget *thermometer_check;
GtkWidget *leds_check;
GtkWidget *double_check;
GtkWidget *matrix_check;

GtkWidget *numfishes_label;

/* Spins */
GtkWidget *scale_spin;
GtkWidget *numfishes_spin;
GtkWidget *numbubbles_spin;

/* Background */
GtkWidget *background_frame;

GtkWidget *solid_colour_radio;
GtkWidget *shaded_blue_radio;
GtkWidget *water_radio;
GtkWidget *your_own_radio;


GtkWidget *select_fish_button;
GtkWidget *preferences=NULL;
GtkWidget *fish_frame;



GtkWidget *fish1_spin;
GtkWidget *fish2_spin;
GtkWidget *fish3_spin;
GtkWidget *fish4_spin;
GtkWidget *fish5_spin;
GtkWidget *fish6_spin;
GtkWidget *squid_spin;
GtkWidget *swordfish_spin;
GtkWidget *ernest_spin;
GtkWidget *hunter_spin;
GtkWidget *lori_spin;
GtkWidget *prey_spin;
GtkWidget *sherman_spin;
GtkWidget *fillmore_spin;
GtkWidget *blowfish_spin;

GtkWidget *fishes_label;

GtkWidget *image_sel_text;

GtkWidget *backcolorpicker;


int applied;




/*
void show_status()
{


  Settings s;

  memset(&s,0,sizeof(Settings));

  s.eat=gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(eat_check));
  s.explode=gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(explode_check));
  s.clock=gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(clock_check));
  s.thermo=gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(thermometer_check));
  s.leds=gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(leds_check));
  s.doublewh=gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(double_check));
  s.matrix=gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(matrix_check));

  s.scale= gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(scale_spin));
  s.fishes= gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(numfishes_spin));
  s.bubbles= gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(numbubbles_spin));

  s.choose = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(select_fish_button));


  s.fish1 = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(fish1_spin));
  s.fish2 = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(fish2_spin));
  s.fish3 = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(fish3_spin));
  s.fish4 = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(fish4_spin));
  s.fish5 = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(fish5_spin));
  s.fish6 = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(fish6_spin));
  s.swordfish = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(swordfish_spin));
  s.blowfish = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(blowfish_spin));
  s.fillmore = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(fillmore_spin));
  s.sherman = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(sherman_spin));
  s.prey = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(prey_spin));
  s.hunter = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(hunter_spin));
  s.lori = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(lori_spin));
  s.ernest = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(ernest_spin));

  s.squid = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(squid_spin));

  s.solidcolour=gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(solid_colour_radio));
  s.shadedblue=gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(shaded_blue_radio));
  s.wateralike=gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(water_radio));
  s.yourown=gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(your_own_radio));




  if(s.eat) printf(" - eating\n");
  else printf(" - not eating.\n");

  if(s.explode) printf(" - explode\n");
  else printf(" - not exploding.\n");

  if(s.clock) printf(" - clock\n");
  else printf(" - no clock.\n");

  if(s.thermo) printf(" - thermo\n");
  else printf(" - no thermo.\n");

  if(s.leds) printf(" - leds\n");
  else printf(" - no leds.\n");

  if(s.doublewh) printf(" - double\n");
  else printf(" - not double.\n");

  if(s.matrix) printf(" - matrix\n");
  else printf(" - no matrix.\n");

  if(s.choose) printf(" - Choose your own fish.\n");
  else printf("Random fish.\n");

  printf("Scale is: %d\n",s.scale);
  printf("Num fish: %d\n",s.fishes);
  printf("Num bubbles: %d\n",s.bubbles);

  printf("Fish1: %d\n",s.fish1);
  printf("Fish2: %d\n",s.fish2);
  printf("Fish3: %d\n",s.fish3);
  printf("Fish4: %d\n",s.fish4);
  printf("Fish5: %d\n",s.fish5);
  printf("Fish6: %d\n",s.fish6);

  printf("Swordfish: %d\n",s.swordfish);
  printf("Blowfish: %d\n",s.blowfish);
  printf("Hunter: %d\n",s.hunter);
  printf("Prey: %d\n",s.prey);
  printf("Lori: %d\n",s.lori);
  printf("Ernest: %d\n",s.ernest);
  printf("Sherman: %d\n",s.sherman);
  printf("Fillmore: %d\n",s.fillmore);
  printf("Squid: %d\n",s.squid);

  printf("\n\nSolid blue:%d\n",s.solidcolour);
  printf("Shaded blue:%d\n",s.shadedblue);
  printf("Wateralike:%d\n",s.wateralike);
  printf("Yourown:%d\n",s.yourown);
  
  printf("Background file %s\n",  gtk_entry_get_text(GTK_ENTRY(image_sel_text)));


}
*/

void save_settings(char *path)
{
  Settings s;


  /* Get all the values from the different fields and so.*/

  s.eat=gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(eat_check));
  s.explode=gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(explode_check));
  s.clock=gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(clock_check));
  s.thermo=gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(thermometer_check));
  s.leds=gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(leds_check));
  s.doublewh=gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(double_check));
  s.matrix=gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(matrix_check));

  s.scale= gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(scale_spin));
  s.fishes= gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(numfishes_spin));
  s.bubbles= gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(numbubbles_spin));

  s.choose = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(select_fish_button));

  s.fish1 = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(fish1_spin));
  s.fish2 = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(fish2_spin));
  s.fish3 = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(fish3_spin));
  s.fish4 = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(fish4_spin));
  s.fish5 = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(fish5_spin));
  s.fish6 = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(fish6_spin));
  s.swordfish = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(swordfish_spin));
  s.blowfish = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(blowfish_spin));
  s.fillmore = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(fillmore_spin));
  s.sherman = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(sherman_spin));
  s.prey = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(prey_spin));
  s.hunter = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(hunter_spin));
  s.lori = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(lori_spin));
  s.ernest = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(ernest_spin));

  s.squid = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(squid_spin));

  s.solidcolour=gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(solid_colour_radio));
  s.shadedblue=gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(shaded_blue_radio));
  s.wateralike=gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(water_radio));
  s.yourown=gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(your_own_radio));

  gnome_color_picker_get_i8(GNOME_COLOR_PICKER(backcolorpicker),&s.r,&s.g,&s.b,NULL);

  

  /* Saving all the vallues */

  gnome_config_push_prefix (path);

  gnome_config_set_bool("shermans_aquarium/eating",s.eat);
  gnome_config_set_bool("shermans_aquarium/explode",s.explode);
  gnome_config_set_bool("shermans_aquarium/clock",s.clock);
  gnome_config_set_bool("shermans_aquarium/thermometer",s.thermo);
  gnome_config_set_bool("shermans_aquarium/leds",s.leds);

  gnome_config_set_bool("shermans_aquarium/doublewh",s.doublewh);
  gnome_config_set_bool("shermans_aquarium/matrix",s.matrix);
  gnome_config_set_int("shermans_aquarium/scale",s.scale);
  gnome_config_set_int("shermans_aquarium/fishes",s.fishes);
  gnome_config_set_int("shermans_aquarium/bubbles",s.bubbles);
  gnome_config_set_bool("shermans_aquarium/choose",s.choose);
  gnome_config_set_int("shermans_aquarium/fish1",s.fish1);
  gnome_config_set_int("shermans_aquarium/fish2",s.fish2);
  gnome_config_set_int("shermans_aquarium/fish3",s.fish3);
  gnome_config_set_int("shermans_aquarium/fish4",s.fish4);
  gnome_config_set_int("shermans_aquarium/fish5",s.fish5);
  gnome_config_set_int("shermans_aquarium/fish6",s.fish6);
  gnome_config_set_int("shermans_aquarium/fillmore",s.fillmore);
  gnome_config_set_int("shermans_aquarium/sherman",s.sherman);
  gnome_config_set_int("shermans_aquarium/ernest",s.ernest);
  gnome_config_set_int("shermans_aquarium/lori",s.lori);
  gnome_config_set_int("shermans_aquarium/hunter",s.hunter);
  gnome_config_set_int("shermans_aquarium/prey",s.prey);
  gnome_config_set_int("shermans_aquarium/swordfish",s.swordfish);
  gnome_config_set_int("shermans_aquarium/blowfish",s.blowfish);
  gnome_config_set_int("shermans_aquarium/squid",s.squid);

  gnome_config_set_bool("shermans_aquarium/solidcolour",s.solidcolour);
  gnome_config_set_bool("shermans_aquarium/shadedblue",s.shadedblue);
  gnome_config_set_bool("shermans_aquarium/wateralike",s.wateralike);
  gnome_config_set_bool("shermans_aquarium/yourown",s.yourown);

  gnome_config_set_string("shermans_aquarium/image",
					gtk_entry_get_text(GTK_ENTRY(image_sel_text)));

  gnome_config_set_int("shermans_aquarium/r",s.r);
  gnome_config_set_int("shermans_aquarium/g",s.g);
  gnome_config_set_int("shermans_aquarium/b",s.b);


  gnome_config_sync();
  gnome_config_drop_all();
  gnome_config_pop_prefix();

}
void reset_settings(char *path)
{

  gnome_config_push_prefix (path);

  gnome_config_set_bool("shermans_aquarium/eating",1);
  gnome_config_set_bool("shermans_aquarium/explode",1);
  gnome_config_set_bool("shermans_aquarium/clock",1);
  gnome_config_set_bool("shermans_aquarium/thermometer",1);
  gnome_config_set_bool("shermans_aquarium/leds",0);

  gnome_config_set_bool("shermans_aquarium/doublewh",0);
  gnome_config_set_bool("shermans_aquarium/matrix",0);
  gnome_config_set_int("shermans_aquarium/scale",50);
  gnome_config_set_int("shermans_aquarium/fishes",8);
  gnome_config_set_int("shermans_aquarium/bubbles",15);
  gnome_config_set_bool("shermans_aquarium/choose",0);
  gnome_config_set_int("shermans_aquarium/fish1",1);
  gnome_config_set_int("shermans_aquarium/fish2",1);
  gnome_config_set_int("shermans_aquarium/fish3",1);
  gnome_config_set_int("shermans_aquarium/fish4",1);
  gnome_config_set_int("shermans_aquarium/fish5",1);
  gnome_config_set_int("shermans_aquarium/fish6",1);
  gnome_config_set_int("shermans_aquarium/fillmore",1);
  gnome_config_set_int("shermans_aquarium/sherman",1);
  gnome_config_set_int("shermans_aquarium/ernest",1);
  gnome_config_set_int("shermans_aquarium/lori",1);
  gnome_config_set_int("shermans_aquarium/hunter",1);
  gnome_config_set_int("shermans_aquarium/prey",1);
  gnome_config_set_int("shermans_aquarium/swordfish",1);
  gnome_config_set_int("shermans_aquarium/blowfish",1);
  gnome_config_set_int("shermans_aquarium/squid",1);


  gnome_config_set_bool("shermans_aquarium/solidcolour",0);
  gnome_config_set_bool("shermans_aquarium/shadedblue",0);
  gnome_config_set_bool("shermans_aquarium/wateralike",1);
  gnome_config_set_bool("shermans_aquarium/yourown",0);

  gnome_config_set_int("shermans_aquarium/r",0);
  gnome_config_set_int("shermans_aquarium/g",0x55);
  gnome_config_set_int("shermans_aquarium/b",0xff);


  gnome_config_set_string("shermans_aquarium/image","");

  gnome_config_sync();
  gnome_config_drop_all();
  gnome_config_pop_prefix();


}


Settings load_settings(char *path)
{
  char tmp[81];
  Settings s;

  /*
  printf("loading settings\n");
  */

  gnome_config_push_prefix (path);
  
  s.eat=gnome_config_get_bool_with_default("shermans_aquarium/eating=TRUE",NULL);

  s.explode=gnome_config_get_bool_with_default("shermans_aquarium/explode=TRUE",NULL);


  s.clock=gnome_config_get_bool_with_default("shermans_aquarium/clock=TRUE",NULL);
  s.thermo=gnome_config_get_bool_with_default("shermans_aquarium/thermometer=TRUE",NULL);
  s.leds=gnome_config_get_bool_with_default("shermans_aquarium/leds=FALSE",NULL);
  s.doublewh=gnome_config_get_bool_with_default("shermans_aquarium/doublewh=FALSE",NULL);
  s.matrix=gnome_config_get_bool_with_default("shermans_aquarium/matrix=FALSE",NULL);

  g_snprintf(tmp,80,"shermans_aquarium/scale=%d",DEFAULT_SCALE);
  s.scale=gnome_config_get_int_with_default(tmp,NULL);

  g_snprintf(tmp,80,"shermans_aquarium/fishes=%d",NRFISH);
  s.fishes=gnome_config_get_int_with_default(tmp,NULL);

  g_snprintf(tmp,80,"shermans_aquarium/bubbles=%d",MAXBUBBLES);
  s.bubbles=gnome_config_get_int_with_default(tmp,NULL);

  s.choose=gnome_config_get_bool_with_default("shermans_aquarium/choose=FALSE",NULL);
  s.fish1=gnome_config_get_int_with_default("shermans_aquarium/fish1=1",NULL);
  s.fish2=gnome_config_get_int_with_default("shermans_aquarium/fish2=1",NULL);
  s.fish3=gnome_config_get_int_with_default("shermans_aquarium/fish3=1",NULL);
  s.fish4=gnome_config_get_int_with_default("shermans_aquarium/fish4=1",NULL);
  s.fish5=gnome_config_get_int_with_default("shermans_aquarium/fish5=1",NULL);
  s.fish6=gnome_config_get_int_with_default("shermans_aquarium/fish6=1",NULL);
  s.fillmore=gnome_config_get_int_with_default("shermans_aquarium/fillmore=1",NULL);
  s.sherman=gnome_config_get_int_with_default("shermans_aquarium/sherman=1",NULL);
  s.ernest=gnome_config_get_int_with_default("shermans_aquarium/ernest=1",NULL);
  s.lori=gnome_config_get_int_with_default("shermans_aquarium/lori=1",NULL);
  s.hunter=gnome_config_get_int_with_default("shermans_aquarium/hunter=1",NULL);
  s.prey=gnome_config_get_int_with_default("shermans_aquarium/prey=2",NULL);
  s.swordfish=gnome_config_get_int_with_default("shermans_aquarium/swordfish=1",NULL);
  s.blowfish=gnome_config_get_int_with_default("shermans_aquarium/blowfish=2",NULL);
  s.squid=gnome_config_get_int_with_default("shermans_aquarium/squid=1",NULL);


  s.solidcolour=gnome_config_get_bool_with_default("shermans_aquarium/solidcolour=FALSE",NULL);
  s.shadedblue=gnome_config_get_bool_with_default("shermans_aquarium/shadedblue=FALSE",NULL);
  s.wateralike=gnome_config_get_bool_with_default("shermans_aquarium/wateralike=TRUE",NULL);
  s.yourown=gnome_config_get_bool_with_default("shermans_aquarium/yourown=FALSE",NULL);
  s.imagename = gnome_config_get_string("shermans_aquarium/image=");

  s.r=gnome_config_get_int_with_default("shermans_aquarium/r=0",NULL);
  s.g=gnome_config_get_int_with_default("shermans_aquarium/g=85",NULL);
  s.b=gnome_config_get_int_with_default("shermans_aquarium/b=255",NULL);


  gnome_config_pop_prefix();


  /* Recalculated the number of fishes, if needed */
  if(s.choose){
    s.fishes=s.fish1;
    s.fishes+=s.fish2;
    s.fishes+=s.fish3;
    s.fishes+=s.fish4;
    s.fishes+=s.fish5;
    s.fishes+=s.fish6;
    s.fishes+=s.fish6;
    s.fishes+=s.swordfish;
    s.fishes+=s.blowfish;
    s.fishes+=s.fillmore;
    s.fishes+=s.sherman;
    s.fishes+=s.prey;
    s.fishes+=s.hunter;
    s.fishes+=s.lori;
    s.fishes+=s.ernest;
    s.fishes+=s.squid;
  }

  return s;
}


void
on_preferences_apply                   (GnomePropertyBox *gnomepropertybox,
                                        gint             arg1,
                                        gpointer         user_data)
{
  /*printf("Saving settings...\n");*/

  save_settings("shermans_aquarium/");
  applied=1;
}


void
on_preferences_help                    (GnomePropertyBox *gnomepropertybox,
                                        gint             arg1,
                                        gpointer         user_data)
{
  help_aquarium(NULL,NULL);
}


gint
on_preferences_close                   (GnomeDialog     *gnomedialog,
                                        gpointer         user_data)
{

  /* If something is changed and applied, then reload everything */
  if(applied)
    reload_all();
  
  applied=0;
  preferences=NULL;

  return 0;
}



/*
void
on_numfishes_spin_changed              (GtkEditable     *editable,
                                        gpointer         user_data)
{
  printf("fish num changed\n");
}
*/

void
on_select_fish_button_toggled          (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
  int t;
  /*
  printf("fish button toggled\n");
  */

  t=gtk_toggle_button_get_active(togglebutton);

  gtk_widget_set_sensitive (numfishes_spin, !t);

  gtk_widget_set_sensitive (numfishes_label, !t);
  gtk_widget_set_sensitive (fish_frame, t);
}


void browse_images_changed(GtkObject *entry, gpointer user_data)
{
  /*
  printf("filename_box\n");
  */

  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (your_own_radio),1);
}



void create_preferences (int gnomeapplet)
{
  Settings s;
  char *icon_name, tmp[80];

  GtkWidget *image_sel;
  GtkObject *scale_spin_adj;
  GtkObject *numfishes_spin_adj;
  GtkObject *numbubbles_spin_adj;
  GtkObject *fish1_spin_adj;
  GtkObject *fish2_spin_adj;
  GtkObject *fish3_spin_adj;
  GtkObject *fish4_spin_adj;
  GtkObject *fish5_spin_adj;
  GtkObject *fish6_spin_adj;
  GtkObject *squid_spin_adj;
  GtkObject *swordfish_spin_adj;
  GtkObject *ernest_spin_adj;
  GtkObject *hunter_spin_adj;
  GtkObject *lori_spin_adj;
  GtkObject *prey_spin_adj;
  GtkObject *sherman_spin_adj;
  GtkObject *blowfish_spin_adj;
  GtkObject *fillmore_spin_adj;

  /* Labels */

  GtkWidget *numbubbles_label;
  GtkWidget *fishscale_label;

  /* Fields */
  GtkWidget *notebook1;
  GtkWidget *vbox2;
  GtkWidget *table2;

  GtkWidget *table3;
  GSList *background_group = NULL;

  GtkWidget *config_label;
  GtkWidget *alignment1;
  GtkWidget *vbox1;
  GtkWidget *table1;

  GtkWidget *fish1_label;
  GtkWidget *fish2_label;
  GtkWidget *fish3_label;
  GtkWidget *fish4_label;
  GtkWidget *fish5_label;
  GtkWidget *fish6_label;
  GtkWidget *squid_label;
  GtkWidget *swordfish_label;
  GtkWidget *Ernest_label;
  GtkWidget *hunter_label;
  GtkWidget *lori_label;
  GtkWidget *prey_label;
  GtkWidget *sherman_label;
  GtkWidget *fillmore_label;
  GtkWidget *blowfish_label;


  /* Already running? */
  if(preferences){
    gdk_window_raise(preferences->window);
    return;
  }

  

  /* Loading settings...*/
  s=load_settings("shermans_aquarium/");
  icon_name = filename("aquarium/sherman_icon.png");


  /* making main window */

  preferences = gnome_property_box_new ();

  g_snprintf(tmp,79,"Sherman's aquarium v%s - Preferences",VERSION);

  gtk_object_set_data (GTK_OBJECT (preferences), "preferences", preferences);
  gtk_window_set_title (GTK_WINDOW (preferences), tmp);
  gtk_window_set_policy (GTK_WINDOW (preferences), FALSE, FALSE, FALSE);
  gnome_window_icon_set_from_file(GTK_WINDOW(preferences),
				  icon_name);



  /* Making two fields and boxes */
  notebook1 = GNOME_PROPERTY_BOX (preferences)->notebook;
  gtk_object_set_data (GTK_OBJECT (preferences), "notebook1", notebook1);

  
  vbox2 = gtk_vbox_new (FALSE, 0);
  gtk_widget_ref (vbox2);
  gtk_object_set_data_full (GTK_OBJECT (preferences), "vbox2", vbox2,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_container_add (GTK_CONTAINER (notebook1), vbox2);


  table2 = gtk_table_new (7, 3, FALSE);
  gtk_widget_ref (table2);
  gtk_object_set_data_full (GTK_OBJECT (preferences), "table2", table2,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_box_pack_start (GTK_BOX (vbox2), table2, TRUE, FALSE, 0);


  /* add check boxes */

  /* Eat */
  eat_check = gtk_check_button_new_with_label ("Prey can be eaten");
  gtk_widget_ref (eat_check);
  gtk_object_set_data_full (GTK_OBJECT (preferences), "eat_check", eat_check,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_table_attach (GTK_TABLE (table2), eat_check, 0, 1, 0, 1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 5, 0);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (eat_check), s.eat);
  gtk_signal_connect_object(GTK_OBJECT(eat_check), "toggled",
			    GTK_SIGNAL_FUNC(gnome_property_box_changed),
			    GTK_OBJECT(preferences));


  /* Explode */
  explode_check = gtk_check_button_new_with_label ("Blowfish can explode");
  gtk_widget_ref (explode_check);
  gtk_object_set_data_full (GTK_OBJECT (preferences), "explode_check", explode_check,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_table_attach (GTK_TABLE (table2), explode_check, 0, 1, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 5, 0);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (explode_check), s.explode);
  gtk_signal_connect_object(GTK_OBJECT(explode_check), "toggled",
			    GTK_SIGNAL_FUNC(gnome_property_box_changed),
			    GTK_OBJECT(preferences));


  /* Clock */
  clock_check = gtk_check_button_new_with_label ("Digital clock");
  gtk_widget_ref (clock_check);
  gtk_object_set_data_full (GTK_OBJECT (preferences), "clock_check", clock_check,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_table_attach (GTK_TABLE (table2), clock_check, 0, 1, 2, 3,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 5, 0);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (clock_check), s.clock);
  gtk_signal_connect_object(GTK_OBJECT(clock_check), "toggled",
			    GTK_SIGNAL_FUNC(gnome_property_box_changed),
			    GTK_OBJECT(preferences));
#ifndef CLOCK
  gtk_widget_set_sensitive (clock_check, FALSE);
#endif



  /* Thermometer */
  thermometer_check = gtk_check_button_new_with_label ("Thermometer");
  gtk_widget_ref (thermometer_check);
  gtk_object_set_data_full (GTK_OBJECT (preferences), "thermometer_check", 
			    thermometer_check,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_table_attach (GTK_TABLE (table2), thermometer_check, 0, 1, 3, 4,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 5, 0);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (thermometer_check), 
				s.thermo);
  gtk_signal_connect_object(GTK_OBJECT(thermometer_check), "toggled",
			    GTK_SIGNAL_FUNC(gnome_property_box_changed),
			    GTK_OBJECT(preferences));

#ifndef THERMOMETER
  gtk_widget_set_sensitive (thermometer_check, FALSE);
#endif


  /* Leds */
  leds_check = gtk_check_button_new_with_label ("Keyboard leds");
  gtk_widget_ref (leds_check);
  gtk_object_set_data_full (GTK_OBJECT (preferences), "leds_check", leds_check,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_table_attach (GTK_TABLE (table2), leds_check, 0, 1, 4, 5,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 5, 0);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (leds_check), s.leds);
  gtk_signal_connect_object(GTK_OBJECT(leds_check), "toggled",
			    GTK_SIGNAL_FUNC(gnome_property_box_changed),
			    GTK_OBJECT(preferences));

#ifndef LEDS
  gtk_widget_set_sensitive (leds_check, FALSE);
#endif



  /* Double w/h */
  double_check = gtk_check_button_new_with_label ("Double width/height");
  gtk_widget_ref (double_check);
  gtk_object_set_data_full (GTK_OBJECT (preferences), "double_check", double_check,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_table_attach (GTK_TABLE (table2), double_check, 0, 1, 5, 6,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 5, 0);

  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (double_check), s.doublewh);
  gtk_signal_connect_object(GTK_OBJECT(double_check), "toggled",
			    GTK_SIGNAL_FUNC(gnome_property_box_changed),
			    GTK_OBJECT(preferences));

  if(!gnomeapplet)
      gtk_widget_set_sensitive (double_check, FALSE);


  /* Matrix */
  matrix_check = gtk_check_button_new_with_label ("Matrix");
  gtk_widget_ref (matrix_check);
  gtk_object_set_data_full (GTK_OBJECT (preferences), "matrix_check", matrix_check,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_table_attach (GTK_TABLE (table2), matrix_check, 0, 1, 6, 7,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 5, 0);
#ifndef MATRIX
  gtk_widget_set_sensitive (matrix_check, FALSE);
#endif

  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (matrix_check), s.matrix);

  gtk_signal_connect_object(GTK_OBJECT(matrix_check), "toggled",
			    GTK_SIGNAL_FUNC(gnome_property_box_changed),
			    GTK_OBJECT(preferences));

  /* Labels */
  numbubbles_label = gtk_label_new ("Number of bubbles");
  gtk_widget_ref (numbubbles_label);
  gtk_object_set_data_full (GTK_OBJECT (preferences), "numbubbles_label", 
			    numbubbles_label,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_table_attach (GTK_TABLE (table2), numbubbles_label, 1, 2, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 5, 5);
  gtk_misc_set_alignment (GTK_MISC (numbubbles_label), 0, 0.5);



  numfishes_label = gtk_label_new ("Number of fish");
  gtk_widget_ref (numfishes_label);
  gtk_object_set_data_full (GTK_OBJECT (preferences), "numfishes_label", numfishes_label,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_table_attach (GTK_TABLE (table2), numfishes_label, 1, 2, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 5, 5);
  gtk_misc_set_alignment (GTK_MISC (numfishes_label), 0, 0.5);

  gtk_widget_set_sensitive (numfishes_label, !s.choose);



  fishscale_label = gtk_label_new ("Fish scale (in %)");
  gtk_widget_ref (fishscale_label);
  gtk_object_set_data_full (GTK_OBJECT (preferences), "fishscale_label", fishscale_label,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_table_attach (GTK_TABLE (table2), fishscale_label, 1, 2, 2, 3,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 5, 5);
  gtk_misc_set_alignment (GTK_MISC (fishscale_label), 0, 0.5);


  /* Spins */

  /* Scale */
  scale_spin_adj = gtk_adjustment_new (s.scale, 5, 500, 5, 25, 25);
  scale_spin = gtk_spin_button_new (GTK_ADJUSTMENT (scale_spin_adj), 1, 0);
  gtk_widget_ref (scale_spin);
  gtk_object_set_data_full (GTK_OBJECT (preferences), "scale_spin", scale_spin,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_table_attach (GTK_TABLE (table2), scale_spin, 2, 3, 2, 3,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 5, 0);

  gtk_signal_connect_object(GTK_OBJECT(scale_spin_adj), "value_changed",
			    GTK_SIGNAL_FUNC(gnome_property_box_changed),
			    GTK_OBJECT(preferences));


  /* Num fishes */

  numfishes_spin_adj = gtk_adjustment_new (s.fishes, 0, MAX_FISHES, 1, 10, 10);
  numfishes_spin = gtk_spin_button_new (GTK_ADJUSTMENT (numfishes_spin_adj), 5, 0);
  gtk_widget_ref (numfishes_spin);
  gtk_object_set_data_full (GTK_OBJECT (preferences), "numfishes_spin", numfishes_spin,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_table_attach (GTK_TABLE (table2), numfishes_spin, 2, 3, 1, 2,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 5, 0);
  gtk_signal_connect_object(GTK_OBJECT(numfishes_spin_adj), "value_changed",
			    GTK_SIGNAL_FUNC(gnome_property_box_changed),
			    GTK_OBJECT(preferences));

  gtk_widget_set_sensitive (numfishes_spin, !s.choose);

  /* Num bubbles spin */
  numbubbles_spin_adj = gtk_adjustment_new (s.bubbles, 0, 200, 1, 10, 10);
  numbubbles_spin = gtk_spin_button_new (GTK_ADJUSTMENT (numbubbles_spin_adj), 1, 0);
  gtk_widget_ref (numbubbles_spin);
  gtk_object_set_data_full (GTK_OBJECT (preferences), "numbubbles_spin", numbubbles_spin,
                            (GtkDestroyNotify) gtk_widget_unref);
  
  gtk_table_attach (GTK_TABLE (table2), numbubbles_spin, 2, 3, 0, 1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 5, 0);
  gtk_signal_connect_object(GTK_OBJECT(numbubbles_spin_adj), "value_changed",
			    GTK_SIGNAL_FUNC(gnome_property_box_changed),
			    GTK_OBJECT(preferences));

  /* Background */

  background_frame = gtk_frame_new ("Background");
  gtk_widget_ref (background_frame);
  gtk_object_set_data_full (GTK_OBJECT (preferences), "background_frame", background_frame,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_box_pack_start (GTK_BOX (vbox2), background_frame, TRUE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (background_frame), 5);


  /* Table */
  table3 = gtk_table_new (4, 3, FALSE);
  gtk_widget_ref (table3);
  gtk_object_set_data_full (GTK_OBJECT (preferences), "table3", table3,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_container_add (GTK_CONTAINER (background_frame), table3);


  /* Radio buttons */
  solid_colour_radio = gtk_radio_button_new_with_label (background_group, "Solid blue");
  background_group = gtk_radio_button_group (GTK_RADIO_BUTTON (solid_colour_radio));
  gtk_widget_ref (solid_colour_radio);
  gtk_object_set_data_full (GTK_OBJECT (preferences), "solid_colour_radio", solid_colour_radio,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_table_attach (GTK_TABLE (table3), solid_colour_radio, 0, 1, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);





  gtk_signal_connect_object(GTK_OBJECT(solid_colour_radio), "toggled",
			    GTK_SIGNAL_FUNC(gnome_property_box_changed),
			    GTK_OBJECT(preferences));

  backcolorpicker = gnome_color_picker_new ();

  

  gtk_table_attach (GTK_TABLE (table3), backcolorpicker, 1, 2, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);


  gnome_color_picker_set_i8(GNOME_COLOR_PICKER(backcolorpicker),mys.r,mys.g,mys.b,0);



 
  gnome_color_picker_set_title (GNOME_COLOR_PICKER (backcolorpicker), "Pick background color");

  /*
  gtk_container_set_border_width (GTK_CONTAINER (backcolorpicker), 5);
  */




  shaded_blue_radio = gtk_radio_button_new_with_label (background_group, "Shaded blue");
  background_group = gtk_radio_button_group (GTK_RADIO_BUTTON (shaded_blue_radio));
  gtk_widget_ref (shaded_blue_radio);
  gtk_object_set_data_full (GTK_OBJECT (preferences), "shaded_blue_radio", 
			    shaded_blue_radio,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_table_attach (GTK_TABLE (table3), shaded_blue_radio, 0, 1, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);


  gtk_signal_connect_object(GTK_OBJECT(shaded_blue_radio), "toggled",
			    GTK_SIGNAL_FUNC(gnome_property_box_changed),
			    GTK_OBJECT(preferences));





  water_radio = gtk_radio_button_new_with_label (background_group, "Water alike");
  background_group = gtk_radio_button_group (GTK_RADIO_BUTTON (water_radio));
  gtk_widget_ref (water_radio);
  gtk_object_set_data_full (GTK_OBJECT (preferences), "water_radio", water_radio,
                            (GtkDestroyNotify) gtk_widget_unref);

  gtk_table_attach (GTK_TABLE (table3), water_radio, 0, 1, 2, 3,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);





  gtk_signal_connect_object(GTK_OBJECT(water_radio), "toggled",
			    GTK_SIGNAL_FUNC(gnome_property_box_changed),
			    GTK_OBJECT(preferences));


  your_own_radio = gtk_radio_button_new_with_label (background_group, "Your own");
  background_group = gtk_radio_button_group (GTK_RADIO_BUTTON (your_own_radio));
  gtk_widget_ref (your_own_radio);
  gtk_object_set_data_full (GTK_OBJECT (preferences), "your_own_radio", your_own_radio,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_table_attach (GTK_TABLE (table3), your_own_radio, 0, 1, 3, 4,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);



  gtk_signal_connect_object(GTK_OBJECT(your_own_radio), "toggled",
			    GTK_SIGNAL_FUNC(gnome_property_box_changed),
			    GTK_OBJECT(preferences));

  
  image_sel = gnome_pixmap_entry_new(NULL,"Select background",TRUE);

  gtk_table_attach (GTK_TABLE (table3), image_sel, 2, 3, 3, 4,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 5, 0);
  gtk_container_set_border_width (GTK_CONTAINER (image_sel), 5);
  
  image_sel_text = gnome_pixmap_entry_gtk_entry (GNOME_PIXMAP_ENTRY (image_sel));
  if(s.imagename!=NULL && strlen(s.imagename)>0){
    gtk_entry_set_text(GTK_ENTRY(image_sel_text), s.imagename);
  }
  else{
    gtk_entry_set_text(GTK_ENTRY(image_sel_text), "");
  }
  gtk_object_set_data(GTK_OBJECT(preferences),"image",image_sel);
  gtk_signal_connect_object_while_alive(GTK_OBJECT(image_sel_text), "changed",
					GTK_SIGNAL_FUNC(gnome_property_box_changed),
					 GTK_OBJECT(preferences));

  gtk_signal_connect_object_while_alive(GTK_OBJECT(image_sel_text), "changed",
					GTK_SIGNAL_FUNC(browse_images_changed),
					 GTK_OBJECT(preferences));





  /* New notebook */

  config_label = gtk_label_new ("Configure");
  gtk_widget_ref (config_label);
  gtk_object_set_data_full (GTK_OBJECT (preferences), "config_label", config_label,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook1), 
			      gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook1), 0), 
			      config_label);

  alignment1 = gtk_alignment_new (0.5, 0.5, 1, 1);
  gtk_widget_ref (alignment1);
  gtk_object_set_data_full (GTK_OBJECT (preferences), "alignment1", alignment1,
                            (GtkDestroyNotify) gtk_widget_unref);
 
  gtk_container_add (GTK_CONTAINER (notebook1), alignment1);

  vbox1 = gtk_vbox_new (FALSE, 0);
  gtk_widget_ref (vbox1);
  gtk_object_set_data_full (GTK_OBJECT (preferences), "vbox1", vbox1,
                            (GtkDestroyNotify) gtk_widget_unref);
  
  gtk_container_add (GTK_CONTAINER (alignment1), vbox1);

  select_fish_button = gtk_check_button_new_with_label ("Choose your own fish?");
  gtk_widget_ref (select_fish_button);
  gtk_object_set_data_full (GTK_OBJECT (preferences), "select_fish_button",
			    select_fish_button,
                            (GtkDestroyNotify) gtk_widget_unref);

  gtk_box_pack_start (GTK_BOX (vbox1), select_fish_button, FALSE, FALSE, 0);

  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (select_fish_button), s.choose);


  fish_frame = gtk_frame_new ("Fish");
  gtk_widget_ref (fish_frame);
  gtk_object_set_data_full (GTK_OBJECT (preferences), "fish_frame", fish_frame,
                            (GtkDestroyNotify) gtk_widget_unref);

  gtk_box_pack_start (GTK_BOX (vbox1), fish_frame, TRUE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (fish_frame), 5);


  gtk_widget_set_sensitive (fish_frame, s.choose);


  table1 = gtk_table_new (8, 4, FALSE);
  gtk_widget_ref (table1);
  gtk_object_set_data_full (GTK_OBJECT (preferences), "table1", table1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_container_add (GTK_CONTAINER (fish_frame), table1);

  fish1_label = gtk_label_new ("Fish 1");
  gtk_widget_ref (fish1_label);
  gtk_object_set_data_full (GTK_OBJECT (preferences), "fish1_label", fish1_label,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_table_attach (GTK_TABLE (table1), fish1_label, 0, 1, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 10, 5);
  gtk_misc_set_alignment (GTK_MISC (fish1_label), 0, 0.5);

  fish2_label = gtk_label_new ("Fish 2");
  gtk_widget_ref (fish2_label);
  gtk_object_set_data_full (GTK_OBJECT (preferences), "fish2_label", fish2_label,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_table_attach (GTK_TABLE (table1), fish2_label, 0, 1, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 10, 5);
  gtk_misc_set_alignment (GTK_MISC (fish2_label), 0, 0.5);

  fish3_label = gtk_label_new ("Fish 3");
  gtk_widget_ref (fish3_label);
  gtk_object_set_data_full (GTK_OBJECT (preferences), "fish3_label", fish3_label,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_table_attach (GTK_TABLE (table1), fish3_label, 0, 1, 2, 3,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 10, 5);
  gtk_misc_set_alignment (GTK_MISC (fish3_label), 0, 0.5);

  fish4_label = gtk_label_new ("Fish 4");
  gtk_widget_ref (fish4_label);
  gtk_object_set_data_full (GTK_OBJECT (preferences), "fish4_label", fish4_label,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_table_attach (GTK_TABLE (table1), fish4_label, 0, 1, 3, 4,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 10, 5);
  gtk_misc_set_alignment (GTK_MISC (fish4_label), 0, 0.5);

  fish5_label = gtk_label_new ("Fish 5");
  gtk_widget_ref (fish5_label);
  gtk_object_set_data_full (GTK_OBJECT (preferences), "fish5_label", fish5_label,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_table_attach (GTK_TABLE (table1), fish5_label, 0, 1, 4, 5,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 10, 5);
  gtk_misc_set_alignment (GTK_MISC (fish5_label), 0, 0.5);

  fish6_label = gtk_label_new ("Fish 6");
  gtk_widget_ref (fish6_label);
  gtk_object_set_data_full (GTK_OBJECT (preferences), "fish6_label", fish6_label,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_table_attach (GTK_TABLE (table1), fish6_label, 0, 1, 5, 6,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 10, 5);
  gtk_misc_set_alignment (GTK_MISC (fish6_label), 0, 0.5);

  squid_label = gtk_label_new ("Squid");
  gtk_widget_ref (squid_label);
  gtk_object_set_data_full (GTK_OBJECT (preferences), "squid_label", squid_label,
                            (GtkDestroyNotify) gtk_widget_unref);
 
  gtk_table_attach (GTK_TABLE (table1), squid_label, 0, 1, 6, 7,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 10, 5);
  gtk_misc_set_alignment (GTK_MISC (squid_label), 0, 0.5);

  blowfish_label = gtk_label_new ("Blowfish");
  gtk_widget_ref (blowfish_label);
  gtk_object_set_data_full (GTK_OBJECT (preferences), "blowfish_label", blowfish_label,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_table_attach (GTK_TABLE (table1), blowfish_label, 0, 1, 7, 8,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 10, 5);
  gtk_misc_set_alignment (GTK_MISC (blowfish_label), 0, 0.5);



  swordfish_label = gtk_label_new ("Swordfish");
  gtk_widget_ref (swordfish_label);
  gtk_object_set_data_full (GTK_OBJECT (preferences), "swordfish_label", swordfish_label,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_table_attach (GTK_TABLE (table1), swordfish_label, 2, 3, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 10, 5);
  gtk_misc_set_alignment (GTK_MISC (swordfish_label), 0, 0.5);

  Ernest_label = gtk_label_new ("Ernest");
  gtk_widget_ref (Ernest_label);
  gtk_object_set_data_full (GTK_OBJECT (preferences), "Ernest_label", Ernest_label,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_table_attach (GTK_TABLE (table1), Ernest_label, 2, 3, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 10, 5);
  gtk_misc_set_alignment (GTK_MISC (Ernest_label), 0, 0.5);

  hunter_label = gtk_label_new ("Hunter");
  gtk_widget_ref (hunter_label);
  gtk_object_set_data_full (GTK_OBJECT (preferences), "hunter_label", hunter_label,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_table_attach (GTK_TABLE (table1), hunter_label, 2, 3, 2, 3,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 10, 5);
  gtk_misc_set_alignment (GTK_MISC (hunter_label), 0, 0.5);

  lori_label = gtk_label_new ("Lori");
  gtk_widget_ref (lori_label);
  gtk_object_set_data_full (GTK_OBJECT (preferences), "lori_label", lori_label,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_table_attach (GTK_TABLE (table1), lori_label, 2, 3, 3, 4,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 10, 5);
  gtk_misc_set_alignment (GTK_MISC (lori_label), 0, 0.5);

  prey_label = gtk_label_new ("Prey");
  gtk_widget_ref (prey_label);
  gtk_object_set_data_full (GTK_OBJECT (preferences), "prey_label", prey_label,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_table_attach (GTK_TABLE (table1), prey_label, 2, 3, 4, 5,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 10, 5);
  gtk_misc_set_alignment (GTK_MISC (prey_label), 0, 0.5);

  sherman_label = gtk_label_new ("Sherman");
  gtk_widget_ref (sherman_label);
  gtk_object_set_data_full (GTK_OBJECT (preferences), "sherman_label", sherman_label,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_table_attach (GTK_TABLE (table1), sherman_label, 2, 3, 5, 6,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 10, 5);
  gtk_misc_set_alignment (GTK_MISC (sherman_label), 0, 0.5);

  fillmore_label = gtk_label_new ("Fillmore");
  gtk_widget_ref (fillmore_label);
  gtk_object_set_data_full (GTK_OBJECT (preferences), "fillmore_label", fillmore_label,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_table_attach (GTK_TABLE (table1), fillmore_label, 2, 3, 6, 7,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 10, 5);
  gtk_misc_set_alignment (GTK_MISC (fillmore_label), 0, 0.5);

  fish1_spin_adj = gtk_adjustment_new (s.fish1, 0, 100, 1, 10, 10);
  fish1_spin = gtk_spin_button_new (GTK_ADJUSTMENT (fish1_spin_adj), 1, 0);
  gtk_widget_ref (fish1_spin);
  gtk_object_set_data_full (GTK_OBJECT (preferences), "fish1_spin", fish1_spin,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_table_attach (GTK_TABLE (table1), fish1_spin, 1, 2, 0, 1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 5, 5);
  gtk_signal_connect_object(GTK_OBJECT(fish1_spin_adj), "value_changed",
			    GTK_SIGNAL_FUNC(gnome_property_box_changed),
			    GTK_OBJECT(preferences));



  fish2_spin_adj = gtk_adjustment_new (s.fish2, 0, 100, 1, 10, 10);
  fish2_spin = gtk_spin_button_new (GTK_ADJUSTMENT (fish2_spin_adj), 1, 0);
  gtk_widget_ref (fish2_spin);
  gtk_object_set_data_full (GTK_OBJECT (preferences), "fish2_spin", fish2_spin,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_table_attach (GTK_TABLE (table1), fish2_spin, 1, 2, 1, 2,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 5, 5);
  gtk_signal_connect_object(GTK_OBJECT(fish2_spin_adj), "value_changed",
			    GTK_SIGNAL_FUNC(gnome_property_box_changed),
			    GTK_OBJECT(preferences));


  fish3_spin_adj = gtk_adjustment_new (s.fish3, 0, 100, 1, 10, 10);
  fish3_spin = gtk_spin_button_new (GTK_ADJUSTMENT (fish3_spin_adj), 1, 0);
  gtk_widget_ref (fish3_spin);
  gtk_object_set_data_full (GTK_OBJECT (preferences), "fish3_spin", fish3_spin,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_table_attach (GTK_TABLE (table1), fish3_spin, 1, 2, 2, 3,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 5, 5);
  gtk_signal_connect_object(GTK_OBJECT(fish3_spin_adj), "value_changed",
			    GTK_SIGNAL_FUNC(gnome_property_box_changed),
			    GTK_OBJECT(preferences));

  fish4_spin_adj = gtk_adjustment_new (s.fish4, 0, 100, 1, 10, 10);
  fish4_spin = gtk_spin_button_new (GTK_ADJUSTMENT (fish4_spin_adj), 1, 0);
  gtk_widget_ref (fish4_spin);
  gtk_object_set_data_full (GTK_OBJECT (preferences), "fish4_spin", fish4_spin,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_table_attach (GTK_TABLE (table1), fish4_spin, 1, 2, 3, 4,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 5, 5);
  gtk_signal_connect_object(GTK_OBJECT(fish4_spin_adj), "value_changed",
			    GTK_SIGNAL_FUNC(gnome_property_box_changed),
			    GTK_OBJECT(preferences));

  fish5_spin_adj = gtk_adjustment_new (s.fish5, 0, 100, 1, 10, 10);
  fish5_spin = gtk_spin_button_new (GTK_ADJUSTMENT (fish5_spin_adj), 1, 0);
  gtk_widget_ref (fish5_spin);
  gtk_object_set_data_full (GTK_OBJECT (preferences), "fish5_spin", fish5_spin,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_table_attach (GTK_TABLE (table1), fish5_spin, 1, 2, 4, 5,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 5, 5);
  gtk_signal_connect_object(GTK_OBJECT(fish5_spin_adj), "value_changed",
			    GTK_SIGNAL_FUNC(gnome_property_box_changed),
			    GTK_OBJECT(preferences));

  fish6_spin_adj = gtk_adjustment_new (s.fish6, 0, 100, 1, 10, 10);
  fish6_spin = gtk_spin_button_new (GTK_ADJUSTMENT (fish6_spin_adj), 1, 0);
  gtk_widget_ref (fish6_spin);
  gtk_object_set_data_full (GTK_OBJECT (preferences), "fish6_spin", fish6_spin,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_table_attach (GTK_TABLE (table1), fish6_spin, 1, 2, 5, 6,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 5, 5);
  gtk_signal_connect_object(GTK_OBJECT(fish6_spin_adj), "value_changed",
			    GTK_SIGNAL_FUNC(gnome_property_box_changed),
			    GTK_OBJECT(preferences));



  squid_spin_adj = gtk_adjustment_new (s.squid, 0, 100, 1, 10, 10);
  squid_spin = gtk_spin_button_new (GTK_ADJUSTMENT (squid_spin_adj), 1, 0);
  gtk_widget_ref (squid_spin);
  gtk_object_set_data_full (GTK_OBJECT (preferences), "squid_spin", squid_spin,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_table_attach (GTK_TABLE (table1), squid_spin, 1, 2, 6, 7,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 5, 5);
  gtk_signal_connect_object(GTK_OBJECT(squid_spin_adj), "value_changed",
			    GTK_SIGNAL_FUNC(gnome_property_box_changed),
			    GTK_OBJECT(preferences));


  blowfish_spin_adj = gtk_adjustment_new (s.blowfish, 0, 100, 1, 10, 10);
  blowfish_spin = gtk_spin_button_new (GTK_ADJUSTMENT (blowfish_spin_adj), 1, 0);
  gtk_widget_ref (blowfish_spin);
  gtk_object_set_data_full (GTK_OBJECT (preferences), "blowfish_spin", blowfish_spin,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_table_attach (GTK_TABLE (table1), blowfish_spin, 1, 2, 7, 8,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 5, 5);
  gtk_signal_connect_object(GTK_OBJECT(blowfish_spin_adj), "value_changed",
			    GTK_SIGNAL_FUNC(gnome_property_box_changed),
			    GTK_OBJECT(preferences));


  swordfish_spin_adj = gtk_adjustment_new (s.swordfish, 0, 100, 1, 10, 10);
  swordfish_spin = gtk_spin_button_new (GTK_ADJUSTMENT (swordfish_spin_adj), 1, 0);
  gtk_widget_ref (swordfish_spin);
  gtk_object_set_data_full (GTK_OBJECT (preferences), "swordfish_spin", swordfish_spin,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_table_attach (GTK_TABLE (table1), swordfish_spin, 3, 4, 0, 1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 5, 5);
  gtk_signal_connect_object(GTK_OBJECT(swordfish_spin_adj), "value_changed",
			    GTK_SIGNAL_FUNC(gnome_property_box_changed),
			    GTK_OBJECT(preferences));


  ernest_spin_adj = gtk_adjustment_new (s.ernest, 0, 100, 1, 10, 10);
  ernest_spin = gtk_spin_button_new (GTK_ADJUSTMENT (ernest_spin_adj), 1, 0);
  gtk_widget_ref (ernest_spin);
  gtk_object_set_data_full (GTK_OBJECT (preferences), "ernest_spin", ernest_spin,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_table_attach (GTK_TABLE (table1), ernest_spin, 3, 4, 1, 2,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 5, 5);
  gtk_signal_connect_object(GTK_OBJECT(ernest_spin_adj), "value_changed",
			    GTK_SIGNAL_FUNC(gnome_property_box_changed),
			    GTK_OBJECT(preferences));


  hunter_spin_adj = gtk_adjustment_new (s.hunter, 0, 100, 1, 10, 10);
  hunter_spin = gtk_spin_button_new (GTK_ADJUSTMENT (hunter_spin_adj), 1, 0);
  gtk_widget_ref (hunter_spin);
  gtk_object_set_data_full (GTK_OBJECT (preferences), "hunter_spin", hunter_spin,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_table_attach (GTK_TABLE (table1), hunter_spin, 3, 4, 2, 3,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 5, 5);
  gtk_signal_connect_object(GTK_OBJECT(hunter_spin_adj), "value_changed",
			    GTK_SIGNAL_FUNC(gnome_property_box_changed),
			    GTK_OBJECT(preferences));

  lori_spin_adj = gtk_adjustment_new (s.lori, 0, 100, 1, 10, 10);
  lori_spin = gtk_spin_button_new (GTK_ADJUSTMENT (lori_spin_adj), 1, 0);
  gtk_widget_ref (lori_spin);
  gtk_object_set_data_full (GTK_OBJECT (preferences), "lori_spin", lori_spin,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_table_attach (GTK_TABLE (table1), lori_spin, 3, 4, 3, 4,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 5, 5);
  gtk_signal_connect_object(GTK_OBJECT(lori_spin_adj), "value_changed",
			    GTK_SIGNAL_FUNC(gnome_property_box_changed),
			    GTK_OBJECT(preferences));

  prey_spin_adj = gtk_adjustment_new (s.prey, 0, 100, 1, 10, 10);
  prey_spin = gtk_spin_button_new (GTK_ADJUSTMENT (prey_spin_adj), 1, 0);
  gtk_widget_ref (prey_spin);
  gtk_object_set_data_full (GTK_OBJECT (preferences), "prey_spin", prey_spin,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_table_attach (GTK_TABLE (table1), prey_spin, 3, 4, 4, 5,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 5, 5);
  gtk_signal_connect_object(GTK_OBJECT(prey_spin_adj), "value_changed",
			    GTK_SIGNAL_FUNC(gnome_property_box_changed),
			    GTK_OBJECT(preferences));


  sherman_spin_adj = gtk_adjustment_new (s.sherman, 0, 100, 1, 10, 10);
  sherman_spin = gtk_spin_button_new (GTK_ADJUSTMENT (sherman_spin_adj), 1, 0);
  gtk_widget_ref (sherman_spin);
  gtk_object_set_data_full (GTK_OBJECT (preferences), "sherman_spin", sherman_spin,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_table_attach (GTK_TABLE (table1), sherman_spin, 3, 4, 5, 6,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 5, 5);
  gtk_signal_connect_object(GTK_OBJECT(sherman_spin_adj), "value_changed",
			    GTK_SIGNAL_FUNC(gnome_property_box_changed),
			    GTK_OBJECT(preferences));


  fillmore_spin_adj = gtk_adjustment_new (s.fillmore, 0, 100, 1, 10, 10);
  fillmore_spin = gtk_spin_button_new (GTK_ADJUSTMENT (fillmore_spin_adj), 1, 0);
  gtk_widget_ref (fillmore_spin);
  gtk_object_set_data_full (GTK_OBJECT (preferences), "fillmore_spin", fillmore_spin,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_table_attach (GTK_TABLE (table1), fillmore_spin, 3, 4, 6, 7,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 5, 5);
  gtk_signal_connect_object(GTK_OBJECT(fillmore_spin_adj), "value_changed",
			    GTK_SIGNAL_FUNC(gnome_property_box_changed),
			    GTK_OBJECT(preferences));


  fishes_label = gtk_label_new ("Fish");
  gtk_widget_ref (fishes_label);
  gtk_object_set_data_full (GTK_OBJECT (preferences), "fishes_label", fishes_label,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook1), 
			      gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook1), 1), 
			      fishes_label);




  gtk_signal_connect (GTK_OBJECT (preferences), "apply",
                      GTK_SIGNAL_FUNC (on_preferences_apply),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (preferences), "help",
                      GTK_SIGNAL_FUNC (on_preferences_help),
                      NULL);
  if(gnomeapplet){
    gtk_signal_connect (GTK_OBJECT (preferences), "close",
			GTK_SIGNAL_FUNC (on_preferences_close),
			NULL);
    gtk_signal_connect (GTK_OBJECT (preferences), "destroy",
			GTK_SIGNAL_FUNC (on_preferences_close),
			NULL);

  }
  else{
    gtk_signal_connect (GTK_OBJECT (preferences), "close",
			GTK_SIGNAL_FUNC (gtk_exit),
			NULL);

    gtk_signal_connect (GTK_OBJECT (preferences), "destroy",
			GTK_SIGNAL_FUNC (gtk_exit),
			NULL);
  } 
  /*
  gtk_signal_connect (GTK_OBJECT (numfishes_spin), "changed",
                      GTK_SIGNAL_FUNC (on_numfishes_spin_changed),
                      NULL);
  */

  gtk_signal_connect (GTK_OBJECT (select_fish_button), "toggled",
                      GTK_SIGNAL_FUNC (on_select_fish_button_toggled),
                      NULL);
  
  gtk_widget_show_all(preferences);

  /* Selected kind of background - Make that last */
  if(s.solidcolour)
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (solid_colour_radio),1);

  if(s.shadedblue)
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (shaded_blue_radio),1);

  if(s.wateralike)
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (water_radio),1);

  if(s.yourown)
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (your_own_radio),1);

}
#endif /* GNOME */




