

#include <stdio.h>
#include <gdk/gdk.h>
#include <gdk/gdkx.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <unistd.h>

#include "defines.h"
#include "aquarium.h"
#include "wmapplet.h"
#include "detectbrokenwm.h"

void aquarium_main_wm()
{
    GdkEvent *event;

    while (1) {
	while (gdk_events_pending()) {
	    event = gdk_event_get();
	    if (event) {
		switch (event->type) {
		case GDK_DESTROY:
		    gdk_exit(0);
		    exit(0);
		    break;
		case GDK_ENTER_NOTIFY:
		    entering_aquarium();
		    break;
		case GDK_LEAVE_NOTIFY:
		    leaving_aquarium();
		    break;
		default:
		    break;
		}
	    }
	}

	usleep(20000);
	aquarium_update(NULL);
    }


}





  



void aquarium_make_new_applet_wm_with_parent(int window_id, int argc, char *argv[])
{
  AquariumData *a;
    GdkWindowAttr attr;
    GdkPixmap *pixmap, *iconpixmap;
    GdkBitmap *mask, *iconmask;
    GdkPixbuf *backimage, *backimage2, *iconimage;
    char tmp[80];
    char *backimage_file, *iconfile;
    Window win, xss_win=0;
    
#ifdef GTK2
    GError *imerr=NULL;
#else
    Window iconwin;
    GdkWindowAttr attri;
#endif

    XSizeHints sizehints;
    XWMHints wmhints;


    a=get_ad();

    if(window_id!=0) xss_win=(Window)window_id;


    if(!force_es)
      brokenwm = detect_brokenwm();
    else
      brokenwm = 1;


    if (!gdk_init_check(&argc, &argv)) {
	printf
	    ("GDK init failed. Please check that your \"DISPLAY\" variable is correct.\n");
	exit(-1);
    }

    gdk_rgb_init();


    memset(&attr, 0, sizeof(GdkWindowAttr));


      if(window_id!=0){
	a->win=gdk_window_foreign_new(xss_win);
	gdk_window_show(a->win);
	gdk_window_get_geometry(a->win,NULL,NULL,&windowsize_x, &windowsize_y, NULL);
      }



    if(mys.yourown){
#ifdef GTK2
      backimage = gdk_pixbuf_new_from_file(mys.imagename,&imerr);
      if (!backimage) {
	printf("Can't load %s! - wmapplet.c * background\n%s", mys.imagename,imerr->message);
	exit(-1);
      }
#else
      backimage = gdk_pixbuf_new_from_file(mys.imagename);
      if (!backimage) {
	printf("Can't load %s! - wmapplet.c * background\n", mys.imagename);
	exit(-1);
      }
#endif


      /* If a special size is given, keep it! */
      if(windowsize_x==WINDOWSIZE_X) 
	windowsize_x = gdk_pixbuf_get_width(backimage)+8;
      if(windowsize_y==WINDOWSIZE_Y) 
	windowsize_y = gdk_pixbuf_get_height(backimage)+8;
      gdk_pixbuf_unref(backimage);
    }


    attr.width = windowsize_x;
    attr.height = windowsize_y;
    attr.title = "Sherman's aquarium";
    attr.event_mask = GDK_BUTTON_PRESS_MASK | 
                      GDK_ENTER_NOTIFY_MASK | GDK_LEAVE_NOTIFY_MASK;
    attr.wclass = GDK_INPUT_OUTPUT;
    attr.visual = gdk_visual_get_system();
    attr.colormap = gdk_colormap_get_system();
    attr.wmclass_name = "aquarium";
    attr.wmclass_class = "aquarium";
    attr.window_type = GDK_WINDOW_TOPLEVEL;


    
    if(window_id==0){
#ifdef GTK2
      a->win = gdk_window_new(GDK_WINDOW_ROOT, &attr,
			      GDK_WA_TITLE | GDK_WA_WMCLASS |
			      GDK_WA_VISUAL | GDK_WA_COLORMAP);
#else
      memcpy(&attri, &attr, sizeof(GdkWindowAttr));
      a->win = gdk_window_new(NULL, &attr,
			      GDK_WA_TITLE | GDK_WA_WMCLASS |
			      GDK_WA_VISUAL | GDK_WA_COLORMAP);
#endif
    }

    if (!a->win) {
      printf("FATAL: cannot make toplevel window\n");
      exit(1);
    }

#ifndef GTK2
    if(window_id==0){
      a->iconwin =
	gdk_window_new(a->win, &attri, GDK_WA_TITLE | GDK_WA_WMCLASS);
      if (!a->iconwin) {
	printf("FATAL: cannot make icon window\n");
	exit(1);
      }
    }

#endif


    /* Enlightenment can't handle programs that removes all borders and 
       such stuff well. */
    if (brokenwm != 1 && window_id==0) {
	win = GDK_WINDOW_XWINDOW(a->win);
#ifndef GTK2
	iconwin = GDK_WINDOW_XWINDOW(a->iconwin);
#endif

	sizehints.flags = USSize;
	sizehints.width = windowsize_x;
	sizehints.height = windowsize_y;

	XSetWMNormalHints(GDK_WINDOW_XDISPLAY(a->win), win, &sizehints);

	wmhints.initial_state = WithdrawnState;
#ifdef GTK2
	wmhints.icon_window = win; /* Put ourself as iconwin */
#else
	wmhints.icon_window = iconwin;
#endif
	wmhints.icon_x = 0;
	wmhints.icon_y = 0;
	wmhints.window_group = win;
	wmhints.flags =
	    StateHint | IconWindowHint | IconPositionHint |
	    WindowGroupHint;
	XSetWMHints(GDK_WINDOW_XDISPLAY(a->win), win, &wmhints);
    }

    a->gc = gdk_gc_new(a->win);

    if (windowsize_x > WINDOWSIZE_X || windowsize_y >WINDOWSIZE_Y) {
      if(windowsize_x> 2*WINDOWSIZE_X || windowsize_y >2*WINDOWSIZE_Y)
	backimage_file = filename("aquarium/master-gnome.png");
      else
	backimage_file = filename("aquarium/master-wm.png");

      
#ifdef GTK2
      backimage = gdk_pixbuf_new_from_file(backimage_file,&imerr);

      if (!backimage) {
	printf("Can't load %s! - wmapplet.c * gnomeback\n%s\n", backimage_file, imerr->message);
	exit(-1);
      }
#else
      backimage = gdk_pixbuf_new_from_file(backimage_file);

      if (!backimage) {
	printf("Can't load %s! - wmapplet.c * gnomeback\n", backimage_file);
	exit(-1);
      }

#endif

      backimage2 =
	gdk_pixbuf_scale_simple(backimage, windowsize_x, windowsize_y,
				GDK_INTERP_HYPER);
      gdk_pixbuf_render_pixmap_and_mask(backimage2, &pixmap, &mask, 80);
      gdk_pixbuf_unref(backimage2);

      if(window_id!=0){
	xmax = windowsize_x;
	ymax = windowsize_y;
	xmin = ymin =0;
      }
      else{
	xmax = windowsize_x - 8;
	ymax = windowsize_y - 8;
      }

      
      virtual_aquarium_x = xmax + 2 * VIRTUAL_AQUARIUM_DX;
      virtual_aquarium_y = ymax + 2 * VIRTUAL_AQUARIUM_DY;

    } 
    else {
      backimage_file = filename("aquarium/master-wm.png");

#ifdef GTK2
      backimage = gdk_pixbuf_new_from_file(backimage_file, &imerr);
	
      if (!backimage) {
	printf("Can't load %s! - wmapplet.c * wm background\n%s\n", backimage_file, imerr->message);
	exit(-1);
      }
#else
      backimage = gdk_pixbuf_new_from_file(backimage_file);
	
      if (!backimage) {
	printf("Can't load %s! - wmapplet.c * wm background\n", backimage_file);
	exit(-1);
      }

#endif

      gdk_pixbuf_render_pixmap_and_mask(backimage, &pixmap, &mask, 80);
    }

    g_free(backimage_file);

    gdk_pixbuf_unref(backimage);

    gdk_window_shape_combine_mask(a->win, mask, 0, 0);
    gdk_window_set_back_pixmap(a->win, pixmap, False);
#ifndef GTK2
    gdk_window_shape_combine_mask(a->iconwin, mask, 0, 0);
    gdk_window_set_back_pixmap(a->iconwin, pixmap, False);
#endif



    /* Set up icon and icon name */
    if(window_id==0){
      g_snprintf(tmp,sizeof(tmp),"Sherman's aquarium v%s",VERSION);
      gdk_window_set_icon_name(a->win, tmp);
    }


    iconfile = filename("aquarium/sherman_icon.png");

#ifdef GTK2
    iconimage = gdk_pixbuf_new_from_file(iconfile, &imerr);

    if (!iconimage) {
      printf("Can't load %s!\n - wmapplet.c - icon\n%s\n", iconfile, imerr->message);
      exit(-1);
    }
#else
    iconimage = gdk_pixbuf_new_from_file(iconfile);

    if (!iconimage) {
      printf("Can't load %s!\n - wmapplet.c - icon", iconfile);
      exit(-1);
    }

#endif

    g_free(iconfile);

    gdk_pixbuf_render_pixmap_and_mask(iconimage, &iconpixmap, &iconmask, 80);
    
    gdk_pixbuf_unref(iconimage);


    if(window_id==0)
      gdk_window_set_icon(a->win, NULL, iconpixmap, iconmask);

    /* Refuse to change size of the window */
    gdk_window_set_hints(a->win, 0,0, windowsize_x, windowsize_y, 
			 windowsize_x, windowsize_y, 
			 GDK_HINT_MIN_SIZE|GDK_HINT_MAX_SIZE);

    gdk_window_show(a->win);

    /* We can only move a window that is realised. */
    if (posx != -1 && posy != -1 && window_id==0){
	gdk_window_move(a->win, posx, posy);
#ifndef GTK2
	gdk_window_move(a->iconwin,posx,posy);
#endif
    }

}


/* This function makes the dockapp window */
void aquarium_make_new_applet_wm(int argc, char *argv[])
{
  aquarium_make_new_applet_wm_with_parent(0,argc,argv);
}
