#include "draw.h"
#include "defines.h"
#include "aquarium.h"

/* draw a sprite into ad.image (palette-based) */
void draw_fish(int x, int y, int idx, int rev, int width, int height,
	       unsigned char *fishpic)
{
  AquariumData *a;

    /* bounding box of the clipped sprite */
    int dw, di, dh, ds;
    /* loop counters */
    int w, h;
    /* offset into image buffer */
    int pos;

    int fidx;

    a=get_ad();

    /* completely off the screen, don't bother drawing */
    if ((y < (-height)) || (y > (ymax)) || (x > (xmax)) || (x < -(width)))
	return;


    /* do clipping for top side */
    ds = 0;
    if (y < 0)
	ds = -(y);

    /* do clipping for bottom side */
    dh = height;
    if ((y + height) > ymax)
	dh = ymax - y;

    /* do clipping for right side */
    dw = width;
    if ((x + width) > xmax)
	dw = width - ((x + width) - xmax);

    /* do clipping for left side */
    di = 0;
    if (x < 0)
	di = -(x);

    fidx = width * height * 4 * idx;

    if (rev) {

	/* The fish is moving in different direction */
	for (h = ds; h < dh; h++) {
	    /* offset to beginning of current row */
	    int ypos = (h + y) * xmax * 3;
	    int q = 0;
	    for (w = dw; w > di; w--) {
		int pic_pos =
		    h * width * 4 + (q + (width - dw)) * 4 + fidx;
		if (fishpic[pic_pos + 3] != 0) {
		    pos = ypos + w * 3 + x * 3 - 3;
		    a->rgb[pos] = fishpic[pic_pos];
		    a->rgb[pos + 1] = fishpic[pic_pos + 1];
		    a->rgb[pos + 2] = fishpic[pic_pos + 2];
		}

		q++;
	    }

	    //if(di!=0) printf("di:%d dw:%d\n",di,dw);


	}
    } else {

	for (h = ds; h < dh; h++) {
	    /* offset to beginning of current row */
	    int ypos = (h + y) * xmax * 3;
	    for (w = di; w < dw; w++) {
		int pic_pos = h * width * 4 + w * 4 + fidx;
		pos = ypos + w * 3 + x * 3;
		if (fishpic[pic_pos + 3] != 0) {
		    a->rgb[pos] = fishpic[pic_pos];
		    a->rgb[pos + 1] = fishpic[pic_pos + 1];
		    a->rgb[pos + 2] = fishpic[pic_pos + 2];
		}
	    }

	}

    }
}



/* draw a fish into ad.rgb with alpha-blend */
void
draw_pic_alpha(unsigned char *buff, int width, int height, int x,
	       int y, int frame, int alpha)
{
    /* bounding box of the clipped sprite */
    int dw, di, dh, ds;
    /* loop counters */
    int w, h;
    /* offset into rgb buffer */
    int pos, fidx;

    AquariumData *a;

    a=get_ad();

    /* completely off the screen, don't bother drawing */
    if ((y < -(height)) || (y > ymax) || (x > xmax) || (x < -(width)))
	return;

    /* do clipping for top side */
    ds = 0;
    if (y < 0)
	ds = -(y);

    /* do clipping for bottom side */
    dh = height;
    if ((y + height) > ymax)
	dh = ymax - y;

    /* do clipping for right side */
    dw = width;
    if (x > (xmax - width))
	dw = width - (x - (xmax - width));

    /* do clipping for left side */
    di = 0;
    if (x < 0)
	di = -(x);

    fidx = width * 4 * height * frame;

    for (h = ds; h < dh; h++) {

	/* offset to beginning of current row */

	int ypos = (h + y) * xmax;

	for (w = di; w < dw; w++) {

	    int pic_pos = h * width * 4 + w * 4 + fidx;

	    if (buff[pic_pos + 3] != 0) {

		pos = (ypos + w + x) * 3;

		a->rgb[pos] = (alpha * (int) a->rgb[pos]
			       + (256 - alpha) * (int) buff[pic_pos]) >> 8;

		a->rgb[pos + 1] = (alpha * (int) a->rgb[pos + 1]
				   + (256 - alpha) * (int) buff[pic_pos +
								1]) >> 8;

		a->rgb[pos + 2] = (alpha * (int) a->rgb[pos + 2]
				   + (256 - alpha) * (int) buff[pic_pos +
								2]) >> 8;

	    }
	}
    }
}



/* draw antialiased line from (x1, y1) to (x2, y2), with width linewidth
 * color is an int like 0xRRGGBB */
void anti_line(int x1, int y1, int x2, int y2, int linewidth, int color)
{
  AquariumData *a;

    int dx = abs(x1 - x2);
    int dy = abs(y1 - y2);
    int error, sign, tmp;
    float ipix;
    int step = linewidth;

  a=get_ad();


    if (dx >= dy) {
	if (x1 > x2) {
	    tmp = x1;
	    x1 = x2;
	    x2 = tmp;
	    tmp = y1;
	    y1 = y2;
	    y2 = tmp;
	}
	error = dx / 2;
	if (y2 > y1)
	    sign = step;
	else
	    sign = -step;

	putpixel(x1, y1, 1, linewidth, color);

	while (x1 < x2) {
	    if ((error -= dy) < 0) {
		y1 += sign;
		error += dx;
	    }
	    x1 += step;
	    ipix = (float) error / dx;

	    if (sign == step)
		ipix = 1 - ipix;

	    putpixel(x1, y1, 1, linewidth, color);
	}
	putpixel(x2, y2, 1, linewidth, color);
    } else {
	if (y1 > y2) {
	    tmp = x1;
	    x1 = x2;
	    x2 = tmp;
	    tmp = y1;
	    y1 = y2;
	    y2 = tmp;
	}
	error = dy / 2;

	if (x2 > x1)
	    sign = step;
	else
	    sign = -step;

	putpixel(x1, y1, 1, linewidth, color);

	while (y1 < y2) {
	    if ((error -= dx) < 0) {
		x1 += sign;
		error += dy;
	    }
	    y1 += step;
	    ipix = (float) error / dy;

	    if (sign == step)
		ipix = 1 - ipix;

	    putpixel(x1, y1, 1, linewidth, color);
	}
	putpixel(x2, y2, 1, linewidth, color);
    }
}

/* put alpha-blended pixel on the backbuffer.  Uses floats, could be
 * optimized, probably */
void putpixel(int x, int y, float i, int linewidth, int color)
{
  AquariumData *a;

    int pos = (y * xmax * 3) + x * 3;
    unsigned char r,g,b;

    a=get_ad();

    r = ((color >> 16) & 0xff) * i + (a->rgb[pos]) * (1 - i);
    g = ((color >> 8) & 0xff) * i + (a->rgb[pos + 1]) * (1 - i);
    b = (color & 0xff) * i + (a->rgb[pos + 2]) * (1 - i);


    if (linewidth == 1) {
	a->rgb[pos] = r;
	a->rgb[pos + 1] = g;
	a->rgb[pos + 2] = b;
    } else {
	int dx, dy;
	for (dx = x; dx < x + linewidth; dx++) {
	    for (dy = y; dy < y + linewidth; dy++) {
		pos = (dy * xmax * 3) + dx * 3;
		a->rgb[pos] = r;
		a->rgb[pos + 1] = g;
		a->rgb[pos + 2] = b;
	    }
	}
    }
}
