/***************************************************************************
                          file_operation.cpp  -  description
                             -------------------
    begin                : Tue Oct 2 2001
    copyright            : (C) 2001 by Juan Sebastian Linietsky
    email                : reduz@anime.com.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "file_operation.h"

void File_Operation::save_song(string p_filename) {

	Properties savefile;
	string section;
	int i,j,k;
	char aux_str[30];

	savefile.set_header_check("ShakeTracker Module");

	section="VERSION";
	savefile.add_section(section);
	
	savefile.add_property(section,"version",song->get_version_string());

	section="INFO";
	savefile.add_section(section);

	savefile.add_property(section,"name",song->info.name);
	savefile.add_property(section,"author",song->info.author);

	section="SPEED";
	savefile.add_section(section);

	savefile.add_property(section,"rpq",song->speed.rpq);
	savefile.add_property(section,"tempo",song->speed.tempo);

	section="TRACKS";
	savefile.add_section(section);

	savefile.add_property(section,"amount",song->get_tracks());

	for (i=0;i<song->get_tracks();i++) {

		Instrument::Initial_Value_List::iterator I=song->get_instrument(i)->initial_value.begin();
         	
		sprintf(aux_str,"TRACK %i INFO",i);
		section=aux_str;
		savefile.add_section(section);

		savefile.add_property(section,"width",song->get_track_width(i));
		savefile.add_property(section,"name",song->get_instrument(i)->name);	
		savefile.add_property(section,"mute",song->get_instrument(i)->mute);	
		savefile.add_property(section,"default_volume",song->get_instrument(i)->def_volume.get());	
		savefile.add_property(section,"global_volume",song->get_instrument(i)->glb_volume.get());
		savefile.add_property(section,"PNVA_type",song->get_instrument(i)->PNVA_type.get());	
		savefile.add_property(section,"PNVA_controller",song->get_instrument(i)->PNVA_controller.get());	
		savefile.add_property(section,"midi_device",song->get_instrument(i)->midi.device.get());	
		savefile.add_property(section,"midi_bank",song->get_instrument(i)->midi.bank.get());	
		savefile.add_property(section,"midi_patch",song->get_instrument(i)->midi.patch.get());	
		savefile.add_property(section,"midi_channel",song->get_instrument(i)->midi.channel.get());	
		savefile.add_property(section,"midi_pitch_bend_sensitivity",song->get_instrument(i)->midi.PBS.get());	
		savefile.add_property(section,"initial_values",song->get_instrument(i)->initial_value.size());

                for (j=0;j<song->get_instrument(i)->initial_value.size();j++) {

					
			sprintf(aux_str,"initial_value_%i_",j);
			string property=aux_str;
	
			savefile.add_property(section,property+"type",I->type);
			savefile.add_property(section,property+"number",I->controller);
			savefile.add_property(section,property+"value",I->value.get());
			I++;
                }
	}

	section="DEVICES";
	savefile.add_section(section);
	savefile.add_property(section,"amount",song->user_devices.get_device_count());

	for (i=0;i<song->user_devices.get_device_count();i++) {

		sprintf(aux_str,"DEVICE %i INFO",i);
		section=aux_str;
		savefile.add_section(section);

		savefile.add_property(section,"name",song->user_devices.get_device(i)->name);
		savefile.add_property(section,"hardware_index",song->user_devices.get_device(i)->hardware_device_index);
		savefile.add_property(section,"banks",song->user_devices.get_device(i)->instrument_map.get_banks_count());

                for (j=0;j<song->user_devices.get_device(i)->instrument_map.get_banks_count();j++) {

					
			sprintf(aux_str,"bank_%i_",j);
			string property=aux_str;

			savefile.add_property(section,property+"name",song->user_devices.get_device(i)->instrument_map.bank[j]->name);
			savefile.add_property(section,property+"method",song->user_devices.get_device(i)->instrument_map.bank[j]->bank_select_method);
			savefile.add_property(section,property+"MSB",song->user_devices.get_device(i)->instrument_map.bank[j]->MSB);
			savefile.add_property(section,property+"LSB",song->user_devices.get_device(i)->instrument_map.bank[j]->LSB);
			savefile.add_property(section,property+"select_string",song->user_devices.get_device(i)->instrument_map.bank[j]->custom_bank_select_string);

	                for (k=0;k<128;k++) {

					
				sprintf(aux_str,"patch_%i",k);
				string property2=property+aux_str;

				savefile.add_property(section,property2,song->user_devices.get_device(i)->instrument_map.bank[j]->patch_names[k]);
			}
		}		
	}

	section="ORDER LIST";

	savefile.add_section(section);

	savefile.add_property(section,"max_order",song->get_max_order());

	for (i=0;i<song->get_max_order();i++) {

		string order;
		sprintf(aux_str,"order_%i",i);
		order=aux_str;		

		savefile.add_property(section,order,song->get_order(i));
	}

	section="PATTERNS";
	savefile.add_section(section);

	savefile.add_property(section,"amount",song->get_patterns());

	for (i=0;i<song->get_patterns();i++) {

		sprintf(aux_str,"PATTERN %i DATA",i);
		section=aux_str;
		savefile.add_section(section);
		Note clear_note;
                int notecount=0;

		savefile.add_property(section,"length",song->get_pattern_length(i));
		savefile.add_property(section,"hl_major",song->get_pattern_hl_major(i));
		savefile.add_property(section,"hl_minor",song->get_pattern_hl_minor(i));

		for(j=0;j<song->get_abs_width();j++) {

			for(k=0;k<song->get_pattern_length(i);k++) {

				Note aux_note=song->abs_note(j,song->get_global_row(k,i));

				if (!(aux_note==clear_note)) {
						
					string note_loc,note_string;
					sprintf(aux_str,"note_%i",notecount);
					note_loc=aux_str;

					note_string=get_str_from_char(aux_note.note);
					note_string+=get_str_from_char(aux_note.volume);
					note_string+=get_str_from_char(aux_note.command);
					note_string+=get_str_from_char(aux_note.parameter);
					note_string+=get_str_from_char(aux_note.controller_set);
					note_string+=get_str_from_char(aux_note.controller_value);
					note_string+=get_str_from_char(j);
					note_string+=get_str_from_char(k);


                 			savefile.add_property(section,note_loc,note_string);
					notecount++;
				}
			}
		}		

		savefile.add_property(section,"note_count",notecount);
	}

	savefile.save_to_file(p_filename);

}

void File_Operation::load_song(string p_filename) {

	Properties loadfile;

	string section;
	int i,j,k;
	char aux_str[30];
	int device_count,track_count,bank_count,order_count,pattern_count;


	loadfile.set_header_check("ShakeTracker Module");
	if (loadfile.load_from_file(p_filename)) return;

	song->reset();
	song->user_devices.delete_device(0); //defaults, defaults.

	section="VERSION";
	
//	loadfile.get__property(section,"version",song->get_version_string());

	section="INFO";

	song->info.name=loadfile.get_str_property(section,"name");
	song->info.author=loadfile.get_str_property(section,"author");

	section="SPEED";

	song->speed.rpq=loadfile.get_int_property(section,"rpq");
	song->speed.tempo=loadfile.get_int_property(section,"tempo");

	section="TRACKS";

	track_count=loadfile.get_int_property(section,"amount");

	for (i=0;i<track_count;i++) {

		Instrument::Initial_Value aux_ivalue;
         	
		sprintf(aux_str,"TRACK %i INFO",i);
		section=aux_str;
		int ivalues,columns;
                columns=loadfile.get_int_property(section,"width");
		song->add_track(columns);

		song->get_instrument(i)->name=loadfile.get_str_property(section,"name");	
		song->get_instrument(i)->mute=loadfile.get_int_property(section,"mute");	
		song->get_instrument(i)->def_volume=loadfile.get_int_property(section,"default_volume");	
		song->get_instrument(i)->glb_volume=loadfile.get_int_property(section,"global_volume");
		song->get_instrument(i)->PNVA_type=loadfile.get_int_property(section,"PNVA_type");	
		song->get_instrument(i)->PNVA_controller=loadfile.get_int_property(section,"PNVA_controller");	
		song->get_instrument(i)->midi.device=loadfile.get_int_property(section,"midi_device");	
		song->get_instrument(i)->midi.bank=loadfile.get_int_property(section,"midi_bank");	
		song->get_instrument(i)->midi.patch=loadfile.get_int_property(section,"midi_patch");	
		song->get_instrument(i)->midi.channel=loadfile.get_int_property(section,"midi_channel");	
		song->get_instrument(i)->midi.PBS=loadfile.get_int_property(section,"midi_pitch_bend_sensitivity");	
		ivalues=loadfile.get_int_property(section,"initial_values");

                song->get_instrument(i)->initial_value.clear();

                for (j=0;j<ivalues;j++) {

					
			sprintf(aux_str,"initial_value_%i_",j);
			string property=aux_str;
			
			aux_ivalue.type=loadfile.get_int_property(section,property+"type");
			aux_ivalue.controller=loadfile.get_int_property(section,property+"number");
			aux_ivalue.value=loadfile.get_int_property(section,property+"value");
			song->get_instrument(i)->initial_value.push_back(aux_ivalue);
                }
	}

	section="DEVICES";

	device_count=loadfile.get_int_property(section,"amount");

	for (i=0;i<device_count;i++) {

		sprintf(aux_str,"DEVICE %i INFO",i);
		section=aux_str;

		song->user_devices.add_device();

		song->user_devices.get_device(i)->name=loadfile.get_str_property(section,"name");
		song->user_devices.get_device(i)->hardware_device_index=loadfile.get_int_property(section,"hardware_index");


		bank_count=loadfile.get_int_property(section,"banks");

                for (j=0;j<bank_count;j++) {

					
			sprintf(aux_str,"bank_%i_",j);
			string property=aux_str;

			song->user_devices.get_device(i)->instrument_map.add_bank();

			song->user_devices.get_device(i)->instrument_map.bank[j]->name=loadfile.get_str_property(section,property+"name");
			song->user_devices.get_device(i)->instrument_map.bank[j]->bank_select_method=loadfile.get_int_property(section,property+"method");
			song->user_devices.get_device(i)->instrument_map.bank[j]->MSB=loadfile.get_int_property(section,property+"MSB");
			song->user_devices.get_device(i)->instrument_map.bank[j]->LSB=loadfile.get_int_property(section,property+"LSB");
			song->user_devices.get_device(i)->instrument_map.bank[j]->custom_bank_select_string=loadfile.get_str_property(section,property+"select_string");

	                for (k=0;k<128;k++) {

					
				sprintf(aux_str,"patch_%i",k);
				string property2=property+aux_str;

				song->user_devices.get_device(i)->instrument_map.bank[j]->patch_names[k]=loadfile.get_str_property(section,property2);
			}
		}		
	}

	section="ORDER LIST";

        order_count=loadfile.get_int_property(section,"max_order");
	
	for (i=0;i<order_count;i++) {

		string order;
		sprintf(aux_str,"order_%i",i);
		order=aux_str;		

		song->set_order(i,loadfile.get_int_property(section,order));
	}

	section="PATTERNS";

	pattern_count=loadfile.get_int_property(section,"amount");

	for (i=0;i<song->get_patterns();i++) {
                int notecount;
		sprintf(aux_str,"PATTERN %i DATA",i);
		section=aux_str;

		song->set_pattern_length(i,loadfile.get_int_property(section,"length"));
		song->set_pattern_hl_major(i,loadfile.get_int_property(section,"hl_major"));
		song->set_pattern_hl_minor(i,loadfile.get_int_property(section,"hl_minor"));



		notecount=loadfile.get_int_property(section,"note_count");

		for(j=0;j<notecount;j++) {

			Note aux_note;
			string note_loc,note_string;
			int row,col;
			sprintf(aux_str,"note_%i",j);
			note_loc=aux_str;

      			note_string=loadfile.get_str_property(section,note_loc);
			if (note_string=="") continue;

			aux_note.note=get_char_from_str(note_string,0);
			aux_note.volume=get_char_from_str(note_string,2);
			aux_note.command=get_char_from_str(note_string,4);
			aux_note.parameter=get_char_from_str(note_string,6);
			aux_note.controller_set=get_char_from_str(note_string,8);
			aux_note.controller_value=get_char_from_str(note_string,10);

			col=get_char_from_str(note_string,12);
			row=get_char_from_str(note_string,14);

			song->abs_note_ref(col,song->get_global_row(row,i))=aux_note;			

		}		
	}
}

string File_Operation::get_str_from_char(Uint8 p_val) {

	string aux;
	aux="00";
	aux[0]='A'+(p_val>>4);
	aux[1]='A'+(p_val&15);
	return aux;
}

Uint8 File_Operation::get_char_from_str(string p_str,int p_pos) {

	Uint8 h,l;

	h=(p_str[p_pos]-'A');
	l=(p_str[p_pos+1]-'A');
	h<<=4;
	h|=l;
	return h;
}


File_Operation::File_Operation(){
}
File_Operation::~File_Operation(){
}
