/***************************************************************************
                          effect.h  -  description
                             -------------------
    begin                : Sat Aug 18 2001
    copyright            : (C) 2001 by Juan Sebastian Linietsky
    email                : reduz@anime.com.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef EFFECT_H
#define EFFECT_H

#include "event_basic.h"
#include "player_data.h"
#include "event_queue.h"

/**
  *@author Juan Sebastian Linietsky
  */

class Effect {
protected:
	int time_divisor; //some sort of static constant variable. constant for now :)
        Event_Queue *queue;
        Uint8 parameter;
	int track,column;
	Player_Data *data;
	bool processing;
public:
        enum Flags {

		PROCESS_NOTE=1,
		PROCESS_COMMAND=2
	};
	virtual void notify_command(Uint8 p_parameter);
	virtual int notify_begin(Uint8 p_note,Uint8 p_volume,Uint8 p_old_note); //returns Flags

	void set_track(int p_track);
	void set_column(int p_column);

       	virtual void process(int p_time_amount,int p_time_offset);
        virtual void begin_notify();
        virtual void stop_notify();
        void reset();
       	void set_event_queue(Event_Queue *p_queue);
	void set_player_data(Player_Data *p_data);
	bool has_processing();

	Effect();
	virtual ~Effect();
};

class Effect_Vibrato : public Effect {

	float depth,speed,pos,val;
	static const int sine_table[256];
public:

	void notify_command(Uint8 p_parameter) {

	       	if ( (p_parameter!=0) && (p_parameter!=parameter) ) {

			
		      	speed=p_parameter / 0x10;
			depth=p_parameter % 0x10;
			pos=val=0;
			parameter=p_parameter;
		}

	}

	void begin_notify() {

		pos=val=0;
	}
        void stop_notify() {

                set_value(0,0);
	}

	virtual void set_value(int p_time_offset,int p_value)=0;

	void process(int p_time_amount,int p_time_offset) {

		float modifier,max_value;
		int index;

		max_value=0x1000/data->song->get_instrument(track)->midi.PBS.get();
	
		pos+=p_time_amount;

		index=(int)( (float)pos*((float)speed/4) ) % 256;

		modifier=sine_table[index];

		val=depth*modifier*max_value/(0xF*127.0);

                set_value(p_time_offset,val);
		
	}

        Effect_Vibrato() {

                speed=depth=pos=val=0;
		processing=true;
	}

};

#endif
