# Copyright(C) 2004 Tiago Cogumbreiro <cogumbreiro@users.sf.net>
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Library General Public
# License as published by the Free Software Foundation; either
# version 2 of the License, or(at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Library General Public License for more details.
#
# You should have received a copy of the GNU Library General Public
# License along with this library; if not, write to the
# Free Software Foundation, Inc., 59 Temple Place - Suite 330,
# Boston, MA 02111-1307, USA.
#
# Authors: Matthew Martin <xfceslacker@gmail.com>,
#          Tiago Cogumbreiro <cogumbreiro@users.sf.net>

import dbus
from gettext import gettext as _


class InhibitSuspend(object):
    """
    Plugin to enable power inhibiting while writing an audio disc.
    """
    def __init__(self):
        self.bus = dbus.Bus(dbus.Bus.TYPE_SESSION)
        self.devobj = self.bus.get_object('org.gnome.PowerManager',
                                          '/org/gnome/PowerManager')
        self.dev = dbus.Interface(self.devobj, "org.gnome.PowerManager")

    def on_writing_started(self, app):
        self.cookie = self.dev.Inhibit('Serpentine', _('Writing audio disc'))
    
    def on_writing_finished(self, app):
        self.dev.UnInhibit(self.cookie)


def create_plugin(app):
    inhibit = InhibitSuspend()
    app.add_listener(inhibit)
    
