#!/usr/bin/env cwl-runner

# This CWL file was automatically generated using CTDConverter.
# Visit https://github.com/WorkflowConversion/CTDConverter for more information.

baseCommand: roi_plot_thumbnails
class: CommandLineTool
cwlVersion: v1.0
doc: "Create PNG images with plot grids to OUT${i}.png from ROI records in IN.roi.\n\
  \n\n\nFor more information, visit http://www.seqan.de"
inputs:
- default: 'false'
  doc: Verbose mode.
  id: param_verbose
  inputBinding:
    prefix: -verbose
  label: Verbose mode.
  type:
  - 'null'
  - string
- default: 'false'
  doc: Very verbose mode.
  id: param_vverbose
  inputBinding:
    prefix: -vverbose
  label: Very verbose mode.
  type:
  - 'null'
  - string
- doc: ROI to plot.
  id: param_input-file
  inputBinding:
    prefix: -input-file
  label: ROI to plot.
  type: File
- doc: Filename for output-prefix output file
  id: param_output-prefix_filename
  inputBinding:
    prefix: -output-prefix
  label: Filename for output-prefix output file
  type: string
- default: '20000'
  doc: Maximal number of plots to create (0 for all).
  id: param_max-rois
  inputBinding:
    prefix: -max-rois
  label: Maximal number of plots to create (0 for all).
  type:
  - 'null'
  - int
- default: '0'
  doc: Fix maximal y value.  0 for no limit..
  id: param_max-value
  inputBinding:
    prefix: -max-value
  label: Fix maximal y value.  0 for no limit..
  type:
  - 'null'
  - int
- default: '40'
  doc: Number of plots in one row.
  id: param_num-cols
  inputBinding:
    prefix: -num-cols
  label: Number of plots in one row.
  type:
  - 'null'
  - int
- default: '50'
  doc: Number of plots in one column.
  id: param_num-rows
  inputBinding:
    prefix: -num-rows
  label: Number of plots in one column.
  type:
  - 'null'
  - int
- default: '30'
  doc: Height of one plot in px.
  id: param_plot-height
  inputBinding:
    prefix: -plot-height
  label: Height of one plot in px.
  type:
  - 'null'
  - int
- default: '30'
  doc: Width of one plot in px.
  id: param_plot-width
  inputBinding:
    prefix: -plot-width
  label: Width of one plot in px.
  type:
  - 'null'
  - int
- default: '0'
  doc: Border width.
  id: param_border-width
  inputBinding:
    prefix: -border-width
  label: Border width.
  type:
  - 'null'
  - int
- default: '2'
  doc: Space between plots.
  id: param_spacing
  inputBinding:
    prefix: -spacing
  label: Space between plots.
  type:
  - 'null'
  - int
label: Create plot grids for ROI file.
outputs:
- doc: Prefix of output file.
  id: param_output-prefix
  label: Prefix of output file.
  outputBinding:
    glob: $(inputs.param_output-prefix_filename)
  type: File
