#!/bin/bash

if [ $# -ne 1 ]
then
  echo "Usage: `basename $0` {version}"
  exit 1
fi

DOTTED_VERSION=$1
SLASHED_VERSION=$(echo $DOTTED_VERSION|sed 's/\./_/g')
WORKING_DIR="`pwd`/Sentinella$RANDOM"

clean () {
	cd $WORKING_DIR
	cd ..
	rm -rf $WORKING_DIR
}

mkdir $WORKING_DIR
cd $WORKING_DIR
cvs -d:pserver:anonymous@sentinella.cvs.sourceforge.net:/cvsroot/sentinella export -r sentinella-$SLASHED_VERSION -d Sentinella-$DOTTED_VERSION Sentinella

read -p "Have you updated version in main.cpp? (y/n) " yn
if  [ $yn != "y" ]; then
	clean
	exit 2
fi

head Sentinella-$DOTTED_VERSION/CHANGELOG
read -p "Have you updated the changelog? (y/n) " yn
if  [ $yn != "y" ]; then
	clean
	exit 2
fi

chmod -x Sentinella-$DOTTED_VERSION/src/Actions/*
chmod -x Sentinella-$DOTTED_VERSION/src/Conditions/*
mkdir Sentinella-$DOTTED_VERSION/build
tar -zcvf Sentinella-$DOTTED_VERSION.tar.gz Sentinella-$DOTTED_VERSION
mv Sentinella-$DOTTED_VERSION.tar.gz ..
clean
