/***************************************************************************
 *  Module: $Id: sendpage.c,v 2.18 1997/12/31 05:18:32 nemesis Exp nemesis $
 *  Description: sendpage main module
 *  Author:      maf, cjc
 *
 * Copyright (c) 1995 Mark Fullmer and The Ohio State University
 * Copyright (c) 1997 Cornelius Cook and Counterpoint Networking, Inc.
 * http://www.cpoint.net/projects/sendpage
 ***************************************************************************/
/*
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/*
$Log: sendpage.c,v $
Revision 2.18  1997/12/31 05:18:32  nemesis
CLOCAL for all, GCC fixes, WAIT_WORD finished

Revision 2.17  1997/12/28 23:20:45  nemesis
include cleanups, configure additions/corrections

Revision 2.16  1997/12/26 02:37:31  nemesis
code clean up, b* -> mem* funcs, finding NL -> # bug

Revision 2.15  1997/12/25 08:30:52  nemesis
code cleanups

Revision 2.14  1997/12/25 06:44:34  nemesis
time_t declarations and "make install" fix

Revision 2.13  1997/12/24 21:50:04  nemesis
mailing list updates

Revision 2.12  1997/12/24 21:42:54  nemesis
0.8a released.

Revision 2.11  1997/12/24 21:02:02  nemesis
more changes

Revision 2.10  1997/12/24 20:56:03  nemesis
gearing up for 0.8a more

Revision 2.9  1997/12/24 20:45:35  nemesis
trying to make 0.8a release

Revision 2.8  1997/12/24 20:29:08  nemesis
fixed up autoconf modifications, cleaned up signal stuff

Revision 2.7  1997/12/24 20:15:13  nemesis
sendpage.h now mostly contained within 'configure'

Revision 2.6  1997/12/24 19:52:04  nemesis
fixing posix checking

Revision 2.5  1997/12/24 19:41:49  nemesis
posix additions, syslog autoconf'd

Revision 2.4  1997/12/24 19:33:03  nemesis
check for POSIX

Revision 2.3  1997/12/17 09:37:27  nemesis
more autoconf changes... mostly strerror.o

Revision 2.2  1997/12/17 08:24:05  nemesis
autoconf-ing

Revision 2.1  1997/12/17 08:03:38  nemesis
adjustments

Revision 2.0  1997/12/17 08:01:05  nemesis
setting up autoconf

Revision 1.9  1997/12/17 07:56:23  nemesis
starting on the autoconfing

Revision 1.8  1997/12/17 04:47:05  nemesis
still adjusting

Revision 1.7  1997/12/17 04:46:25  nemesis
adjusting version numbers

Revision 1.6  1997/12/17 04:44:36  nemesis
*** empty log message ***

Revision 1.2  1997/12/15 17:41:11  nemesis
Added patches from Steve Kennedy <steve@demon.net>
See http://www.gbnet.net/public/paging/sendpage-multi/

Revision 1.1  1997/12/15 15:57:10  nemesis
Initial revision

*/

#include "version.h"
#include "sendpage.h"
#include "report.h"
#include "daemon.h"
#include "deliver.h"
#include "queue.h"
#include "client.h"
#include "cf.h"
#include "verify.h"

int debug;
int need_readconfig, need_runqueue, need_quit;
int alias_recurse_depth;
int do_longjump;
int got_sigpipe;
char *progname;	

/* environment to pass children - used when fork()ing for sendmail 
 * and/or pipe style aliases */
char *sendpage_env[] = {
	"PATH=/usr/bin:/bin:/usr/sbin:/sbin:/usr/ucb",
	"SHELL=/bin/sh",
	0
};

struct profile defaultProfile = { "", "", "",
	PROF_FLAGS_MAIL_GOOD|PROF_FLAGS_MAIL_BAD, 0 };

struct global globalOptions = { 640, 5, LOG_MAIL, GLOBAL_FLAGS_MONTH_FIRST|
	GLOBAL_FLAGS_SET_REPLYTO, "sendpage@unconfigured.com" };

void Usage() {
	fprintf(stderr, "%s, Copyright (C) 1997 Cornelius Cook\n",SendpageVersion);
	fprintf(stderr, "This program comes with ABSOLUTELY NO WARRANTY;\n"); 
	fprintf(stderr, "This is free software, and you are welcome to redistribute it\n");
    	fprintf(stderr, "under the conditions of the GNU General Public License.\n\n");
	fprintf(stderr, " -bv   Verify alias mode\n");
	fprintf(stderr, " -bd   Run in daemon mode\n");
	fprintf(stderr, " -bds  Run in daemon mode with SNPP support\n");
	fprintf(stderr,
		" -bp   Print queue - will also work if invoked as 'pageq'\n");
	fprintf(stderr,
		" -d n  Set debug level to n\n");
	fprintf(stderr,
		" -f s  Set sender to s, normally set with getpwuid(getuid)\n");
	fprintf(stderr,
		" -P n  Set SNPP port to bind to\n");
	fprintf(stderr,
		" -B    parse the input as an RFC822 mail message gathering data from the body\n");
	fprintf(stderr, " -c <header>  parse the input as an RFC822 mail message gathering data from\n       this header\n");
	fprintf(stderr, " -n    Don't send mail response\n");
	fprintf(stderr, " -i    Force immediate queue run\n");
	fprintf(stderr, " -p    Ignore pid file\n");
	fprintf(stderr, " -h/?  This message\n");
	fprintf(stderr, " -S    Try to strip out signature files\n");

	fprintf(stderr, "\n\n");
} /* Usage */

/*********************************************************************
 * Function: main
 *	program sendpage 
 *
 * Returns: EX_OK	(0)	good
 *			!0			bad (return codes for client are set for use
 *						with sendmail.
 *
 *	usage:
 *		bv		verify alias mode
 *		bp		print queue - will also work if invoked as 'pageq'
 *		bd		run in daemon mode
 *		bds		run in daemon and SNPP mode
 *		d:		set debug level
 *		f:		set sender, normally set with getpwuid(getuid)
 *      p       ignore pid file
 *      S       try to silently drop signatures (when using e-mail gw)
 *		n		don't send mail response.
 *		i		force immediate queue run
 *      c:      cut out the arg from the header part of a e-mail message
 *              and if it exists use it as the message
 *      B       use the body of the input formatted as e-mail message
 *              as the message.  
 *	P:	SNPP port number
 *	m	don't perform message mangling.
 *
 *********************************************************************/
int main(int argc, char * argv[]) {
	extern int optind, opterr;
	extern char *optarg;
	extern char *progname;
	int runmode;
	int useBody, x, ret;
	char *sender;
	DB *aliasdb, *pcdb, *trdb, *profdb;
	u_int	ncentral;
	char nullstring[1];
	struct passwd *pwd;
	int nomail;
	int dropSignature, ignorePid;
	int sendnow = 0;
	char header[32];
	int snpp_port = SNPP_PORT;
	int no_mangle = 0;
	
	debug = 0; 			/* debugging off by default */
	useBody = 0;			/* ignore all message lines until there
					   is first a blank line */
	aliasdb = pcdb = trdb = profdb = (DB*)0;
	nullstring[0] = 0;
	sender = nullstring;
	ret = 0; /* good */
	alias_recurse_depth = 0;/* for alias recursion loop testing */
	dropSignature = 0;	/* don't try to drop signature */
	nomail = 0;
	ignorePid = 0;		/* don't ignore pid */
	header[0] = 0;

	progname = strrchr(argv[0], '/');
	if (progname)
		progname ++;
	else
		progname = argv[0];

	if (!strcmp(progname, "pageq"))
		runmode = RUN_PRINTQUEUE;
	else if (!strcmp(progname, "sendpage"))
		runmode = RUN_CLIENT;
	else {
		fprintf(stderr, "sendpage: unknown mode (%s)\n", progname);
		exit (EX_SOFTWARE);
	}


	while ((x = getopt(argc, argv, "pmBSf:d:b:P:nh?ic:")) != -1) 

		switch (x) {

		case 'b':
			if (optarg[0] == 'd') {
				runmode = RUN_DAEMON;
				if (optarg[1] == 's')
					runmode = RUN_DAEMON_SNPP;
			}
			else if (optarg[0] == 'p')
				runmode = RUN_PRINTQUEUE;
			else if (optarg[0] == 'v')
				runmode = RUN_VERIFY;
			else
				runmode = RUN_UNKNOWN;
			break;

		case 'c':
			if ((strlen(optarg)+1) > sizeof(header)) {
				fprintf(stderr, "Header too long.\n");
				exit (EX_SOFTWARE);
			}
			strncpy(header, optarg, 32);
			break;

		case 'd':
			debug = atoi(optarg);
			break;

		case 'P':
			snpp_port = atoi(optarg);
			break;

		case 'n':
			nomail = 1;
			break;

		case 'p':
			ignorePid = 1;
			break;

		case 'B':
			useBody = 1;
			break;

		case 'f':
			sender = optarg;
			break;

		case '?':
		case 'h':
			Usage();
			exit (0);
			break;  /* not reached */

		case 'S':
			dropSignature = 1;
			break;

		case 'i':
			sendnow = 1;
			break;

		case 'm':
			no_mangle = 1;
			break;

		default:
			Usage();
			exit (EX_SOFTWARE);
			break;   /* not reached */

		} /* end switch */

	if (chdir(PATH_QUEUE) == -1) {
		perror(PATH_QUEUE);
		exit (EX_SOFTWARE);
	}

	/* initialize logging - borrowed from CMU's bootpd */
	/* the daemon code needs to start this itself sence it closes all fd's */

	if (runmode != RUN_DAEMON)
		report_init (0); 

	if ((runmode == RUN_DAEMON) || (runmode == RUN_DAEMON_SNPP)) {

		if (runmode == RUN_DAEMON) {
			if (BeADaemon(ignorePid)) {
				fprintf(stderr, "Daemon failed to start.\n");
				exit (1);
			}
		}
		else {
			if (BeADaemonSNPP(ignorePid, snpp_port)) {
				fprintf(stderr, "Daemon (SNPP) failed to start.\n");
				exit (1);
			}
		}
			

		if (Deliver()) {
			fprintf(stderr,
				"Delivery code failure - Daemon failed to start.\n");
			exit (1);
		}

	} else if (runmode == RUN_PRINTQUEUE) {

		PrintMessageQueue();
		exit (1);

	} else if (runmode == RUN_CLIENT) {

		/* try to set the sender if it's not allready set */
		if (!sender[0]) 
			if ((pwd = (struct passwd*)getpwuid(getuid())))
				sender = pwd->pw_name;
		
		ret = BeAClient(argc, argv, optind, useBody, sender, sendnow,
			dropSignature, nomail, header);

	} else if (runmode == RUN_VERIFY) {

		if (ReadConfig(&aliasdb, &pcdb, &trdb, &profdb, &ncentral,
				PATH_SENDPAGE_CONFIG)) {
			fprintf(stderr, "ReadConfig() failed\n");
			exit (1);
		}
		ret = VerifyMode(aliasdb, pcdb, profdb);

	}

	return ret;

} /* main */

