/* load_policy.c
 *
 * used to load a new policy configuration from a file containing
 * a binary representation of the configuration
 */

#include <ss.h>
#include <stdlib.h>
#include <string.h>

int main(int argc, char **argv)
{
	int ret_val;

	if (argc != 2) {
		printf("usage:  %s path\n", argv[0]);
		exit(1);
	}

	ret_val = security_load_policy(argv[1], strlen(argv[1]) + 1);

	if (ret_val) {
		perror("security_load_policy");
		exit(2);
	}

	printf("\nSuccess\n");
	exit(0);
}
