#include <sys/socket.h>
#include <lsm.h>

int 
sendto_secure(int s, const void *buf, int len, unsigned int flags, 
	      struct sockaddr *addr, int addrlen, security_id_t dso_sid, 
	      security_id_t msg_sid)
{
	unsigned long args[8];

	args[0] = s;
	args[1] = (unsigned long)buf;
	args[2] = len;
	args[3] = flags;
	args[4] = (unsigned long)addr;
	args[5] = addrlen;
	args[6] = dso_sid;
	args[7] = msg_sid;

	return lsm(SELINUX_MAGIC, SELINUXCALL_SENDTO, args);
}
