#include <sys/types.h>
#include <sys/stat.h>
#include <sys/statfs.h>
#include <fcntl.h>
#include <unistd.h>
#include <linux/flask/flask.h>

extern int open_secure(const char *pathname, 
		       int flags, 
		       mode_t mode, 
		       security_id_t sid);

extern int mkdir_secure(const char *pathname, 
			mode_t mode, 
			security_id_t sid);

extern int mknod_secure(const char *pathname, 
			 mode_t mode, 
			 dev_t dev, 
			 security_id_t sid);

extern int symlink_secure(const char *oldpath, 
			  const char *newpath, 
			  security_id_t sid);

extern int chsid(const char *pathname, 
		 security_id_t sid);

extern int lchsid(const char *pathname, 
		  security_id_t sid);

extern int fchsid(unsigned int fd, 
		  security_id_t sid);

extern int chsidfs(const char *pathname, 
		   security_id_t fs_sid, 
		   security_id_t f_sid);

extern int fchsidfs(unsigned int fd, 
		    security_id_t fs_sid, 
		    security_id_t f_sid);

#ifndef __USE_FILE_OFFSET64
extern int stat_secure(const char *pathname, 
		       struct stat *buf, 
		       security_id_t *out_sid);
extern int lstat_secure(const char *pathname, 
			struct stat *buf, 
			security_id_t *out_sid);
extern int fstat_secure(unsigned int fd, 
			struct stat *buf, 
			security_id_t *out_sid);
#else
# ifdef __REDIRECT
extern int __REDIRECT (stat_secure,
		       (const char * __file,
			struct stat *__buf,
			security_id_t *sid) __THROW,
		       stat64_secure);
extern int __REDIRECT (lstat_secure,
		       (const char * __file,
			struct stat *__buf,
			security_id_t *sid) __THROW,
		       lstat64_secure);
extern int __REDIRECT (fstat_secure, (int __fd, struct stat *__buf, security_id_t *sid) __THROW, fstat64_secure);
# else
#  define stat_secure stat64_secure
#  define lstat_secure lstat64_secure
#  define fstat_secure fstat64_secure
# endif
#endif
#ifdef __USE_LARGEFILE64
extern int stat64_secure(const char *pathname, 
			 struct stat64 *buf, 
			 security_id_t *out_sid);
extern int lstat64_secure(const char *pathname, 
			  struct stat64 *buf, 
			  security_id_t *out_sid);
#endif

extern int statfs_secure(const char *pathname, 
			 struct statfs *buf, 
			 security_id_t *out_sid);

extern int fstatfs_secure(unsigned int fd, 
			  struct statfs *buf, 
			  security_id_t *out_sid);




