#include <time.h>
#include <gtk/gtk.h>

#include <scwview.h>
#include <scwentry.h>

/* FIXME: Don't do this, it's only to simplify the test program */
GtkWidget *view;

void delete_win (GtkWidget *widget, gpointer user_data)
{
  gtk_widget_destroy (widget);
  gtk_main_quit ();
}

void on_activated (ScwView *view, gchar *id, gchar *action_data, gpointer user_data)
{
  g_print ("Activated id='%s', data='%s'\n", id, action_data);
  scw_view_set_column_visible (SCW_VIEW(view), 0, FALSE);
  scw_view_scroll_to_row(SCW_VIEW(view), "10");
}


void menu_pos          (GtkMenu *menu,
                        gint *x,
                        gint *y,
                        gboolean *push_in,
                        gpointer user_data)
{
  GdkPoint *p = (GdkPoint *) user_data;
  
  gdk_window_get_origin (view->window, x, y);
  
  *x += p->x;
  *y += p->y;
  
  g_print ("Menu at (%i,%i)\n", *x, *y);
}

void on_context_request (ScwView *view, gchar *id, gchar *action_data,
                         gint x, gint y,
                         gpointer user_data)
{
  GtkWidget *menu;
  GtkWidget *menuitem;
  GtkWidget *image;
  GdkPoint *p;
  
  p = g_new0 (GdkPoint, 1);

  
  menu = gtk_menu_new ();
  menuitem = gtk_image_menu_item_new_with_label ("");
  if (id != NULL && action_data != NULL)
    {
      if (g_utf8_collate ("userinfo", id) == 0)
        {
          gtk_label_set_markup (GTK_LABEL(GTK_BIN(menuitem)->child),
                               g_strdup_printf ("<b>Info</b> for %s", action_data));
        }
      else if (g_utf8_collate ("url", id) == 0)
        {
          gtk_label_set_markup (GTK_LABEL(GTK_BIN(menuitem)->child), "<b>Open</b>");
        }
      else
        {
          gtk_label_set_markup (GTK_LABEL(GTK_BIN(menuitem)->child),
                                "<b>Activate</b>");
        }
    }
  else
    {
      gtk_label_set_markup (GTK_LABEL(GTK_BIN(menuitem)->child),
                            "<b>Global</b> menu");
    }

  gtk_container_add (GTK_CONTAINER (menu), menuitem);
  
  p->x = x;
  p->y = y;

  gtk_widget_show_all (menu);
  
  gtk_menu_popup (GTK_MENU (menu), NULL, NULL, (GtkMenuPositionFunc) menu_pos,
                  p, 0, gtk_get_current_event_time());
  if (id != NULL && action_data != NULL)
    {
      g_print ("Context request id='%s', data='%s', at (%i,%i)\n",
               id, action_data, x, y);
    }
}

void on_button_clicked (GtkButton *button, gpointer user_data)
{
  GtkWidget *view;
  
  view = GTK_WIDGET(user_data);
  
  if (GTK_WIDGET_VISIBLE(view))
    {
      gtk_widget_hide(view);
      gtk_button_set_label(button, "Show the view");
    }
  else
    {
      gtk_widget_show(view);
      gtk_button_set_label(button, "Hide the view");
    }
  
}

void on_entry_activated (GtkEntry *entry, gpointer user_data)
{
  GtkTreeModel *model;
  GtkTreeIter iter;

  g_return_if_fail (entry != NULL);
  g_return_if_fail (user_data != NULL);
  g_return_if_fail (GTK_IS_ENTRY (entry));
  g_return_if_fail (GTK_IS_TREE_MODEL (user_data));
  
  model = GTK_TREE_MODEL (user_data);
  
  gtk_list_store_append (GTK_LIST_STORE (model), &iter);
  gtk_list_store_set (GTK_LIST_STORE (model), &iter,
                      0, time(NULL),
                      1, "[<action id='testID'><b>testuser</b></action>]",
                      3, gtk_entry_get_text (entry),
                      -1);
  gtk_entry_set_text (entry, "");
}

int main (int argc, char **argv)
{
  int i;
  GtkWidget *win;
  GtkWidget *sw;
  GtkWidget *vbox;
  GtkWidget *hbox;
  GtkWidget *entry;
  GtkTreeModel *model;
  GtkTreeIter iter;
  GtkTreeIter iter2;
  GdkPixbuf *scwicon;
 
/*
  g_log_set_always_fatal (G_LOG_LEVEL_WARNING | G_LOG_LEVEL_CRITICAL);
*/ 
  gtk_init (&argc, &argv);
  gtk_rc_parse_string ("style \"test\" "
                       "{ "
                       "ScwView::alternate-row-colors = 1 "
                       "ScwView::row-padding = 2 "
                       "ScwView::column-spacing = 10 "
                       "text[NORMAL] = \"#303030\" "
                       "text[ACTIVE] = \"#000000\" "
                       "text[SELECTED] = \"#000000\" "
                       "text[PRELIGHT] = \"#5050ff\" "
                       "base[NORMAL] = \"#FFFFFF\" "
                       "base[SELECTED] = \"#ded3d6\" "
                       "} class \"ScwView\" style \"test\" ");
/*
                       "font_name = \"Bitstream Vera Sans 16.75\" "
                       "ScwView::even-row-color = \"#334499\" "
                       "ScwView::odd-row-color = \"#6688FF\" "
                       "ScwView::odd-row-tint = 0.3 "
*/
  /* IconFactory init */
  
  scwicon = gdk_pixbuf_new_from_file_at_size("scw.png", 24, 24, NULL);
  gtk_icon_theme_add_builtin_icon ("scw-icon", 24, scwicon);
  
  win = GTK_WIDGET (g_object_new (GTK_TYPE_WINDOW, NULL));

  g_signal_connect (G_OBJECT (win), "delete-event",
                    G_CALLBACK (delete_win), NULL);

  gtk_widget_set_size_request (win, 400, 300);


  vbox = GTK_WIDGET (g_object_new (GTK_TYPE_VBOX,
                                   "homogeneous", FALSE,
                                   "spacing", 6,
                                   NULL));

  gtk_container_add (GTK_CONTAINER (win), vbox);


  sw = GTK_WIDGET (g_object_new (GTK_TYPE_SCROLLED_WINDOW,
                                 "hadjustment", NULL,
                                 "vadjustment", NULL,
                                 "hscrollbar-policy", GTK_POLICY_NEVER,
                                 "vscrollbar-policy", GTK_POLICY_AUTOMATIC,
                                  NULL));

  gtk_box_pack_start (GTK_BOX (vbox), sw, TRUE, TRUE, 0);


  model = GTK_TREE_MODEL (gtk_list_store_new (5,
                                              SCW_TYPE_TIMESTAMP,
                                              SCW_TYPE_PRESENCE,
                                              GDK_TYPE_PIXBUF,
                                              G_TYPE_STRING,
                                              SCW_TYPE_ROW_COLOR));

  view = GTK_WIDGET (g_object_new (SCW_TYPE_VIEW,
                        "model", model,
                        "align-presences", TRUE,
                        "presence-alignment", PANGO_ALIGN_LEFT,
                        "scroll-on-append", TRUE,
                        "timestamp-format", "<i>%H/%M</i>",
                        "action-attributes", "underline='double' weight='bold'",
                        "selection-row-separator", "foo",
                        "selection-column-separator", "bar",
                        "embedded-icon-size", 24,
                        "interaction", SCW_INTERACTION_SELECT,
                        NULL));

  g_signal_connect (G_OBJECT (view), "activate",
                    G_CALLBACK (on_activated), NULL);
  g_signal_connect (G_OBJECT (view), "context-request",
                    G_CALLBACK (on_context_request), NULL);

/*  scw_view_set_column_foldable (SCW_VIEW(view), 1);*/

  gtk_container_add (GTK_CONTAINER (sw), view); 
  
  gtk_list_store_append (GTK_LIST_STORE (model), &iter);
  gtk_list_store_set (GTK_LIST_STORE (model), &iter,
                      0, time(NULL),
                      1, "[<b><action id='zuhID'>zuh</action></b>]",
                      2, gdk_pixbuf_new_from_file_at_size("scw.png",
                                                          24, 24,
                                                          NULL),
                      3, "<icon id='gtk-info'/><big><i><b>Welcome to <icon id='scw-icon' />Scw</b></i></big>",
                      4, "#7d515d",
                      -1);

  gtk_list_store_append (GTK_LIST_STORE (model), &iter);
  gtk_list_store_set (GTK_LIST_STORE (model), &iter,
                      0, time(NULL),
                      1, "[<b><action id='zuhID'>zuh</action></b>]",
                      2, gdk_pixbuf_new_from_file_at_size("scw.png",
                                                          24, 24,
                                                          NULL),
                      3, "Here's the <icon id='gtk-home'/> of Scw: "
                         "<icon id='gtk-connect' /><span color='#ff0000'> Dag nabbit <action id='url'>http://iki.fi/zuh/scw/</action> </span>",
                      4, "#ff0000",
                      -1);



  scw_view_scroll_to_end (SCW_VIEW(view));


  hbox = GTK_WIDGET (g_object_new (GTK_TYPE_HBOX,
                                   "homogeneous", FALSE,
                                   "spacing", 6,
                                   NULL));
    
  entry = GTK_WIDGET (g_object_new (SCW_TYPE_ENTRY,
                                    "history-size", 10,
                                    NULL));

  g_signal_connect (G_OBJECT (entry), "activate",
                    G_CALLBACK (on_entry_activated), model);
  
  gtk_box_pack_start (GTK_BOX (hbox), entry, TRUE, TRUE, 0);

  entry = GTK_WIDGET (g_object_new (GTK_TYPE_BUTTON,
                                    "label", "Hide the view",
                                    NULL));

  g_signal_connect (G_OBJECT (entry), "clicked",
                    G_CALLBACK (on_button_clicked), view);

  gtk_box_pack_start (GTK_BOX (hbox), entry, FALSE, TRUE, 0);
  gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, TRUE, 0);

  gtk_widget_show_all (win);

  gtk_main ();
  
  return (0);
}
