;*=====================================================================*/
;*    serrano/prgm/project/scribe/scribeapi/param.scm                  */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sat Sep 29 05:23:42 2001                          */
;*    Last change :  Fri Jan 11 17:57:47 2002 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The scribe global parameters                                     */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module __scribeapi_param
   
   (import __scribeapi_configure
	   __scribeapi_api
	   __scribeapi_ast)
   
   (export *scribe-verbose*

	   *scribe-dest*
	   *scribe-path*
	   *scribe-style-path*
	   *scribe-library-path*
	   *scribe-bib-path*
	   *scribe-format*
	   *scribe-backend-alist*
	   *scribe-ref-base*

	   *scribe-standard-style*

	   *scribe-background*
	   *scribe-foreground*
	   *scribe-tbackground*
	   *scribe-tforeground*

	   *scribe-index-font-size*
	   
	   *scribe-prgm-color*
	   
	   *scribe-header*
	   *scribe-footer*
	   
	   *scribe-columns-width*
	   
	   *scribe-title-font*
	   *scribe-author-font*
	   *scribe-authors-style*
	   
	   *scribe-chapter-numbering*
	   *scribe-section-numbering*
	   *scribe-subsection-numbering*
	   *scribe-subsubsection-numbering*

	   *scribe-bib-author*
	   *scribe-bib-title*
	   *scribe-bib-year*
	   *scribe-bib-month*
	   *scribe-bib-address*
	   *scribe-bib-edition*

	   (scribe-format?::bool ::symbol))

   (eval   (export-all)))

;*---------------------------------------------------------------------*/
;*    Verbosity ...                                                    */
;*---------------------------------------------------------------------*/
(define *scribe-verbose* 0)

;*---------------------------------------------------------------------*/
;*    Output                                                           */
;*---------------------------------------------------------------------*/
(define *scribe-dest* #f)

;*---------------------------------------------------------------------*/
;*    Path                                                             */
;*---------------------------------------------------------------------*/
(define *scribe-style-path* (list "." (scribe-style-directory)))
(define *scribe-path* '("."))
(define *scribe-library-path* (list (scribe-library-directory)))
(define *scribe-bib-path* '("."))

;*---------------------------------------------------------------------*/
;*    Output format ...                                                */
;*---------------------------------------------------------------------*/
(define *scribe-format* #f)

;*---------------------------------------------------------------------*/
;*    *scribe-backend-alist* ...                                       */
;*    -------------------------------------------------------------    */
;*    This list specifies the name of the library in which we will     */
;*    find a back-end. If a name is not present in that list, the      */
;*    name of the library is the name itself.                          */
;*---------------------------------------------------------------------*/
(define *scribe-backend-alist*
   '((info "text")
     (sui "html" "htmlgui")
     (html "html" "htmlgui")))

;*---------------------------------------------------------------------*/
;*    *scribe-ref-base* ...                                            */
;*---------------------------------------------------------------------*/
(define *scribe-ref-base* #f)

;*---------------------------------------------------------------------*/
;*    *scribe-standard-style* ...                                      */
;*---------------------------------------------------------------------*/
(define *scribe-standard-style* "stdscribe.scr")

;*---------------------------------------------------------------------*/
;*    Coloring                                                         */
;*---------------------------------------------------------------------*/
(define *scribe-background* "#ffefd5")
(define *scribe-foreground* "#000000")
(define *scribe-tbackground* "#ffe4c4")
(define *scribe-tforeground* "#000000")
(define *scribe-prgm-color* #t)

;*---------------------------------------------------------------------*/
;*    Header & footer                                                  */
;*---------------------------------------------------------------------*/
(define *scribe-header* #f)
(define *scribe-footer* #f)

;*---------------------------------------------------------------------*/
;*    Dimensions                                                       */
;*---------------------------------------------------------------------*/
(define *scribe-columns-width* '())

;*---------------------------------------------------------------------*/
;*    Fonts                                                            */
;*---------------------------------------------------------------------*/
(define *scribe-title-font* #f)
(define *scribe-author-font* #f)
(define *scribe-authors-style* 'best)
(define *scribe-index-font-size* #f)

;*---------------------------------------------------------------------*/
;*    Numbering                                                        */
;*---------------------------------------------------------------------*/
(define *scribe-chapter-numbering* (lambda (x) x))
(define *scribe-section-numbering* (lambda (x) x))
(define *scribe-subsection-numbering* (lambda (x) x))
(define *scribe-subsubsection-numbering* (lambda (x) x))

;*---------------------------------------------------------------------*/
;*    bib ...                                                          */
;*---------------------------------------------------------------------*/
(define *scribe-bib-title* (lambda (t url)
			      (if (and url (scribe-format? 'html))
				  (ref :url url (bold t))
				  (bold t))))
(define *scribe-bib-author* (lambda (x) x))
(define *scribe-bib-year* (lambda (x) x))
(define *scribe-bib-month* (lambda (x) x))
(define *scribe-bib-address* (lambda (x) x))
(define *scribe-bib-edition* (lambda (x) (it x)))

;*---------------------------------------------------------------------*/
;*    scribe-format? ...                                               */
;*---------------------------------------------------------------------*/
(define (scribe-format? fmt)
   (eq? fmt *scribe-format*))
