;*=====================================================================*/
;*    serrano/prgm/project/scribe/scribeapi/pbigloo.scm                */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Sep 26 22:15:36 2001                          */
;*    Last change :  Wed Jan 16 11:43:01 2002 (serrano)                */
;*    Copyright   :  2001-02 Manuel Serrano                            */
;*    -------------------------------------------------------------    */
;*    The Bigloo fontifier.                                            */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module __scribeapi_pbigloo
   
   (import  __scribeapi_param
	    __scribeapi_ast)
   
   (eval    (export bigloo))
   
   (export  (bigloo ::bstring)))

;*---------------------------------------------------------------------*/
;*    Bigloo stamps                                                    */
;*---------------------------------------------------------------------*/
(define *keyword* (gensym))
(define *define* (gensym))
(define *module* (gensym))

;*---------------------------------------------------------------------*/
;*    Bigloo keywords                                                  */
;*---------------------------------------------------------------------*/
(for-each (lambda (symbol)
	     (putprop! symbol *keyword* #t))
	  '(set! if let cond case begin letrec let*
		 lambda export extern class generic inline
		 static import foreign type with-access instantiate
		 duplicate labels try unwind-protect
		 bind-exit match-case match-lambda pragma widen! shrink!
		 wide-class profile profile/gc 
		 regular-grammar lalr-grammar apply))

(for-each (lambda (symbol)
	     (putprop! symbol *define* #t))
	  '(define define-inline define-struct define-macro define-generic
	      define-method define-syntax define-expander))  

(for-each (lambda (symbol)
	     (putprop! symbol *module* #t))
	  '(module import export library))

;*---------------------------------------------------------------------*/
;*    *color* ...                                                      */
;*---------------------------------------------------------------------*/
(define *color* '())
(define *paren-color-armed* #f)

;*---------------------------------------------------------------------*/
;*    bigloo ...                                                       */
;*---------------------------------------------------------------------*/
(define (bigloo obj)
   (parse-bigloo (open-input-string obj)))

;*---------------------------------------------------------------------*/
;*    parse-bigloo port ...                                            */
;*---------------------------------------------------------------------*/
(define (parse-bigloo port::input-port)
   (let ((g (regular-grammar ()
	       ((bol (: "%%" (* all)))
		;; a text inclusion
		(with-input-from-string (the-substring 2 (the-length))
		   (lambda ()
		      (let* ((file (read))
			     (def (read))
			     (start (read))
			     (stop (read)))
			 (append (bigloo-from-file file def start stop)
				 (ignore))))))
	       ((: #\; (in "*;") (* all))
		;; italic comments
		(let ((str (the-string)))
		   (cons (if *scribe-prgm-color*
			     `(color :fg "#ffa600" (it ,str))
			     `(it ,str))
			 (ignore))))
	       ((: #\\ #\; (in "*;") (* all))
		;; italic comments
		(let ((str (the-substring 1 (the-length))))
		   (cons (if *scribe-prgm-color*
			     `(color :fg "#ffa600" (it ,str))
			     `(it ,str))
			 (ignore))))
	       ((: ";" (out #\; #\*) (* all))
		;; plain comments
		(let ((str (the-string)))
		   (cons str (ignore))))
	       ((: #\\ (* (in #\space #\tab)) ";" (out #\; #\*) (* all))
		;; plain comments
		(let ((str (the-substring 1 (the-length))))
		   (cons str (ignore))))
	       ((+ #\Space)
		;; separators
		(let ((str (the-string)))
		   (cons str (ignore))))
	       ((+ #\()
		;; open parenthesis
		(let ((str (the-string)))
		   (if (pair? *color*)
		       (let ((par (if *scribe-prgm-color*
				      `(color :fg ,(car *color*) (bold ,str))
				      str)))
			  (set! *paren-color-armed* #t)
			  (cons par (ignore)))
		       (cons str (ignore)))))
	       (#\)
		;; close parenthesis
		(let ((str (the-string)))
		   (set! *paren-color-armed* #f)
		   (if (pair? *color*)
		       (let ((color (car *color*)))
			  (set! *color* (cdr *color*))
			  (cons (if *scribe-prgm-color*
				    `(color :fg ,color (bold ,str))
				    str)
				(ignore)))
		       (cons str (ignore)))))
	       (#\Tab
		(cons (make-string 8 #\space) (ignore)))
	       ((+ (out #\; #\Space #\Tab #\( #\) #\: #\" #\Newline))
		;; keywords
		(let* ((string (the-string))
		       (symbol (the-symbol)))
		   (cond
		      ((getprop symbol *keyword*)
		       (cons `(bold ,string)
			     (ignore)))
		      ((getprop symbol *define*)
		       (set! *color* (cons "#6959cf" *color*))
		       (set! *paren-color-armed* #f)
		       (let ((kwd (if *scribe-prgm-color*
				      `(color :fg "#6959cf" (bold ,string))
				      string)))
			  (cons kwd (ignore))))
		      ((getprop symbol *module*)
		       (cons (if *scribe-prgm-color*
				 `(color :fg "#1919af" (bold ,string))
				 `(bold ,string))
			     (ignore)))
		      ((pair? *color*)
		       (let ((id (if *scribe-prgm-color*
				      `(color :fg
					      ,(car *color*)
					      (bold ,string))
				      string)))
			  (if (not *paren-color-armed*)
			      (set! *color* (cdr *color*)))
			  (cons id (ignore))))
		      (else
		       (cons string (ignore))))))
	       ;; newline
	       ((+ #\Newline)
		(let ((str (the-string)))
		   (cons str (ignore))))
	       ((or (: "\"" (* (or (out #a000 #\\ #\") (: #\\ all))) "\"")
		    (: "#\"" (* (or (out #a000 #\\ #\") (: #\\ all))) "\""))
		;; strings
		(let ((str (the-string)))
		   (cons (if *scribe-prgm-color*
			     `(color :fg "red" ,str)
			     str)
			 (ignore))))
	       ((: "::" (+ (out #\; #\Newline #\Space #\Tab #\( #\) #\:)))
		;; type annotations
		(let ((string (the-string)))
		   (cons (if *scribe-prgm-color*
			     `(color :fg "#00cf00" (bold ,string))
			     `(it ,string))
			 (ignore))))
	       ((: ":" (out #\:)
		       (* (out #\; #\Newline #\Space #\Tab #\( #\) #\:)))
		;; keywords annotations
		(let ((string (the-string)))
		   (cons `(it ,string) (ignore))))
	       ((+ (or #\: #\; #\"))
		(let ((str (the-string)))
		   (cons str (ignore))))
	       ((: #\# #\\ (+ (out " \n\t")))
		;; characters
		(let ((str (the-string)))
		   (cons str (ignore))))
	       (else
		(let ((c (the-failure)))
		   (if (eof-object? c)
		       '()
		       (error "prgm(bigloo)" "Unexpected character" c)))))))
      (read/rp g port)))

;*---------------------------------------------------------------------*/
;*    bigloo-from-file ...                                             */
;*---------------------------------------------------------------------*/
(define (bigloo-from-file file def start stop)
   (cond
      ((and (not def) (not start) (not stop))
       ;; the whole file
       (if (file-exists? file)
	   (let ((p (open-input-file file)))
	      (if (input-port? p)
		  (parse-bigloo p)
		  (error "prgm(bigloo)" "Can't open file" file)))
	   (error "prgm(bigloo)" "Can't find file" file)))
      (def
       (multiple-value-bind (start stop)
	  (bigloo-definition-search file (cond
					    ((symbol? def)
					     def)
					    ((string? def)
					     (string->symbol def))
					    (else
					     (error "prgm(bigloo)"
						    "Illegal definition"
						    def))))
	  (bigloo-from-file-lines file start stop)))
      ((or start stop)
       (bigloo-from-file-lines file start stop))
      (else
       '())))

;*---------------------------------------------------------------------*/
;*    bigloo-from-file-lines ...                                       */
;*---------------------------------------------------------------------*/
(define (bigloo-from-file-lines file start stop)
   (define (bigloo-lines lines)
      (bigloo (with-output-to-string (lambda () (map display lines)))))
   (let* ((start (if (fixnum? start)
		     start
		     1))
	  (stop (if (fixnum? stop)
		    stop
		    -1))
	  (port (open-input-file/line file start)))
      (unwind-protect
	 (let loop ((line (read-line port))
		    (lines '())
		    (lnum start))
	    (cond
	       ((and (> stop 0) (> lnum stop))
		(bigloo-lines (cdr (reverse! lines))))
	       ((eof-object? line)
		(if (=fx stop -1)
		    (bigloo-lines (cdr (reverse! lines)))
		    (error "prgm(bigloo)" "File too short" file)))
	       (else
		(loop (read-line port)
		      (cons* (untabify line) #"\n" lines)
		      (+fx lnum 1)))))
	 (close-input-port port))))

;*---------------------------------------------------------------------*/
;*    untabify ...                                                     */
;*---------------------------------------------------------------------*/
(define (untabify obj)
   ;; count the number of #\tab
   (let ((len (string-length obj))
	 (tabl 8))
      (let loop ((i 0)
		 (nl 0))
	 (cond
	    ((=fx i len)
	     (if (=fx nl len)
		 obj
		 ;; allocates a new string and fill it
		 (let ((new (make-string nl)))
		    (let loop ((r 0)
			       (w 0))
		       (cond
			  ((=fx r len)
			   new)
			  ((char=? (string-ref obj r) #\tab)
			   (let ((q (/fx r tabl)))
			      (let liip ((num (-fx (*fx tabl (+fx 1 q)) r))
					 (w w))
				 (if (=fx num 0)
				     (loop (+fx r 1) w)
				     (begin
					(string-set! new w #\space)
					(liip (-fx num 1) (+fx w 1)))))))
			  (else
			   (string-set! new w (string-ref obj r))
			   (loop (+fx r 1) (+fx w 1))))))))
	    ((char=? (string-ref obj i) #\tab)
	     (let* ((q (/fx i tabl))
		    (n (-fx (*fx tabl (+fx 1 q)) i)))
		(loop (+fx i 1) (+fx nl n))))
	    (else
	     (loop (+fx i 1) (+fx nl 1)))))))

;*---------------------------------------------------------------------*/
;*    open-input-file/line ...                                         */
;*---------------------------------------------------------------------*/
(define (open-input-file/line::input-port file line-num)
   (let ((iport (open-input-file file)))
      (if (not (input-port? iport))
	  (error "prgm(bigloo)" "Can't open file for input" file)
	  (if (=fx line-num 1)
	      iport
	      (let loop ((line (read-line iport))
			 (lnum 2))
		 (cond
		    ((eof-object? line)
		     (error "prgm(bigloo)"
			    "File too short"
			    (list file line-num lnum)))
		    ((>fx lnum line-num)
		     (error "prgm(bigloo)"
			    "Illegal file num"
			    (list file line-num lnum)))
		    ((=fx lnum line-num)
		     iport)
		    (else
		     (loop (read-line iport) (+fx lnum 1)))))))))

;*---------------------------------------------------------------------*/
;*    bigloo-definition-search ...                                     */
;*    -------------------------------------------------------------    */
;*    This function seek a Bigloo definition. If it finds it it        */
;*    returns two value the starting line number of the definition     */
;*    and the stop line.                                               */
;*---------------------------------------------------------------------*/
(define (bigloo-definition-search file-name def)
   (reader-reset!)
   (let ((iport (open-input-file file-name)))
      (if (not (input-port? iport))
	  (error "prgm(bigloo)" "Can't open file for input" file-name)
	  (unwind-protect
	     (let loop ((exp (read iport #t)))
		(if (not (eof-object? exp))
		    (match-case exp
		       ((begin . ?rest)
			(loop (read iport #t)))
		       (((or define define-inline define-generic
			     define-method define-macro define-expander)
			 (?fun . ?-) . ?-)
			(if (eq? def fun)
			    (values (line-number exp)
				    (reader-current-line-number))
			    (loop (read iport #f))))
		       (((or define define-struct) (and (? symbol?) ?var) . ?-)
			(if (eq? var def)
			    (values (line-number exp)
				    (reader-current-line-number))
			    (loop (read iport #t))))
		       (else
			(loop (read iport #t))))
		    (values #f #f)))
	     (close-input-port iport)))))

;*---------------------------------------------------------------------*/
;*    reader-current-line-number ...                                   */
;*    -------------------------------------------------------------    */
;*    This is a gross hack but to get the current reader line number   */
;*    we build a dummy expression that we read.                        */
;*---------------------------------------------------------------------*/
(define (reader-current-line-number)
   (let* ((port (open-input-string "(9)"))
	  (exp  (read port #t)))
      (close-input-port port)
      (line-number exp)))

;*---------------------------------------------------------------------*/
;*    line-number ...                                                  */
;*---------------------------------------------------------------------*/
(define (line-number expr)
   (and (epair? expr)
	(match-case (cer expr)
	   ((at ?- ?pos ?line)
	    line))))

