/*  Screem:  site_guile.c,
 *  Guile glue functions for accessing a screem site
 * 
 *  Copyright (C) 2000  David A Knight
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *  For contact information with the author of this source code please see
 *  the AUTHORS file.  If there is no AUTHORS file present then check the
 *  about box under the help menu for a contact address
 */
#include <config.h>

#ifdef HAVE_GUILE
#include <guile/gh.h>
#endif

#include "page.h"
#include "site.h"
#include "site_guile.h"

extern Site *current_site;

/* "scheme name", C function name, required args, optional args,
   takes rest list */
#ifdef HAVE_GUILE
static gpointer site_procedures[] = {
	"screem-site-get-current", (gpointer)scm_screem_site_get_current, 
	GINT_TO_POINTER( 0 ), GINT_TO_POINTER( 0 ), GINT_TO_POINTER( 0 ),
	"screem-site-new", (gpointer)scm_screem_site_new, 
	GINT_TO_POINTER( 0 ), GINT_TO_POINTER( 0 ), GINT_TO_POINTER( 0 ),
	"screem-site-destroy", (gpointer)scm_screem_site_destroy, 
	GINT_TO_POINTER( 1 ), GINT_TO_POINTER( 0 ), GINT_TO_POINTER( 0 ),
	"screem-site-purge", (gpointer)scm_screem_site_purge, 
	GINT_TO_POINTER( 1 ), GINT_TO_POINTER( 0 ), GINT_TO_POINTER( 0 ),
	"screem-site-set-name", (gpointer)scm_screem_site_set_name, 
	GINT_TO_POINTER( 2 ), GINT_TO_POINTER( 0 ), GINT_TO_POINTER( 0 ),
	"screem-site-get-name", (gpointer)scm_screem_site_get_name, 
	GINT_TO_POINTER( 1 ), GINT_TO_POINTER( 0 ), GINT_TO_POINTER( 0 ),
	"screem-site-set-pathname", (gpointer)scm_screem_site_set_pathname, 
	GINT_TO_POINTER( 2 ), GINT_TO_POINTER( 0 ), GINT_TO_POINTER( 0 ),
	"screem-site-get-pathname", (gpointer)scm_screem_site_get_pathname, 
	GINT_TO_POINTER( 1 ), GINT_TO_POINTER( 0 ), GINT_TO_POINTER( 0 ),
	"screem-site-set-remote-url", 
	(gpointer)scm_screem_site_set_remote_url, 
	GINT_TO_POINTER( 2 ), GINT_TO_POINTER( 0 ), GINT_TO_POINTER( 0 ),
	"screem-site-get-remote-url", (gpointer)scm_screem_site_get_remote_url,
	GINT_TO_POINTER( 1 ), GINT_TO_POINTER( 0 ), GINT_TO_POINTER( 0 ),
	"screem-site-set-remote-method",
	(gpointer)scm_screem_site_set_remote_method,
	GINT_TO_POINTER( 2 ), GINT_TO_POINTER( 0 ), GINT_TO_POINTER( 0 ),
	"screem-site-get-remote-method", 
	(gpointer)scm_screem_site_get_remote_method, 
	GINT_TO_POINTER( 1 ), GINT_TO_POINTER( 0 ), GINT_TO_POINTER( 0 ),
	"screem-site-set-remote-path", 
	(gpointer)scm_screem_site_set_remote_path,
	GINT_TO_POINTER( 2 ), GINT_TO_POINTER( 0 ), GINT_TO_POINTER( 0 ),
	"screem-site-get-remote-path", 
	(gpointer)scm_screem_site_get_remote_path, 
	GINT_TO_POINTER( 1 ), GINT_TO_POINTER( 0 ), GINT_TO_POINTER( 0 ),
	"screem-site-set-remote-user", 
	(gpointer)scm_screem_site_set_remote_user, 
	GINT_TO_POINTER( 2 ), GINT_TO_POINTER( 0 ), GINT_TO_POINTER( 0 ),
	"screem-site-get-remote-user", 
	(gpointer)scm_screem_site_get_remote_user, 
	GINT_TO_POINTER( 1 ), GINT_TO_POINTER( 0 ), GINT_TO_POINTER( 0 ),
	"screem-site-set-remote-pass", 
	(gpointer)scm_screem_site_set_remote_pass, 
	GINT_TO_POINTER( 2 ), GINT_TO_POINTER( 0 ), GINT_TO_POINTER( 0 ),
	"screem-site-get-remote-pass", 
	(gpointer)scm_screem_site_get_remote_pass, 
	GINT_TO_POINTER( 1 ), GINT_TO_POINTER( 0 ), GINT_TO_POINTER( 0 ),
	"screem-site-set-cvs-root", (gpointer)scm_screem_site_set_cvs_root, 
	GINT_TO_POINTER( 2 ), GINT_TO_POINTER( 0 ), GINT_TO_POINTER( 0 ),
	"screem-site-get-cvs-root", (gpointer)scm_screem_site_get_cvs_root, 
	GINT_TO_POINTER( 1 ), GINT_TO_POINTER( 0 ), GINT_TO_POINTER( 0 ),
	"screem-site-set-template-path", 
	(gpointer)scm_screem_site_set_template_path, 
	GINT_TO_POINTER( 2 ), GINT_TO_POINTER( 0 ), GINT_TO_POINTER( 0 ),
	"screem-site-get-template-path",
	(gpointer)scm_screem_site_get_template_path, 
	GINT_TO_POINTER( 1 ), GINT_TO_POINTER( 0 ), GINT_TO_POINTER( 0 ),
	"screem-site-set-http-url", (gpointer)scm_screem_site_set_http_url, 
	GINT_TO_POINTER( 2 ), GINT_TO_POINTER( 0 ), GINT_TO_POINTER( 0 ),
	"screem-site-get-http-url", (gpointer)scm_screem_site_get_http_url, 
	GINT_TO_POINTER( 1 ), GINT_TO_POINTER( 0 ), GINT_TO_POINTER( 0 ),
	"screem-site-set-fake-flag", (gpointer)scm_screem_site_set_fake_flag, 
	GINT_TO_POINTER( 2 ), GINT_TO_POINTER( 0 ), GINT_TO_POINTER( 0 ),
	"screem-site-get-fake-flag", (gpointer)scm_screem_site_get_fake_flag, 
	GINT_TO_POINTER( 1 ), GINT_TO_POINTER( 0 ), GINT_TO_POINTER( 0 ),
	"screem-site-set-current-page", 
	(gpointer)scm_screem_site_set_current_page, 
	GINT_TO_POINTER( 2 ), GINT_TO_POINTER( 0 ), GINT_TO_POINTER( 0 ),
	"screem-site-get-current-page", 
	(gpointer)scm_screem_site_get_current_page,
	GINT_TO_POINTER( 1 ), GINT_TO_POINTER( 0 ), GINT_TO_POINTER( 0 ),
	"screem-site-set-is-import", (gpointer)scm_screem_site_set_is_import, 
	GINT_TO_POINTER( 2 ), GINT_TO_POINTER( 0 ), GINT_TO_POINTER( 0 ),
	"screem-site-get-is-import", (gpointer)scm_screem_site_get_is_import, 
	GINT_TO_POINTER( 1 ), GINT_TO_POINTER( 0 ), GINT_TO_POINTER( 0 ),
	"screem-site-set-open-pages", 
	(gpointer)scm_screem_site_set_open_pages, 
	GINT_TO_POINTER( 2 ), GINT_TO_POINTER( 0 ), GINT_TO_POINTER( 0 ),
	"screem-site-get-page-from-tab", 
	(gpointer)scm_screem_site_get_page_from_tab,
	GINT_TO_POINTER( 2 ), GINT_TO_POINTER( 0 ), GINT_TO_POINTER( 0 ),
	"screem-site-get-open-pages", (gpointer)scm_screem_site_get_open_pages,
	GINT_TO_POINTER( 1 ), GINT_TO_POINTER( 0 ), GINT_TO_POINTER( 0 ),
	"screem-site-set-passive-ftp", 
	(gpointer)scm_screem_site_set_passive_ftp, 
	GINT_TO_POINTER( 2 ), GINT_TO_POINTER( 0 ), GINT_TO_POINTER( 0 ),
	"screem-site-get-passive-ftp", 
	(gpointer)scm_screem_site_get_passive_ftp, 
	GINT_TO_POINTER( 1 ), GINT_TO_POINTER( 0 ), GINT_TO_POINTER( 0 ),
	"screem-site-set-no-delete", (gpointer)scm_screem_site_set_no_delete, 
	GINT_TO_POINTER( 2 ), GINT_TO_POINTER( 0 ), GINT_TO_POINTER( 0 ),
	"screem-site-get-no-delete", (gpointer)scm_screem_site_get_no_delete, 
	GINT_TO_POINTER( 1 ), GINT_TO_POINTER( 0 ), GINT_TO_POINTER( 0 ),
	"screem-site-set-check_moved", 
	(gpointer)scm_screem_site_set_check_moved, 
	GINT_TO_POINTER( 2 ), GINT_TO_POINTER( 0 ), GINT_TO_POINTER( 0 ),
	"screem-site-get-check_moved", 
	(gpointer)scm_screem_site_get_check_moved, 
	GINT_TO_POINTER( 1 ), GINT_TO_POINTER( 0 ), GINT_TO_POINTER( 0 ),
	"screem-site-set-no-overwrite", 
	(gpointer)scm_screem_site_set_no_overwrite, 
	GINT_TO_POINTER( 2 ), GINT_TO_POINTER( 0 ), GINT_TO_POINTER( 0 ),
	"screem-site-get-no-overwrite", 
	(gpointer)scm_screem_site_get_no_overwrite, 
	GINT_TO_POINTER( 1 ), GINT_TO_POINTER( 0 ), GINT_TO_POINTER( 0 ),
	"screem-site-set-permissions", 
	(gpointer)scm_screem_site_set_permissions, 
	GINT_TO_POINTER( 2 ), GINT_TO_POINTER( 0 ), GINT_TO_POINTER( 0 ),
	"screem-site-get-permissions", 
	(gpointer)scm_screem_site_get_permissions,
	GINT_TO_POINTER( 1 ), GINT_TO_POINTER( 0 ), GINT_TO_POINTER( 0 ),
	"screem-site-set-symlinks", (gpointer)scm_screem_site_set_symlinks, 
	GINT_TO_POINTER( 2 ), GINT_TO_POINTER( 0 ), GINT_TO_POINTER( 0 ),
	"screem-site-get-symlinks", (gpointer)scm_screem_site_get_symlinks, 
	GINT_TO_POINTER( 1 ), GINT_TO_POINTER( 0 ), GINT_TO_POINTER( 0 ),
	"screem-site-is-excluded", (gpointer)scm_screem_site_is_excluded, 
	GINT_TO_POINTER( 2 ), GINT_TO_POINTER( 0 ), GINT_TO_POINTER( 0 ),
	"screem-site-add-exclude", (gpointer)scm_screem_site_add_exclude, 
	GINT_TO_POINTER( 2 ), GINT_TO_POINTER( 0 ), GINT_TO_POINTER( 0 ),
	"screem-site-remove-exclude",
	(gpointer)scm_screem_site_remove_exclude, 
	GINT_TO_POINTER( 2 ), GINT_TO_POINTER( 0 ), GINT_TO_POINTER( 0 ),
	"screem-site-is-ascii", (gpointer)scm_screem_site_is_ascii, 
	GINT_TO_POINTER( 2 ), GINT_TO_POINTER( 0 ), GINT_TO_POINTER( 0 ),
	"screem-site-add-ascii", (gpointer)scm_screem_site_add_ascii, 
	GINT_TO_POINTER( 2 ), GINT_TO_POINTER( 0 ), GINT_TO_POINTER( 0 ),
	"screem-site-remove-ascii", (gpointer)scm_screem_site_remove_ascii, 
	GINT_TO_POINTER( 2 ), GINT_TO_POINTER( 0 ), GINT_TO_POINTER( 0 ),
	"screem-site-is-ignored", (gpointer)scm_screem_site_is_ignored, 
	GINT_TO_POINTER( 2 ), GINT_TO_POINTER( 0 ), GINT_TO_POINTER( 0 ),
	"screem-site-add-ignore", (gpointer)scm_screem_site_add_ignore, 
	GINT_TO_POINTER( 2 ), GINT_TO_POINTER( 0 ), GINT_TO_POINTER( 0 ),
	"screem-site-remove-ignore", (gpointer)scm_screem_site_remove_ignore, 
	GINT_TO_POINTER( 2 ), GINT_TO_POINTER( 0 ), GINT_TO_POINTER( 0 ),
	"screem-site-save", (gpointer)scm_screem_site_save, 
	GINT_TO_POINTER( 1 ), GINT_TO_POINTER( 0 ), GINT_TO_POINTER( 0 ),
	"screem-site-create", (gpointer)scm_screem_site_create, 
	GINT_TO_POINTER( 1 ), GINT_TO_POINTER( 0 ), GINT_TO_POINTER( 0 ),
	"screem-site-load", (gpointer)scm_screem_site_load, 
	GINT_TO_POINTER( 1 ), GINT_TO_POINTER( 0 ), GINT_TO_POINTER( 0 ),
	"screem-site-write-project-file", 
	(gpointer)scm_screem_site_write_project_file,
	GINT_TO_POINTER( 1 ), GINT_TO_POINTER( 0 ), GINT_TO_POINTER( 0 ),
	"screem-site-parse-project-file", 
	(gpointer)scm_screem_site_parse_project_file,
	GINT_TO_POINTER( 2 ), GINT_TO_POINTER( 0 ), GINT_TO_POINTER( 0 ),
	"screem-site-locate-page", (gpointer)scm_screem_site_locate_page, 
	GINT_TO_POINTER( 2 ), GINT_TO_POINTER( 0 ), GINT_TO_POINTER( 0 ),
	"screem-site-add-page", (gpointer)scm_screem_site_add_page,
	GINT_TO_POINTER( 2 ), GINT_TO_POINTER( 0 ), GINT_TO_POINTER( 0 ),
	"screem-site-remove-page", (gpointer)scm_screem_site_remove_page, 
	GINT_TO_POINTER( 2 ), GINT_TO_POINTER( 0 ), GINT_TO_POINTER( 0 ),
	"screem-site-get-pages", (gpointer)scm_screem_site_get_pages, 
	GINT_TO_POINTER( 1 ), GINT_TO_POINTER( 0 ), GINT_TO_POINTER( 0 ),
	"screem-site-locate-task", (gpointer)scm_screem_site_locate_task,
	GINT_TO_POINTER( 2 ), GINT_TO_POINTER( 0 ), GINT_TO_POINTER( 0 ),
	"screem-site-add-task", (gpointer)scm_screem_site_add_task,
	GINT_TO_POINTER( 2 ), GINT_TO_POINTER( 0 ), GINT_TO_POINTER( 0 ),
	"screem-site-remove-task", (gpointer)scm_screem_site_remove_task, 
	GINT_TO_POINTER( 2 ), GINT_TO_POINTER( 0 ), GINT_TO_POINTER( 0 ),
	"screem-site-get-tasks", (gpointer)scm_screem_site_get_tasks, 
	GINT_TO_POINTER( 1 ), GINT_TO_POINTER( 0 ), GINT_TO_POINTER( 0 ),
	"screem-site-file-change", (gpointer)scm_screem_site_file_change,
	GINT_TO_POINTER( 3 ), GINT_TO_POINTER( 0 ), GINT_TO_POINTER( 0 ),
	NULL
};
#endif

void screem_site_init_guile()
{
	gint i;
#ifdef HAVE_GUILE
      	for( i = 0; site_procedures[ i ]; i += 5 ) {
		gh_new_procedure( site_procedures[ i ],
				  site_procedures[ i + 1 ],
				  (gint)site_procedures[ i + 2 ],
				  (gint)site_procedures[ i + 3 ],
				  (gint)site_procedures[ i + 4 ] );
	}
#endif
}

#ifdef HAVE_GUILE
SCM scm_screem_site_get_current()
{
	return PTR2SCM( current_site );
}

SCM scm_screem_site_new()
{
	Site *site;

	site = screem_site_new();

	return PTR2SCM( site );
}

SCM scm_screem_site_destroy( SCM s )
{
	Site *site = (Site*)SCM2PTR( s );

	screem_site_destroy( site );

	return SCM_EOL;
}

SCM scm_screem_site_purge( SCM s )
{
	Site *site = (Site*)SCM2PTR( s );

	screem_site_purge( site );

	return SCM_EOL;
}

SCM scm_screem_site_set_name( SCM s, SCM n )
{
	Site *site = (Site*)SCM2PTR( s );
	gchar *name;
	gint len;

	name = gh_scm2newstr( n, &len );

	screem_site_set_name( site, name );

	return SCM_EOL;
}

SCM scm_screem_site_get_name( SCM s )
{
	Site *site = (Site*)SCM2PTR( s );
	const gchar *name;

	name = screem_site_get_name( site );

	return gh_str2scm( name, strlen( name ) );
}

SCM scm_screem_site_set_pathname( SCM s, SCM p )
{
	Site *site = (Site*)SCM2PTR( s );
	gchar *name;
	gint len;

	name = gh_scm2newstr( p, &len );

	screem_site_set_pathname( site, name );

	return SCM_EOL;
}

SCM scm_screem_site_get_pathname( SCM s )
{
	Site *site = (Site*)SCM2PTR( s );
	const gchar *name;

	name = screem_site_get_pathname( site );

	return gh_str2scm( name, strlen( name ) );
}

SCM scm_screem_site_set_remote_url( SCM s, SCM p )
{
	Site *site = (Site*)SCM2PTR( s );
	gchar *name;
	gint len;

	name = gh_scm2newstr( p, &len );

	screem_site_set_remote_url( site, name );

	return SCM_EOL;
}

SCM scm_screem_site_get_remote_url( SCM s )
{
	Site *site = (Site*)SCM2PTR( s );
	const gchar *name;

	name = screem_site_get_remote_url( site );

	return gh_str2scm( name, strlen( name ) );
}

SCM scm_screem_site_set_remote_method( SCM s, SCM m )
{
	Site *site = (Site*)SCM2PTR( s );
	UploadMethods method;

	method = gh_scm2int( m );

	screem_site_set_remote_method( site, method );

	return SCM_EOL;
}

SCM scm_screem_site_get_remote_method( SCM s )
{
	Site *site = (Site*)SCM2PTR( s );
	UploadMethods method;

	method = screem_site_get_remote_method( site );

	return gh_int2scm( method );
}

SCM scm_screem_site_set_remote_path( SCM s, SCM p )
{
	Site *site = (Site*)SCM2PTR( s );
	gchar *name;
	gint len;

	name = gh_scm2newstr( p, &len );

	screem_site_set_remote_path( site, name );

	return SCM_EOL;
}

SCM scm_screem_site_get_remote_path( SCM s )
{
	Site *site = (Site*)SCM2PTR( s );
	const gchar *name;

	name = screem_site_get_remote_path( site );

	return gh_str2scm( name, strlen( name ) );
}

SCM scm_screem_site_set_remote_user( SCM s, SCM p )
{
	Site *site = (Site*)SCM2PTR( s );
	gchar *name;
	gint len;

	name = gh_scm2newstr( p, &len );

	screem_site_set_remote_user( site, name );

	return SCM_EOL;
}

SCM scm_screem_site_get_remote_user( SCM s )
{
	Site *site = (Site*)SCM2PTR( s );
	const gchar *name;

	name = screem_site_get_remote_user( site );

	return gh_str2scm( name, strlen( name ) );
}


SCM scm_screem_site_set_remote_pass( SCM s, SCM p )
{
	Site *site = (Site*)SCM2PTR( s );
	gchar *name;
	gint len;

	name = gh_scm2newstr( p, &len );

	screem_site_set_remote_pass( site, name );

	return SCM_EOL;
}

SCM scm_screem_site_get_remote_pass( SCM s )
{
	Site *site = (Site*)SCM2PTR( s );
	const gchar *name;

	name = screem_site_get_remote_pass( site );

	return gh_str2scm( name, strlen( name ) );
}


SCM scm_screem_site_set_cvs_root( SCM s, SCM n )
{
	Site *site = (Site*)SCM2PTR( s );
	gchar *cvs_root;
	gint len;

	cvs_root = gh_scm2newstr( n, &len );

	screem_site_set_cvs_root( site, cvs_root );

	return SCM_EOL;
}

SCM scm_screem_site_get_cvs_root( SCM s )
{
	Site *site = (Site*)SCM2PTR( s );
	const gchar *cvs_root;

	cvs_root = screem_site_get_cvs_root( site );

	return gh_str2scm( cvs_root, strlen( cvs_root ) );
}

SCM scm_screem_site_set_template_path( SCM s, SCM n )
{
	Site *site = (Site*)SCM2PTR( s );
	gchar *template_path;
	gint len;

	template_path = gh_scm2newstr( n, &len );

	screem_site_set_template_path( site, template_path );

	return SCM_EOL;
}

SCM scm_screem_site_get_template_path( SCM s )
{
	Site *site = (Site*)SCM2PTR( s );
	const gchar *template_path;

	template_path = screem_site_get_template_path( site );

	return gh_str2scm( template_path, strlen( template_path ) );
}

SCM scm_screem_site_set_http_url( SCM s, SCM n )
{
	Site *site = (Site*)SCM2PTR( s );
	gchar *http_url;
	gint len;

	http_url = gh_scm2newstr( n, &len );

	screem_site_set_http_url( site, http_url );

	return SCM_EOL;
}

SCM scm_screem_site_get_http_url( SCM s )
{
	Site *site = (Site*)SCM2PTR( s );
	const gchar *http_url;

	http_url = screem_site_get_http_url( site );

	return gh_str2scm( http_url, strlen( http_url ) );
}

SCM scm_screem_site_set_fake_flag( SCM s, SCM f )
{
	Site *site = (Site*)SCM2PTR( s );
	gboolean flag;

	flag = gh_scm2bool( f );

	screem_site_set_fake_flag( site, flag );

	return SCM_EOL;
}

SCM scm_screem_site_get_fake_flag( SCM s )
{
	Site *site = (Site*)SCM2PTR( s );
	gboolean flag;

	flag = screem_site_get_fake_flag( site );

	return gh_bool2scm( flag );
}


SCM scm_screem_site_set_current_page( SCM s, SCM p )
{
	Site *site = (Site*)SCM2PTR( s );
	Page *page = (gpointer)gh_scm2int( p );

    	screem_site_set_current_page( site, page );

	return SCM_EOL;
}

SCM scm_screem_site_get_current_page( SCM s )
{
	Site *site = (Site*)SCM2PTR( s );
	Page *page;

	page = screem_site_get_current_page( site );

	return PTR2SCM( page );
}

SCM scm_screem_site_set_is_import( SCM s, SCM v )
{
	Site *site = (Site*)SCM2PTR( s );
	gboolean val;

	val = gh_scm2bool( v );

	screem_site_set_is_import( site, val );
	
	return SCM_EOL;
}

SCM scm_screem_site_get_is_import( SCM s )
{
	Site *site = (Site*)SCM2PTR( s );
	gboolean val;

      	val = screem_site_get_is_import( site );

	return gh_bool2scm( val );
}

SCM scm_screem_site_set_open_pages( SCM s, SCM n )
{
	Site *site = (Site*)SCM2PTR( s );
	gint num;

	num = gh_scm2int( n );

	screem_site_set_open_pages( site, num );
	
	return SCM_EOL;
}


SCM scm_screem_site_get_open_pages( SCM s )
{
	Site *site = (Site*)SCM2PTR( s );
	gint num;

   	num = screem_site_get_open_pages( site );
	
	return gh_int2scm( num );
}

SCM scm_screem_site_get_page_from_tab( SCM s, SCM t )
{
	Site *site = (Site*)SCM2PTR( s );
	gint num;
	Page *page;

	num = gh_scm2int( t );

	page = screem_site_get_page_from_tab( site, num );

	return PTR2SCM( page );
}

SCM scm_screem_site_set_passive_ftp( SCM s, SCM v )
{
	Site *site = (Site*)SCM2PTR( s );
	gboolean val;

	val = gh_scm2bool( v );

	screem_site_set_passive_ftp( site, val );
	
	return SCM_EOL;
}

SCM scm_screem_site_get_passive_ftp( SCM s )
{
	Site *site = (Site*)SCM2PTR( s );
	gboolean val;

      	val = screem_site_get_passive_ftp( site );

	return gh_bool2scm( val );
}

SCM scm_screem_site_set_no_delete( SCM s, SCM v )
{
	Site *site = (Site*)SCM2PTR( s );
	gboolean val;

	val = gh_scm2bool( v );

	screem_site_set_no_delete( site, val );
	
	return SCM_EOL;
}

SCM scm_screem_site_get_no_delete( SCM s )
{
	Site *site = (Site*)SCM2PTR( s );
	gboolean val;

      	val = screem_site_get_no_delete( site );

	return gh_bool2scm( val );
}

SCM scm_screem_site_set_check_moved( SCM s, SCM v )
{
	Site *site = (Site*)SCM2PTR( s );
	gboolean val;

	val = gh_scm2bool( v );

	screem_site_set_check_moved( site, val );
	
	return SCM_EOL;
}

SCM scm_screem_site_get_check_moved( SCM s )
{
	Site *site = (Site*)SCM2PTR( s );
	gboolean val;

      	val = screem_site_get_check_moved( site );

	return gh_bool2scm( val );
}

SCM scm_screem_site_set_no_overwrite( SCM s, SCM v )
{
	Site *site = (Site*)SCM2PTR( s );
	gboolean val;

	val = gh_scm2bool( v );

	screem_site_set_no_overwrite( site, val );
	
	return SCM_EOL;
}

SCM scm_screem_site_get_no_overwrite( SCM s )
{
	Site *site = (Site*)SCM2PTR( s );
	gboolean val;

      	val = screem_site_get_no_overwrite( site );

	return gh_bool2scm( val );
}

SCM scm_screem_site_set_permissions( SCM s, SCM p )
{
	Site *site = (Site*)SCM2PTR( s );
	SitePerms permissions;

	permissions = gh_scm2int( p );

	screem_site_set_permissions( site, permissions );

	return SCM_EOL;
}

SCM scm_screem_site_get_permissions( SCM s )
{
	Site *site = (Site*)SCM2PTR( s );
	SitePerms permissions;

	permissions = screem_site_get_permissions( site );

	return gh_int2scm( permissions );
}

SCM scm_screem_site_set_symlinks( SCM s, SCM p )
{
	Site *site = (Site*)SCM2PTR( s );
	SitePerms symlinks;

	symlinks = gh_scm2int( p );

	screem_site_set_symlinks( site, symlinks );

	return SCM_EOL;
}

SCM scm_screem_site_get_symlinks( SCM s )
{
	Site *site = (Site*)SCM2PTR( s );
	SitePerms symlinks;

	symlinks = screem_site_get_symlinks( site );

	return gh_int2scm( symlinks );
}

SCM scm_screem_site_is_excluded( SCM s, SCM p )
{
	Site *site = (Site*)SCM2PTR( s );
	gchar *path;
	gint len;
	gboolean excluded;

	path = gh_scm2newstr( p, &len );

	excluded = screem_site_is_excluded( site, path );

	return gh_bool2scm( excluded );
}

SCM scm_screem_site_add_exclude( SCM s, SCM p )
{
	Site *site = (Site*)SCM2PTR( s );
	gchar *path;
	gint len;

	path = gh_scm2newstr( p, &len );

	screem_site_add_exclude( site, path );

	return SCM_EOL;
}

SCM scm_screem_site_remove_exclude( SCM s, SCM p )
{
	Site *site = (Site*)SCM2PTR( s );
	gchar *path;
	gint len;

	path = gh_scm2newstr( p, &len );

	screem_site_remove_exclude( site, path );

	return SCM_EOL;
}

SCM scm_screem_site_is_ascii( SCM s, SCM p )
{
	Site *site = (Site*)SCM2PTR( s );
	gchar *path;
	gint len;
	gboolean ascii;

	path = gh_scm2newstr( p, &len );

	ascii = screem_site_is_ascii( site, path );

	return gh_bool2scm( ascii );
}

SCM scm_screem_site_add_ascii( SCM s, SCM p )
{
	Site *site = (Site*)SCM2PTR( s );
	gchar *path;
	gint len;

	path = gh_scm2newstr( p, &len );

	screem_site_add_ascii( site, path );

	return SCM_EOL;
}

SCM scm_screem_site_remove_ascii( SCM s, SCM p )
{
	Site *site = (Site*)SCM2PTR( s );
	gchar *path;
	gint len;

	path = gh_scm2newstr( p, &len );

	screem_site_remove_ascii( site, path );

	return SCM_EOL;
}

SCM scm_screem_site_is_ignored( SCM s, SCM p )
{
	Site *site = (Site*)SCM2PTR( s );
	gchar *path;
	gint len;
	gboolean ignored;

	path = gh_scm2newstr( p, &len );

	ignored = screem_site_is_ignored( site, path );

	return gh_bool2scm( ignored );
}

SCM scm_screem_site_add_ignore( SCM s, SCM p )
{
	Site *site = (Site*)SCM2PTR( s );
	gchar *path;
	gint len;

	path = gh_scm2newstr( p, &len );

	screem_site_add_ignore( site, path );

	return SCM_EOL;
}

SCM scm_screem_site_remove_ignore( SCM s, SCM p )
{
	Site *site = (Site*)SCM2PTR( s );
	gchar *path;
	gint len;

	path = gh_scm2newstr( p, &len );

	screem_site_remove_ignore( site, path );

	return SCM_EOL;
}

SCM scm_screem_site_save( SCM s )
{
	Site *site = (Site*)SCM2PTR( s );

	screem_site_save( site );

	return SCM_EOL;
}

SCM scm_screem_site_create( SCM s )
{
	Site *site = (Site*)SCM2PTR( s );

	screem_site_create( site );

	return SCM_EOL;
}

SCM scm_screem_site_load( SCM s )
{
	Site *site = (Site*)SCM2PTR( s );
	gboolean ret;

	ret = screem_site_load( site );

	return gh_bool2scm( ret );
}

SCM scm_screem_site_write_project_file( SCM s )
{
	Site *site = (Site*)SCM2PTR( s );
	gboolean ret;

	ret = screem_site_write_project_file( site );

	return gh_bool2scm( ret );
}

SCM scm_screem_site_parse_project_file( SCM s, SCM x )
{
	Site *site = (Site*)SCM2PTR( s );
	xmlDocPtr doc = (xmlDocPtr)SCM2PTR( x );
	gboolean ret;

	ret = screem_site_parse_project_file( site, doc );

	return gh_bool2scm( ret );
}

SCM scm_screem_site_locate_page( SCM s, SCM p )
{
	Site *site = (Site*)SCM2PTR( s );
	gchar *path;
	gint len;
	Page *page;

	path = gh_scm2newstr( p, &len );

	page = screem_site_locate_page( site, path );

	return PTR2SCM( page );
}

SCM scm_screem_site_add_page( SCM s, SCM p )
{
	Site *site = (Site*)SCM2PTR( s );
	gchar *path;
	gint len;

	path = gh_scm2newstr( p, &len );

	screem_site_add_page( site, path );

	return SCM_EOL;
}

SCM scm_screem_site_remove_page( SCM s, SCM p )
{
	Site *site = (Site*)SCM2PTR( s );
	gchar *path;
	gint len;
	Page *page;

	path = gh_scm2newstr( p, &len );

	page = screem_site_remove_page( site, path );

	return PTR2SCM( page );
}

SCM scm_screem_site_get_pages( SCM s )
{
	Site *site = (Site*)SCM2PTR( s );
	GList *list;

	list = screem_site_get_pages( site );

	return PTR2SCM( list );
}

SCM scm_screem_site_locate_task( SCM s, SCM p )
{
	Site *site = (Site*)SCM2PTR( s );
	gchar *path;
	gint len;
	TodoItem *task;

	path = gh_scm2newstr( p, &len );

	task = screem_site_locate_task( site, path );

	return PTR2SCM( task );
}

SCM scm_screem_site_add_task( SCM s, SCM p )
{
	Site *site = (Site*)SCM2PTR( s );
	TodoItem *task;

	task = (TodoItem*)SCM2PTR( p );

	screem_site_add_task( site, task );

	return SCM_EOL;
}

SCM scm_screem_site_remove_task( SCM s, SCM p )
{
	Site *site = (Site*)SCM2PTR( s );
	gchar *path;
	gint len;
	TodoItem *task;

	path = gh_scm2newstr( p, &len );

	task = screem_site_remove_task( site, path );

	return PTR2SCM( task );
}

SCM scm_screem_site_get_tasks( SCM s )
{
	Site *site = (Site*)SCM2PTR( s );
	GList *list;

	list = screem_site_get_tasks( site );

	return PTR2SCM( list );
}

SCM scm_screem_site_file_change( SCM  s, SCM src, SCM dest )
{
	Site *site = (Site*)SCM2PTR( s );
	gchar *source;
	gchar *destination;
	gint len;

	source = gh_scm2newstr( src, &len );
	destination = gh_scm2newstr( dest, &len );

	screem_site_file_change( site, source, destination );

	return SCM_EOL;
}

#endif
