/*  Screem:  tableWizard.c
 *  The html table layout wizard, converted to being a g_module
 *
 *  Copyright (C) 1999  David A Knight
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *  For contact information with the author of this source code please see
 *  the AUTHORS file.  If there is no AUTHORS file present then check the
 *  about box under the help menu for a contact address
 */

#include <config.h>

#include <gmodule.h>
#include <gnome.h>

#include <glade/glade.h>

#include "site.h"
#include "page.h"
#include "editor.h"

extern GtkWidget *app;
extern Site *current_site;

static GtkWidget *dialog;
static GladeXML *xml;

G_MODULE_EXPORT const gchar* g_module_check_init( GModule *module );
G_MODULE_EXPORT void g_module_unload( GModule *module );
G_MODULE_EXPORT void init( void );
void table_wizard_closed( GtkWidget *widget, GdkEvent *event );
void table_wizard_clicked( GtkWidget *w, gint button );
void tableWizard( void );

G_MODULE_EXPORT const gchar* g_module_check_init( GModule *module )
{
	g_print("tableWizard: check-init\n");
	return NULL;
}

G_MODULE_EXPORT void g_module_unload( GModule *module )
{
	g_print( "tableWizard: unloaded\n" );
}

G_MODULE_EXPORT void init() 
{
	GtkWidget *tableButton;
	GtkWidget *toolbar;

	GnomeUIInfo menuinfo[] = { 
		{
			GNOME_APP_UI_ITEM, N_("Table..."),
			N_("Insert a Table"),
			tableWizard, NULL, NULL,
			GNOME_APP_PIXMAP_STOCK,
			GNOME_STOCK_MENU_BLANK,
			0,
			GDK_CONTROL_MASK, NULL
		},
		GNOMEUIINFO_END
	};

	toolbar = gtk_object_get_data( GTK_OBJECT( app ), "wizardbar" );


	/* place menu item after image under insert */
	gnome_app_insert_menus( GNOME_APP( app ), _("_Insert/"), menuinfo );

	/* place a button on the wizards toolbar */
	tableButton = 
		gnome_stock_new_with_icon( GNOME_STOCK_PIXMAP_TABLE_FILL );

	gtk_toolbar_append_item( GTK_TOOLBAR( toolbar ), "",
				 _("Table Wizard"), "", tableButton ,
				 tableWizard, 0 );

	g_print( "tableWizard: initialised\n" );
}


void table_wizard_closed( GtkWidget *widget, GdkEvent *event )
{
	dialog = NULL;
}

void table_wizard_clicked( GtkWidget *w, gint button )
{
	gint c;
	gint pos;
	GtkWidget *widget;
	GtkWidget *widget2;
	gint border = 0;
	GString *text;
	gint cellSpacing;
	gint cellPadding;
	gint width_value;
	guint8 r, g, b, a;
	gint rows;
	gint cols;
	gboolean caption;

    	if( button < 2 ) {
		widget = glade_xml_get_widget( xml, "caption" );
		caption = gtk_toggle_button_get_active( GTK_TOGGLE_BUTTON( widget ) );
		widget = glade_xml_get_widget( xml, "border" );
		if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON( widget ))) {
			widget = glade_xml_get_widget( xml, "border_width" );
			border = gtk_spin_button_get_value_as_int( GTK_SPIN_BUTTON ( widget ) );
		}

		text = g_string_new( "" );
		g_string_sprintf( text, "<table border=\"%d\"", border );

		widget = glade_xml_get_widget( xml, "left" );
		widget2 = glade_xml_get_widget( xml, "centre" );

		if( gtk_toggle_button_get_active( GTK_TOGGLE_BUTTON(widget) ) )
			g_string_append( text, " align=\"left\"" );
		else if( gtk_toggle_button_get_active( GTK_TOGGLE_BUTTON( widget2) ) )
			g_string_append( text, " align=\"center\"" );
		else
			g_string_append( text, " align=\"right\"" );

		widget = glade_xml_get_widget( xml, "spacing" );
	        cellSpacing = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON(widget));
		widget = glade_xml_get_widget( xml, "padding" );
	        cellPadding = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON(widget));
		g_string_sprintfa( text, 
				   " cellspacing=\"%d\" cellpadding=\"%d\"",
				   cellSpacing, cellPadding );
	
		widget = glade_xml_get_widget( xml, "rows" );
	        rows = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON(widget));
		widget = glade_xml_get_widget( xml, "cols" );
	        cols = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON(widget));

		widget = glade_xml_get_widget( xml, "width" );
		if( gtk_toggle_button_get_active( GTK_TOGGLE_BUTTON( widget ) ) ) {
			widget = glade_xml_get_widget( xml, "table_width" );
			width_value = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(widget));
			g_string_sprintfa( text, " width=\"%d\"",
					   width_value );
					
			widget = glade_xml_get_widget( xml, "percent" );
			if( gtk_toggle_button_get_active( GTK_TOGGLE_BUTTON( widget ) ) )
				g_string_append_c( text, '%' );
			g_string_append_c( text, '"' );
		}

		widget = glade_xml_get_widget( xml, "use_colour" );
		if( gtk_toggle_button_get_active( GTK_TOGGLE_BUTTON( widget ) ) ) {
			widget = glade_xml_get_widget( xml, "colour" );
			gnome_color_picker_get_i8( GNOME_COLOR_PICKER( widget ), &r, &g, &b, &a);
			g_string_sprintfa( text, 
					   " bgcolor=\"#%.2x%.2x%.2x\"",r,g,b);
		}

		widget = glade_xml_get_widget( xml, "use_image" );
		if( gtk_toggle_button_get_active( GTK_TOGGLE_BUTTON( widget ) ) ) {
			widget = glade_xml_get_widget( xml, "image" );
			g_string_sprintfa( text, " background=\"%s\"",
					   gtk_entry_get_text( GTK_ENTRY( widget ) ) );
		}

		widget = glade_xml_get_widget( xml, "summary" );
		if( gtk_toggle_button_get_active( GTK_TOGGLE_BUTTON( widget ) ) ) {
			widget = glade_xml_get_widget( xml, "summary_text" );
			g_string_sprintfa( text, " summary=\"%s\"",
					   gtk_entry_get_text( GTK_ENTRY( widget ) ) );
		}

		g_string_append_c( text, '>' );

		widget = glade_xml_get_widget( xml, "above" );
		if( caption &&
		    gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)) ) {
			g_string_append( text,  "\n<caption> </caption>" );
			caption = FALSE;
		}

		for( ; rows; rows -- ) {
			g_string_append( text, "\n<tr>\n" );
			for( c = 0; c < cols; c ++ )
				g_string_append( text, "\n<td> </td>" );
			g_string_append( text, "\n</tr>" );
		}

		if( caption )
			g_string_append( text,  "\n<caption> </caption>" );

		g_string_append( text, "\n</table>" );

		pos = screem_editor_get_pos();
		screem_editor_insert( pos, text->str );
		screem_editor_set_pos( pos + strlen( text->str ) );

		g_string_free( text, TRUE );
	}

	if( button == 2 || button == 0 ) {
		gtk_widget_destroy( dialog );
		dialog = NULL;
	}
}

void tableWizard()
{
	Page *page;

        page = screem_site_get_current_page( current_site );
        
        g_return_if_fail( page != NULL );

	if( dialog ) {
                gdk_window_raise( dialog->window );
                gdk_window_show( dialog->window );
                return;
        }

	xml = glade_xml_new( GLADE_PATH"/tablewizard.glade", "tablewizard" );
        glade_xml_signal_autoconnect( xml );

        dialog = glade_xml_get_widget( xml, "tablewizard" );
}
