#ifndef PAGEUI_H
#define PAGEUI_H

gboolean screem_page_insert( Page *page );
gboolean screem_page_open( void );
gboolean screem_page_open_with_filename( const gchar *filename );
gboolean screem_page_save_as( void );
gint screem_page_save_confirmation( Page *page );
void screem_page_save_proxy( void );
void screem_page_revert_proxy( void );
void screem_page_revert_page( Page *page );
void screem_page_create_page( void );
void screem_page_create_blank_page( void );
void screem_page_close_page( Page *page );
void screem_page_close_current( void );
void preview_current_page( void );
void screem_page_druid( Page *page );
void build_recent_pages_menu( void );
void page_book_switch( GtkNotebook *notebook, GtkNotebookPage *page,
			guint page_num );
gboolean screem_page_save_check( Page *page );
gchar *screem_page_id_charset( Page *page );

void switch_to( GtkWidget *widget, gchar *which );

gboolean screem_page_tab_clicked( GtkWidget *label, GdkEventButton *event );
gint screem_page_get_tab_num( GtkWidget *label );
void screem_page_save_tab( GtkWidget *item );
void screem_page_save_as_tab( GtkWidget *item );
void screem_page_close_tab( GtkWidget *item );
void screem_page_rename_tab( GtkWidget *item );
void screem_page_set_tab_label( Page *page );


#endif
