#ifndef SCREEM_DTD_H
#define SCREEM_DTD_H

#include <gtk/gtk.h>

enum { OPEN, CLOSE, SUB };

enum { NAME, ENTITY, EXPR };

enum { ANAME, AVAL, ADEF, ANEXT };

typedef enum CloseState {
	OPTIONAL = 1,
	REQUIRED = 2,
	FORBIDDEN = 0
} CloseState;

typedef struct ScreemDTD {
	gchar      *url;
	GHashTable *elements;
	GHashTable *entities;
	GHashTable *attributes;
} ScreemDTD;

typedef struct ScreemDTDEntity {
	gchar *name;
	gchar *value;
} ScreemDTDEntity;

typedef struct ScreemDTDAttribute {
	gchar *name;
	gchar *defval;
	gchar **values;
} ScreemDTDAttribute;

typedef struct ScreemDTDAllow {
	GList *elements;
	gint number;            /* -1 = any, 0 = 1 or more, 1 = 0/1 */
	struct ScreemDTDAllow *next;
	struct ScreemDTDAllow *prev;
} ScreemDTDAllow;

typedef struct ScreemDTDElement {
	gchar *name;
	gboolean can_close;
	gboolean must_close;
	GList *attributes;
	ScreemDTDAllow *allow;
} ScreemDTDElement;



ScreemDTD* screem_dtd_new( void );
void screem_dtd_destroy( ScreemDTD *dtd );
ScreemDTD* screem_dtd_load_doctype( const gchar *tag );
ScreemDTD* screem_dtd_load_remote( const gchar *url, const gchar *type );
ScreemDTD* screem_dtd_load_type( const gchar *type );
ScreemDTD* screem_dtd_load( const gchar *filename );
ScreemDTD* screem_dtd_parse( GString *dtd_data );
void screem_dtd_parse_entity( ScreemDTD *dtd, gchar *tag );
void screem_dtd_parse_element( ScreemDTD *dtd, gchar *tag );
void screem_dtd_parse_attlist( ScreemDTD *dtd, gchar *tag );
GList* screem_dtd_parse_attribute( ScreemDTD *dtd, gchar *tag, GList *list );
gchar* screem_dtd_parse_name( ScreemDTD *dtd, gchar *tag, GString *full );
	
gchar* screem_dtd_parse_allowed_elements( ScreemDTD *dtd, 
					  ScreemDTDElement *element,
					  gchar *tag );
CloseState screem_dtd_element_get_close_state( ScreemDTD *dtd, gchar *name );
GList* screem_dtd_element_get_attributes( ScreemDTD *dtd, gchar *name );
void screem_loaded_dtds( void );
void screem_dtd_fill_combo( GtkWidget *combo );

GtkWidget *screem_dtd_allowed_tags_menu( ScreemDTD *dtd, gchar *name );
GtkWidget *screem_dtd_build_attribute_menu( ScreemDTD *dtd, gchar *name,
					    gboolean sub );


void screem_dtd_load_catalog( void );

/* actually defined in editor.c, be declared here as it returns a ScreemDTD* */
ScreemDTD * screem_get_doctype( const gchar *text );


ScreemDTDAttribute *screem_dtd_check_attribute( ScreemDTD *dtd, gchar *name );
ScreemDTDElement *screem_dtd_check_element( ScreemDTD *dtd, gchar *name );

gchar *screem_dtd_build_doctype_tag( const gchar *type );

#endif
