#ifndef SCREEM_APPS_MODEL_H
#define SCREEM_APPS_MODEL_H

#include <gtk/gtkliststore.h>

#define SCREEM_TYPE_APPS_MODEL  (screem_apps_model_get_type())
#define SCREEM_APPS_MODEL(obj)  (G_TYPE_CHECK_INSTANCE_CAST( ( obj ), SCREEM_TYPE_APPS_MODEL, \
                                                ScreemAppsModel ) )
#define SCREEM_APPS_MODEL_CLASS(klass)  (G_TYPE_CHECK_CLASS_CAST( ( klass ), \
                                                             SCREEM_TYPE_APPS_MODEL, \
                                                             ScreemAppsModelClass ) )
#define SCREEM_IS_APPS_MODEL(obj)  (G_TYPE_CHECK_INSTANCE_TYPE( ( obj ), SCREEM_TYPE_APPS_MODEL ) )

typedef struct ScreemAppsModelPrivate ScreemAppsModelPrivate;

enum {
	AVAILABLE_APP_COLUMN_ICON,
	AVAILABLE_APP_COLUMN_ICON_FILE,
	AVAILABLE_APP_COLUMN_NAME,
	AVAILABLE_APP_COLUMN_COMMENT,
	AVAILABLE_APP_COLUMN_PATH,
	AVAILABLE_APP_COLUMN_EXEC,
	AVAILABLE_APP_NUM_COLUMNS
};

typedef struct {
	GtkListStore parent;
	
	ScreemAppsModelPrivate *priv;
} ScreemAppsModel;

typedef struct {
	GtkListStoreClass parent_class;

} ScreemAppsModelClass;

GType screem_apps_model_get_type( void );
ScreemAppsModel *screem_apps_model_new( void );


void screem_apps_model_setup_cell_layout( GtkWidget *widget );
GtkTreeModel *screem_apps_model_get_default( void );


#endif
