#ifndef SCREEM_SPELL_H
#define SCREEM_SPELL_H

#include <glib-object.h>


#define SCREEM_TYPE_SPELL            (screem_spell_get_type ())
#define SCREEM_SPELL(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), SCREEM_TYPE_SPELL, ScreemSpell))
#define SCREEM_SPELL_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), SCREEM_TYPE_SPELL, ScreemSpellClass))
#define SCREEM_IS_SPELL(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SCREEM_TYPE_SPELL))


typedef struct ScreemSpellPrivate ScreemSpellPrivate;

typedef struct {
	GObject parent;

	ScreemSpellPrivate *private;
} ScreemSpell;

typedef struct {
	GObjectClass parent_class;

	void (*highlight) (ScreemSpell *spell, gint start, gint end);

} ScreemSpellClass;


GType screem_spell_get_type( void );

ScreemSpell* screem_spell_new( void );

gboolean screem_spell_check_word( ScreemSpell *spell, const gchar *word );

void screem_spell_check_interactive( ScreemSpell *spell );

#endif
