#ifndef SCREEM_EDITOR_H
#define SCREEM_EDITOR_H

#include <sys/types.h>

#include "screem-view.h"

#define SCREEM_TYPE_EDITOR  (screem_editor_get_type())
#define SCREEM_EDITOR(obj)  (G_TYPE_CHECK_INSTANCE_CAST( ( obj ),   \
                                                SCREEM_TYPE_EDITOR, \
                                                ScreemEditor ) )
#define SCREEM_IS_EDITOR(obj)  (G_TYPE_CHECK_INSTANCE_TYPE( ( obj ), \
                                               SCREEM_TYPE_EDITOR ) )

typedef struct ScreemEditorPrivate ScreemEditorPrivate;

typedef struct {
	ScreemView parent;

	ScreemEditorPrivate *private;
} ScreemEditor;

typedef struct {
	ScreemViewClass parent_class;

	void (*overwrite)( ScreemEditor *editor, gboolean overwrite );
} ScreemEditorClass;

typedef enum {
	TEXT,
	ADD_CLOSE
} ScreemEditorAction;

typedef struct {
	gchar *key_name;
	gchar *text;
	ScreemEditorAction action;
} ScreemEditorMacro;

GType screem_editor_get_type( void );
ScreemEditor *screem_editor_new( ScreemWindow *window );

/* clipboard related functions */
void screem_editor_cut( ScreemEditor *editor );
void screem_editor_copy( ScreemEditor *editor );
void screem_editor_paste( ScreemEditor *editor );
void screem_editor_paste_unformatted( ScreemEditor *editor );
void screem_editor_paste_encoded( ScreemEditor *editor );
void screem_editor_clear_selection( ScreemEditor *editor );

gboolean screem_editor_has_selection( ScreemEditor *editor, 
				      guint *start, guint *end );
void screem_editor_select_region( ScreemEditor *editor, 
				  guint start, guint len );

/* insertion / deletion related functions */
void screem_editor_insert( ScreemEditor *editor, 
			   gint pos, const gchar *text );
void screem_editor_insert_markup( ScreemEditor *editor, 
				  const gchar *open_element, 
				  const gchar *close_element );
void screem_editor_insert_file( ScreemEditor *editor, 
				const gchar *filename );
void screem_editor_insert_attribute( ScreemEditor *editor, 
				     const gchar *attribute );

void screem_editor_delete_forward( ScreemEditor *editor, 
				   guint pos, guint len );
gint screem_editor_auto_indent( ScreemEditor *editor, gint pos );
void screem_editor_indent( ScreemEditor *editor, guint pos );
void screem_editor_unindent( ScreemEditor *editor, guint pos );

/* position / text functions */
gchar *screem_editor_get_text( ScreemEditor *editor, 
			       guint from, guint len );
void screem_editor_set_pos( ScreemEditor *editor, guint pos );
guint screem_editor_get_pos( ScreemEditor *editor );
void screem_editor_goto_line( ScreemEditor *editor, gint line );
void screem_editor_encode_text( ScreemEditor *editor, gboolean urienc );
gchar* screem_editor_get_word( ScreemEditor *editor, gint pos );


#endif
