#!/bin/sh
# the next line restarts using tclsh -*- tcl -*- \
exec tclsh "$0" "$@"
#
# snmp_disman.tcl -
#
#	Simple interface for the DISMAN MIBs. This currently only
#	supports the DISMAN Script MIB.
#
# Copyright (c) 1998      Technical University of Braunschweig.
#
# See the file "license.terms" for information on usage and redistribution
# of this file, and for a DISCLAIMER OF ALL WARRANTIES.
#
# @(#) $Id: snmp_disman.tcl,v 1.3 1999/06/21 13:11:14 schoenw Exp $

package require Tnm 3.0
package require TnmSnmp $tnm(version)
package require TnmDisman $tnm(version)

namespace import Tnm::*

ined size
LoadDefaults snmp
SnmpInit DISMAN

##
## List all scalars of a group for the node objects in list.
##

proc ShowScalars {list group} {
    ForeachIpNode id ip host $list {
	set s [SnmpOpen $id $ip]
        writeln [TnmSnmp::ShowScalars $s $group]
        $s destroy
    }
}

##
## Show a complete MIB table for the node objects in list.
##

proc ShowTable {list table} {
    ForeachIpNode id ip host $list {
	set s [SnmpOpen $id $ip]
        writeln [TnmSnmp::ShowTable $s $table]
        $s destroy
    }
}

proc "List Scripts" {list} {
    ShowTable $list smScriptTable
}

proc "Install Script" {list} {
    global tnm
    set owner $tnm(user)
    set name ""
    set source ""
    ForeachIpNode id ip host $list {
	set res [ined request "Install a new script on $host:" \
		[list [list "Owner:" $owner entry 20] \
	              [list "Name:" $name entry 20] \
		      [list "Source:" $source entry 20] ] \
	        [list install cancel] ]

	if {[lindex $res 0] == "cancel"} return

	set owner  [lindex $res 1]
	set name   [lindex $res 2]
	set source [lindex $res 3]

	set s [SnmpOpen $id $ip]
	TnmDisman::InstallScript $s $owner $name 1 $source
	$s destroy
    }
}

proc "Launchable Scripts" {list} {
    ShowTable $list smLaunchTable
}

proc "Running Scripts" {list} {
    ShowTable $list smRunTable
}

proc "Launch Script" {list} {
    ForeachIpNode id ip host $list {
        set s [SnmpOpen $id $ip]
	$s walk vbl {smLaunchOperStatus} {
	    set smLaunchOperStatus [snmp value $vbl 0]
	    if {$smLaunchOperStatus == "enabled"} {
		lappend launchList [mib unpack [snmp oid $vbl 0]]
	    }
	}
	$s destroy
    }

    if {! [info exists launchList]} {
	ined acknowledge "Could not find a single launch button."
	return
    }
    set result [ined list "Select a launchable script:" \
	    $launchList "select cancel"]
    if {[lindex $result 0] == "cancel"} {
	return
    }
    set owner [lindex [lindex $result 1] 0]
    set name [lindex [lindex $result 1] 1]

    ForeachIpNode id ip host $list {
	set s [SnmpOpen $id $ip]
	set oid [mib pack smLaunchStart $owner $name]
	set code [catch {$s set [list [list $oid 0]]} msg]
	if {$code} {
	    writeln "Failed to start script $name owned by $owner on $host:"
	    writeln "  -> $msg"
	}
	$s destroy
    }
}

proc "Kill Running Script" {list} {
    ForeachIpNode id ip host $list {
	set s [SnmpOpen $id $ip]
	set s [SnmpOpen $id $ip]
        $s walk vbl {smRunState} {
	    set smRunState [snmp value $vbl 0]
	    set instance [lindex [mib split [snmp oid $vbl 0]] 1]
	    set code [catch {$s set [list [list smRunControl.$instance abort]]} msg]
	    writeln "$smRunState\[$instance\]: $msg"
	}
        $s destroy
    }
}

##
## Set the parameters (community, timeout, retry) for snmp requests.
##

proc "Set SNMP Parameter" {list} {
    SnmpParameter $list
}

##
## Display some help about this tool.
##

proc "Help DISMAN" {list} {
    ined browse "Help about DISMAN" {
	"Installed Scripts:" 
	"    List the installed scripts." 
	"" 
	"Launchable Scripts:" 
	"    List the scripts that are ready to be launched." 
	"" 
	"Running Scripts:" 
	"    List running or terminated scripts." 
	"" 
	"Launch Script:" 
	"    Launch a script." 
	"" 
	"Kill Running Script:" 
	"    Kill a running script." 
	"" 
	"Set SNMP Parameter:" 
	"    This dialog allows you to set SNMP parameters like retries, " 
	"    timeouts, community name and port number. " 
    }
}

##
## Delete the menus created by this interpreter.
##

proc "Delete DISMAN" {list} {
    global menus
    foreach id $menus { ined delete $id }
    exit
}

set menus [ ined create MENU "DISMAN" \
    "Scripts:List Scripts" "Scripts:Install Script" "Scripts:Delete Script" \
    "Scripts:Load Script" "Scripts:Unload Script" "" \
    "Launchable Scripts" "" \
    "Running Scripts" "" \
    "Launch Script" "Kill Running Script" "" \
    "Set SNMP Parameter" "" \
    "Help DISMAN" "Delete DISMAN" ]

vwait forever
