CREATE TABLE subscription_payments (
  uid int(11) NOT NULL default '0',
  order_id varchar(50) NOT NULL default '',
  cost decimal(7,2) NOT NULL default '0.00',
  pay_type varchar(10) NOT NULL default '',
  auth_date date NOT NULL default '0000-00-00',
  final_date date default NULL,
  paid int(1) default NULL,
  type varchar(50) NOT NULL default '',
  PRIMARY KEY  (uid,order_id)
);


CREATE TABLE subscription_info (
  uid int(11) NOT NULL default '0',
  expires int(11) NOT NULL default '0',
  created datetime NOT NULL,
  last_updated datetime NOT NULL,
  updated_by varchar(50) default '',
  active int(1) NOT NULL default '0',
  type varchar(50) NOT NULL default '',
  PRIMARY KEY (uid)
);


CREATE TABLE subscription_types (
  type varchar(50) NOT NULL default '',
  perm_group_id varchar(50) NOT NULL default '',
  cost decimal(7,2) NOT NULL default '0.00',
  max_time int(11) NOT NULL default 0,
  renewable int(1) NOT NULL default 1,
  description text default ''
);

INSERT INTO admin_tools VALUES ('subscriptions',16,'Subscriptions','Subscriptions','subscription_admin','sub_admin',0);

UPDATE blocks SET block = CONCAT(block, ',\nsubscription_admin') WHERE bid = 'perms';
UPDATE perm_groups SET group_perms = CONCAT(group_perms, ',subscription_admin') WHERE perm_group_id = 'Superuser';

INSERT INTO blocks VALUES ('subscribe_template','<HTML>\r\n<HEAD>\r\n<TITLE>%%sitename%% || %%subtitle%%</TITLE>\r\n</HEAD>\r\n<BODY bgcolor=\"#FFFFFF\" text=\"#000000\" link=\"#006699\" vlink=\"#003366\">\r\n\r\n%%header%%\r\n\r\n<!-- Main layout table -->\r\n<TABLE BORDER=0 WIDTH=\"99%\" ALIGN=\"center\" CELLPADDING=0 CELLSPACING=10>\r\n    <!-- Main page block -->\r\n    <TR>\r\n        \r\n        <!-- Center content section -->\r\n        <TD VALIGN=\"top\" width=\"75%\">\r\n            %%CONTENT%%\r\n        </TD>\r\n        <!-- X center content section -->\r\n        \r\n        <!-- Right boxes column -->\r\n        <TD VALIGN=\"top\" WIDTH=\"25%\">\r\n\r\n            %%BOX,main_menu%%\r\n            %%BOX,hotlist_box%%\r\n            %%BOX,user_box%%\r\n            %%BOX,admin_tools%%\r\n            %%BOX,poll_box%%\r\n        \r\n        </TD>\r\n        <!-- X Right boxes column -->\r\n    </TR>\r\n    <!-- X main page block -->\r\n</TABLE>\r\n<!-- X Main layout table -->\r\n<P>\r\n%%footer%%\r\n<P>\r\n<CENTER>%%BOX,menu_footer%%</CENTER>\r\n</BODY>\r\n</HTML>\r\n',NULL,'Template for subscription pages','subscriptions','default','en');
INSERT INTO blocks VALUES ('sub_manual_change_email','The user %%NICK%% has subscribed for %%MONTHS%% months of \r\nsubscription \"%%TYPE%%\". The user\'s existing group does \r\nnot allow group changes. Please review this user\'s request \r\nat %%URL%%.\r\n\r\n-%%sitename%%\r\n%%local_email%%','1','','subscriptions','default','en');
INSERT INTO blocks VALUES ('sub_email_success','Thank you for subscribing!\r\n\r\nYou have added %%MONTHS%% months to your subscription, of \r\nthe type \"%%TYPE%%\". Your subscription will expire on\r\n%%EXP_DATE%%.\r\n\r\n','1','','subscriptions','default','en');
INSERT INTO blocks VALUES ('content_only_page_template','%%CONTENT%%','1','','templates','default','en');
INSERT INTO blocks VALUES ('sub_paypal_canceled','Sorry you cenceled.','1','The message to display when someone cancels a paypal subscription.','subscriptions','default','en');

INSERT INTO box VALUES ('subpay_type_select','Select Payment Type','my $pay_type = $S->cgi->param(\'pay_type\');\r\nmy $type   = $S->cgi->param(\'type\'  );\r\nmy $months = $S->cgi->param(\'months\');\r\n\r\nif ($pay_type) {\r\n  return \"%%BOX,subpay_cc,$type,$months%%\" if ($pay_type eq \'cc\');\r\n  return \"%%BOX,subpay_paypal,$type,$months%%\" if ($pay_type eq \'paypal\');\r\n  if ($pay_type eq \'none\') {\r\n  	my $return = $S->sub_activate_immediate($type, $months);\r\n	return $return if ($return);\r\n  }\r\n}\r\n#%%\r\nwarn \"Months: $months\\n\";\r\n\r\nunless ($months && $type) {\r\n  return \'Error! No subscription type or duration provided.\';\r\n}\r\n\r\nmy $type_data = $S->sub_get_type($type);\r\n\r\n# Bounds check the period\r\n$months = $type_data->{max_time} if (($type_data->{max_time}) && $months > $type_data->{max_time});\r\n\r\n# If it\'s a free sub, see if they\'ve already had it\r\nif ($S->sub_check_renewable($type_data->{type})) {\r\n  return \'Sorry, but you may not renew this subscription.\';\r\n}\r\n\r\nmy ($price, $purchase_display) = $S->sub_calculate_purchase_cost($type, $months);\r\n\r\nmy $content = qq{\r\n<table width=\"75%\" border=0 cellpadding=5 cellspacing=0 align=\"center\">\r\n  <tr>\r\n    <td colspan=2>%%norm_font%%\r\n$purchase_display%%norm_font_end%%};\r\n\r\nif ($price eq \'ERROR\') {\r\n    $content .= qq{</td></tr></table>};\r\n    return $content;\r\n} elsif ($price == 0) {\r\n	$content .= qq{\r\n		<center>\r\n		<form method=\"POST\" action=\"%%rootdir%%\">\r\n		<input type=\"hidden\" name=\"op\" value=\"subpay\">\r\n		<input type=\"hidden\" name=\"months\" value=\"$months\">\r\n		<input type=\"hidden\" name=\"type\" value=\"$type\">\r\n		<input type=\"hidden\" name=\"pay_type\" value=\"none\">\r\n		<input type=\"submit\" name=\"finish\" value=\"Finish\">\r\n		</form></center></td></tr></table>};\r\n	return $content;\r\n}\r\n\r\n$content .= qq{%%norm_font%%<p>Ok, now it\'s time for payment. You can pay with paypal, or by \r\ncredit or debit card. Please select a payment type below.</p>\r\n%%norm_font_end%%</td></tr>\r\n  <tr>\r\n    <td align=\"center\">%%norm_font%%<a href=\"/subpay?pay_type=paypal;type=$type;months=$months\"><img src=\"%%imagedir%%/paypal.gif\" border=\"0\" alt=\"Pay with Paypal\"><br>Pay with Paypal</a>%%norm_font_end%%</td>\r\n    <td align=\"center\">%%norm_font%%<a href=\"/subpay?pay_type=cc;type=$type;months=$months\"><img src=\"%%imagedir%%/cclogos.gif\" width=\"87\" height=\"27\" border=0 ALT=\"K5 accepts Visa and MasterCard\"><br>Pay with Visa or Mastercard</a>%%norm_font_end%%</td>\r\n  </tr>\r\n</table>\r\n};\r\n\r\nreturn $content;','Choose the type of payment for a subscription, or, if passed a \"pay_type\" param, just pass through to the appropriate payment processing box.','blank_box',0);
INSERT INTO box VALUES ('subpay_cc','Pay for Your Subscription','my $content;\r\nmy $type   = $ARGS[0];\r\nmy $months = $ARGS[1];\r\n\r\n\r\n# If we\'re ordering, do it now.\r\nif ($S->cgi->param(\'final_pay\')) {\r\n	$content .= $S->cc_place_order(\'subscription\');\r\n	return $content;\r\n}\r\n\r\n\r\nmy $type_data = $S->sub_get_type($type);\r\n\r\n# Bounds check the period\r\n$months = $type_data->{max_time} \r\n    if (($type_data->{max_time}) && $months > $type_data->{max_time});\r\n\r\nmy ($price, $remaining) = $S->sub_calculate_purchase_cost($type, $months);\r\n\r\nmy $content = qq{%%norm_font%%$remaining};\r\n\r\nif ($S->cgi->param(\'pay\')) {\r\n    $content .= $S->cc_preview_order($price,$months,\'subscription\');\r\n}\r\n\r\nmy $p_form = $S->cc_make_person_form();\r\nmy $c_form = $S->cc_make_card_form();\r\n\r\n\r\n$content .= qq{\r\n<p>\r\nPlease fill in the payment form below. Required fields are in \r\n<font color=\"#ff0000\">red</font>. When you are done, click \"Preview Order\". \r\nYou will <b>not</b> be billed yet, and you will be able to change what you\'ve \r\nentered before confirming the order.\r\n<form name=\"subpay\" ACTION=\"/subpay\" METHOD=\"POST\">\r\n<input type=\"hidden\" name=\"months\" value=\"$months\">\r\n<input type=\"hidden\" name=\"pay_type\" value=\"cc\">\r\n<input type=\"hidden\" name=\"type\" value=\"$type\">\r\n<p>\r\n<b>Billing Information:</b>\r\n<p>\r\n$p_form\r\n<p>\r\n<b>Credit/Debit Card Information:</b>\r\n<p>\r\n$c_form\r\n<p>\r\n<input type=\"submit\" name=\"pay\" value=\"Preview Order\">\r\n</form>%%norm_font_end%%};\r\n\r\n#\'\r\n\r\nreturn $content;\r\n','Purchase a subscription with a credit card','blank_box',0);
INSERT INTO box VALUES ('subpay_paypal','','my $content;\r\nmy $type   = $ARGS[0];\r\nmy $months = $ARGS[1];\r\nmy $site = $S->{UI}->{VARS}->{site_url}.$S->{UI}->{VARS}->{rootdir};\r\nmy $secure_site = $S->{UI}->{VARS}->{secure_site_url}.$S->{UI}->{VARS}->{rootdir};\r\nmy $business_id = \'paypal@kuro5hin.org\';\r\nmy $item = \'Subscription\';\r\n\r\nmy $type_data = $S->sub_get_type($type);\r\n\r\n# Bounds check the period\r\n$months = $type_data->{max_time} \r\n    if (($type_data->{max_time}) && $months > $type_data->{max_time});\r\n\r\nmy ($price, $remaining) = $S->sub_calculate_purchase_cost($type, $months);\r\n\r\nmy $finished = $S->cgi->param(\'finished\');\r\nmy $canceled = $S->cgi->param(\'canceled\');\r\n\r\nif ($finished) {\r\n	$content = $S->{UI}->{BLOCKS}->{sub_paypal_finished};	\r\n	return $content;\r\n} elsif ($canceled) {\r\n	$content = $S->{UI}->{BLOCKS}->{sub_paypal_canceled};\r\n	return $content;\r\n}\r\n\r\nmy $paypal_form = qq{\r\n<form action=\"https://www.paypal.com/cgi-bin/webscr\" method=\"post\">\r\n<input type=\"hidden\" name=\"cmd\" value=\"_xclick\">\r\n<input type=\"hidden\" name=\"business\" value=\"$business_id\">\r\n<input type=\"hidden\" name=\"notify_url\" value=\"$site/special/paypal_confirm\">\r\n<input type=\"hidden\" name=\"item_name\" value=\"Subscription\">\r\n<input type=\"hidden\" name=\"item_number\" value=\"$type\">\r\n<input type=\"hidden\" name=\"no_shipping\" value=\"1\">\r\n<input type=\"hidden\" name=\"return\" value=\"$secure_site/subpay?pay_type=paypal;type=$type;months=$months;finished=1\">\r\n<input type=\"hidden\" name=\"cancel_return\" value=\"$secure_site/subpay?pay_type=paypal;type=$type;months=$months;canceled=1\">\r\n<input type=\"hidden\" name=\"amount\" value=\"$price\">\r\n<input type=\"hidden\" name=\"custom\" value=\"$months\">\r\n<input type=\"image\" src=\"%%imagedir%%/paypal.gif\" border=\"0\" name=\"submit\" alt=\"Make payments with PayPal - it\'s fast, free and secure!\">\r\n</form>};\r\n\r\n$content = qq{\r\n%%norm_font%%\r\n$remaining\r\n<p>\r\nClick the Paypal button, and you will go to a page on Paypal where you will finish the payment process.\r\n%%norm_font_end%%\r\n<p>\r\n<table border=0 cellpadding=1 cellspacing=0 bgcolor=\"#000000\" align=\"center\">\r\n  <tr>\r\n    <td>\r\n	  <table width=\"100%\" cellpadding=5 cellspacing=0 border=0 bgcolor=\"#eeeeee\">\r\n		<tr>\r\n		  <td colspan=2 align=\"center\">\r\n		  <FONT FACE=\"verdana, arial, helvetica, sans-serif\" SIZE=\"2\">\r\n		  Click below to purchase.<br>\r\n		  $paypal_form\r\n		  </font>\r\n		  </td>\r\n		</tr>\r\n	  </table>\r\n	</td>\r\n  </tr>\r\n</table>};\r\n\r\nreturn $content;','','blank_box',0);

INSERT INTO ops VALUES ('subscribe','subscribe_template','subscribe',0,1,'','Function for users to purchase a subscription');
INSERT INTO ops VALUES ('subpay','subscribe_template','subpay_type_select',1,1,'','');
