package Scoop;
use strict;

sub format_comment {
	my $S = shift;
	my $comment = shift; # HASHREF
	my $dispmode = $S->session('commentmode');
	my ($nick, $this_comment, $replies, $user);
	my $op = $S->{CGI}->param('op');
	my $dynamic = ($op eq 'dynamic');
	my $sid = $S->{CGI}->param('sid');
	my $cid = $S->{CGI}->param('cid');	
	my $pid = $S->{CGI}->param('pid');	
	my $tool = $S->{CGI}->param('tool');
	my $commentstatus = $S->_check_commentstatus($sid); # 1 = read only

	my ($start, $end, $level_start, $level_end, $item_start, $item_end) =
		$S->_get_comment_list_delimiters($comment->{sid}, $dispmode);
	
	$user = $S->user_data($comment->{uid});
	
	if ($comment->{mode} ne 'alone' && $comment->{mode} ne 'Preview') {	
		$replies = ($S->get_list($comment->{sid}, $comment->{cid}))[0] || ''; 
	}
	
	# This is so that when you rate a comment on a poll page it doesn't kick you out
	# to the main page
	$sid = "";
	if( $S->_does_poll_exist( $comment->{sid} )) {
		$sid = qq|<INPUT TYPE="hidden" NAME="qid" VALUE="$comment->{sid}">
			|;
		$op = "view_poll";
	} else {
		$sid = qq|<INPUT TYPE="hidden" NAME="sid" VALUE="$comment->{sid}">
			|;
	}

	# return nothing unless they have permission to read the comments
	my $section = $S->_get_story_section( $comment->{sid} );
	unless ( ($S->_does_poll_exist( $comment->{sid} ) && $S->have_perm('poll_read_comments') )	||
			$S->have_section_perm('norm_read_comments', $section )) {

		return '';

	}

	my $sect_perm_post = $S->have_section_perm('norm_post_comments', $section );
	$sect_perm_post = 1 if ($S->_does_poll_exist($comment->{sid}) && $S->have_perm('poll_post_comments'));
	
	my $rate = $S->session('ratingchoice');
	my $action;

	my $posting_comment = ($op eq 'comments' && $tool eq 'post') ? 1 : 0 ;
	
	my $comm_options;
	
	if ($dynamic || $dispmode eq 'dthreaded' || $dispmode eq 'dminimal') {
		# Add a button to collapse this comment, and expand/collapse
		# its subthread
		my $minus = $S->{UI}->{BLOCKS}->{dynamic_collapse_bottom_link} || '-';
		my $pplus = $S->{UI}->{BLOCKS}->{dynamic_expand_thread_link} || '++';
		my $mminus = $S->{UI}->{BLOCKS}->{dynamic_collapse_thread_link} || '--';
		$comm_options .= qq|
			<TT><A STYLE="text-decoration:none" HREF="javascript:void(toggle($comment->{cid},1))">$minus</A></TT> \|
			<TT><A STYLE="text-decoration:none" HREF="javascript:void(toggleList(replies[$comment->{cid}],0))">$mminus</A></TT>
			<TT><A STYLE="text-decoration:none" HREF="javascript:void(toggleList(replies[$comment->{cid}],1))">$pplus</A></TT> \||;
	}

	if ($comment->{pid} != 0) {
		my $opstring = ($op ne 'fzdisplay') ? 'comments' : 'fzdisplay/comment';
		
		$comm_options .= qq| <A CLASS="light" HREF="%%rootdir%%/$opstring/$comment->{sid}/$comment->{pid}#$comment->{pid}">Parent</A> |;
		
		if (($comment->{mode} ne 'Preview') && ($S->have_perm('comment_post')) && !$posting_comment && !$commentstatus && $sect_perm_post ) {
			$comm_options .= qq|\| <A CLASS="light" HREF="%%rootdir%%/comments/$comment->{sid}/$comment->{cid}/post#here">Reply to This</A> |;
		}

	} else {
		if (($comment->{mode} ne 'Preview') && $S->have_perm('comment_post') && !$posting_comment && !$commentstatus && $sect_perm_post ) {
			$comm_options .= qq| <A CLASS="light" HREF="%%rootdir%%/comments/$comment->{sid}/$comment->{cid}/post#here">Reply to This</A> |;
		}
	}
	
	if ((!$rate || $rate eq 'yes') && ($S->{UID} != $comment->{uid})) {
		my $curr_rating = $S->_get_current_rating($comment->{sid}, $comment->{cid}, $S->{UID});
		my $rate_form = $S->_rating_form($curr_rating, $comment->{cid});
		if ($rate_form) {
			if ($comm_options) {
				$comm_options .= qq|\||;
			}
			$comm_options .= qq|$rate_form|;
		}
	}
		
		
	my ($user_info, $edit_user);
	if ($comment->{uid} != -1) {
		my $nick = $S->urlify($S->get_nick_from_uid($comment->{uid}));
		$user_info = qq|(<A CLASS="light" HREF="%%rootdir%%/user/$nick">User Info</A>)|;
		if ($S->have_perm('edit_user')) {
			$edit_user = qq| [<A CLASS="light" HREF="%%rootdir%%/user/$nick/edit">Edit User</A>]|;
			$user_info .= $edit_user;
		}
	}

	# display the IP that the user posted the comment with
	if ($S->have_perm('view_comment_ip')
			&& $S->{UI}->{VARS}->{view_ip_log}
			&& $S->{UI}->{VARS}->{comment_ip_log} ){
		$user_info .= " Poster's IP: ";
		$user_info .= $comment->{commentip} || 'unknown';
	}
	
	my $new = '';
	# Check for highest index
	if ($S->{UI}->{VARS}->{show_new_comments}) {
		
		if ($S->{UI}->{VARS}->{use_static_pages} && $S->{GID} eq 'Anonymous') {
			#$new = '%%new_'.$comment->{cid}.'%%';
		} elsif ($S->{UID} >= 0) {
			my $highest = $S->story_highest_index($comment->{sid});
			if ($comment->{cid} > $highest) {
				$new = $S->{UI}->{BLOCKS}->{new_comment_marker};
			}
		}
	}

	if ($comm_options) {
		$action .= qq|[ $comm_options ]|;
	}
	
	if ($S->have_perm( 'comment_delete' ) && !$posting_comment ) {
		$action .= qq| (<A CLASS="light" HREF="%%rootdir%%/comments/$comment->{sid}/$comment->{cid}/delete">delete</A>)|;
	}
	
	if (($dispmode eq 'minimal' || $dispmode eq 'dminimal') && $pid == 0 && (!$cid || $cid != $comment->{cid}) && $comment->{mode} ne 'alone') {
		my $replyblock;
		if ($replies && $replies ne '&nbsp;') {
			$replyblock = qq|$replies|;
		}
		my $item_start_subst = $item_start;
		$item_start_subst =~ s/!cid!/$comment->{cid}/g;

		$this_comment = 
			$item_start_subst .
			$S->_get_comment_subject($comment->{sid}, $pid, $dispmode, $comment) .
			$item_end .
			$replyblock;
	
		return $this_comment;
	}
			
	$this_comment = $S->{UI}->{BLOCKS}->{comment};
	
	if ($comment->{pending}) {
		$this_comment = $S->{UI}->{BLOCKS}->{moderation_comment};
	}

	my $member;
	if ($user->{sub}->{active}) {
		$member = $S->{UI}->{BLOCKS}->{"mark_$user->{perm_group}"};
		
	}
	
	# See if we can help along the validation process...
	$comment->{comment} =~ s/^\s*<p>//gi;
	$comment->{comment} =~ s/^\s*<br>//gi;
	$comment->{comment} =~ s/<P>/<BR><BR>/gi;
	$comment->{comment} =~ s/<\/P>//gi;
	
	$this_comment =~ s/%%uid%%/$comment->{uid}/g;
	$this_comment =~ s/%%edit_user%%/$edit_user/g;
	$this_comment =~ s/%%name%%/$user->{nickname}/g;
	$this_comment =~ s/%%date%%/$comment->{f_date}/g;
	$this_comment =~ s/%%subject%%/$comment->{subject}/g;
	$this_comment =~ s/%%new%%/$new/g;
	$this_comment =~ s/%%member%%/$member/g;

	# check for sig behavior and act accordingly
	if ($user->{sig}) {
		$user->{sig} =~ s/<P>/<BR><BR>/gi;
 		$user->{sig} =~ s/<\/P>//gi;
		if ($comment->{sig_behavior} eq 'retroactive' || $comment->{sig_status} == 1) {
			#if normal sig, then proceed as usual
	 		$this_comment =~ s/%%sig%%/$user->{sig}/g;

		} elsif ($comment->{sig_behavior} eq 'sticky' || $comment->{sig_status} == 0) { 
			#if sticky sig and in preview mode, then place sig below comment
			$this_comment =~ s/%%sig%%/$comment->{sig}/g

		} else {
			#the user has a sig but doesn't want it shown, so get rid of %%sig%%'s
			$this_comment =~ s/%%sig%%//g;

		}
	} else {
		$this_comment =~ s/%%sig%%//g;
	}

	$this_comment =~ s/%%comment%%/$comment->{comment}/g;
	$this_comment =~ s/%%cid%%/$comment->{cid}/g;
	$this_comment =~ s/%%actions%%/$action/g;
	$this_comment =~ s/%%user_info%%/$user_info/g;
	$this_comment =~ s/%%sid%%/$comment->{sid}/g;
	$this_comment =~ s/%%score%%/$comment->{points}/g;
	$this_comment =~ s/%%num_ratings%%/$comment->{numrate}/g;
	
	if ($user->{fakeemail}) {
		$this_comment =~ s/%%email%%/(<A CLASS="light" HREF="mailto:$user->{fakeemail}">$user->{fakeemail}<\/A>)/g;
	} else {
		$this_comment =~ s/%%email%%//g;
	}
	if ($user->{homepage}) {
		$this_comment =~ s/%%url%%/<A CLASS="light" HREF="$user->{homepage}">$user->{homepage}<\/A>/g;
	} else {
		$this_comment =~ s/%%url%%//g;
	}

	# In dynamic modes, add the dynamic collapse link
	if (!$dynamic && ($dispmode eq 'dthreaded' || $dispmode eq 'dminimal')) {
		my $item_start_subst = $item_start;
		$item_start_subst =~ s/!cid!/$comment->{cid}/g;
		$this_comment = $item_start_subst.$this_comment;
		# We want the replies to be independent of the post itself
		$replies = $item_end.$replies;
	}

	if ($comment->{mode} ne 'alone') {
		$this_comment =~ s/%%replies%%/$replies/g;
	}

	return $this_comment;
}

sub comment_choices_box {
	my $S = shift;
	my $sid = shift;
	my $pid = $S->{CGI}->param('pid');
	my $cid = $S->{CGI}->param('cid');
	
	my $commentmode_select = $S->_comment_mode_select();
	my $comment_order_select = $S->_comment_order_select();
	my $comment_rating_select = $S->_comment_rating_select();
	my $rating_choice = $S->_comment_rating_choice();
	my $comment_type_select = $S->_comment_type_select();
	
	my $form_op = 'op';
	my $form_op_value = 'displaystory';
	my $id = 'sid';
	
	if ($S->_does_poll_exist($sid)) {
		$form_op       = 'op';
		$form_op_value = 'view_poll';
		$id 		   = 'qid';
	}
		
	my $comment_sort = qq|
			<FORM NAME="commentmode" ACTION="%%rootdir%%/" METHOD="post">
		<TABLE BORDER=0 CELLPADDING=0 CELLSPACING=0 WIDTH="100%" BGCOLOR="%%box_content_bg%%">
			<INPUT TYPE="hidden" NAME="$form_op" VALUE="$form_op_value">
			<INPUT TYPE="hidden" NAME="$id" VALUE="$sid">
		
			<TR>
				<TD VALIGN="middle">
					%%norm_font%%
						View:
					%%norm_font_end%%
				</TD>
				<TD VALIGN="top">
					%%norm_font%%<SMALL>
						$comment_type_select
					</SMALL>%%norm_font_end%%
				</TD>
			</TR>
		
		<TR>
			<TD VALIGN="middle">
				%%norm_font%%
					Display:
				%%norm_font_end%%
			</TD>
			<TD>
			%%norm_font%%<SMALL>
				$commentmode_select
			</SMALL>%%norm_font_end%%
			</TD>
		</TR>
		
		<TR>
			<TD VALIGN="middle">
				%%norm_font%%
					Sort:
				%%norm_font_end%%
			</TD>
			<TD VALIGN="top">
				%%norm_font%%<SMALL>
					$comment_rating_select
				</SMALL>%%norm_font_end%%
			</TD>
		</TR>
		<TR>
			<TD>
				%%norm_font%%&nbsp;%%norm_font_end%%
			</TD>
			<TD>
				%%norm_font%%<SMALL>
					$comment_order_select
				</SMALL>%%norm_font_end%%
			</TD>
		</TR>
	|;
		
			
	if ($S->have_perm( 'comment_rate' )) {
		$comment_sort .= qq|
		<TR>
		<TD VALIGN="middle">%%norm_font%%
		Rate?
		%%norm_font_end%%
		</TD>
		<TD VALIGN="top">%%norm_font%%
		<SMALL>$rating_choice</SMALL>
		%%norm_font_end%%
		</TD>
		</TR>|;
	}
	
	$comment_sort .= qq|
	<TR><TD COLSPAN=2 ALIGN="right">%%norm_font%%<INPUT TYPE="submit" NAME="setcomments" VALUE="Set">%%norm_font_end%%</TD></TR>
	</TABLE>
	</FORM>|;

	my $box = $S->make_box("Comment Controls", $comment_sort);
	return $box;
}

sub comment_controls {
	my $S = shift;
	my $sid = shift;
	my $pid = $S->{CGI}->param('pid');
	my $cid = $S->{CGI}->param('cid');

	# don't even bother if they don't have permission to view the story,
	# BUT! let them see this if they have post permissions.  never know how someone
	# would set this up, but if they want to allow posting but not reading, eh.
	my $section = $S->_get_story_section($sid);
	return '' unless( $S->have_section_perm('norm_read_comments', $section )	|| 
						( $S->_does_poll_exist($sid)	&& 
						( $S->have_perm('poll_read_comments') || $S->have_perm('poll_post_comments') )) );
	
	my $s_info = $S->{UI}->{BLOCKS}->{story_info};
	
	my $warn = $S->{UI}->{BLOCKS}->{commentswarning};
	my $commentstatus = $S->_check_commentstatus($sid);

	my $story_info_txt = '';
	unless ( $S->_does_poll_exist($sid) ) {
		my ($rv, $sth) = $S->db_select({
			WHAT => 'title',
			FROM => 'stories',
			WHERE => qq|sid = "$sid"|
			});

		(my $story_info = $sth->fetchrow_hashref);
		$sth->finish;

		$story_info_txt = qq|<A CLASS="light" HREF="%%rootdir%%/story/$sid">$story_info->{title}</A> |;

		# don't display comment stats if comments are disabled
		unless (($commentstatus == -1) || ($S->have_section_perm('hide_read_comments', $section))) {
			my ($topical,  $editorial, $review) = $S->_comment_breakdown($sid);
			$story_info->{commentcount} = ($topical + $editorial);
			my $r_inf;
			if ($S->{UI}->{VARS}->{use_mojo}) {
				#warn "Review is $review\n";
				$r_inf = ", $review pending";
			}

			my $plural = ($story_info->{commentcount} == 1) ? '' : 's';
			$story_info_txt .= qq|\| <B>$story_info->{commentcount}</B> comment$plural ($topical topical, $editorial editorial$r_inf) |;
		}

	} else {
		my $comment_num = $S->poll_comment_num($sid);
		my $poll_q = $S->get_poll_hash($sid);

		# put a link to the poll in there, since if they are here they can see it, and know what its attached to
		$story_info_txt = qq|<A CLASS="light" HREF="%%rootdir%%/poll/$sid">$poll_q->{question}</A>|;

		# now if they can read the comments too, put the comment count
		if( $S->have_perm('poll_read_comments') ) {
			$story_info_txt .= qq| \| <B>$comment_num</B> comments |;
		}

	}

	# only give Post Comment link if commentstatus is zero (Comments Enabled)
	unless ($commentstatus) {
		$story_info_txt .= qq|\| <A HREF="%%rootdir%%/comments/$sid/0/post#here"><B>Post A Comment</B></A> | 
			if ($S->have_perm('comment_post') && $S->have_section_perm('norm_post_comments',$section) && !$S->_does_poll_exist($sid));

		$story_info_txt .= qq|\| <A HREF="%%rootdir%%/comments/poll/$sid/0/post#here"><B>Post A Comment</B></A> | 
			if ($S->have_perm('comment_post') && $S->_does_poll_exist($sid) && $S->have_perm('poll_post_comments'));
	}
	if ($S->_does_poll_exist($sid) && $S->have_perm('edit_polls')) {
		$story_info_txt .= qq|\| <A CLASS="light" HREF="%%rootdir%%/admin/editpoll/$sid">Edit Poll</A>|;
	} elsif (!$S->_does_poll_exist($sid) && $S->have_perm('story_list')) {
		$story_info_txt .= qq|\| <A CLASS="light" HREF="%%rootdir%%/admin/story/$sid">Edit Story</A>|;
	}

	$s_info =~ s/%%story_info%%/$story_info_txt/;
	
	return $s_info;
}


sub _comment_mode_select {
	my $S = shift;
	my $mode = $S->session('commentmode') || 'threaded';
	
	my ($selected_n, $selected_f, $selected_m, $selected_dt, $selected_dm);
	if ($mode eq 'nested') {
		$selected_n = ' SELECTED';
	} elsif ($mode eq 'flat') {
		$selected_f = ' SELECTED';
	} elsif ($mode eq 'minimal') {
		$selected_m = ' SELECTED';
	} elsif ($S->{UI}->{VARS}->{allow_dynamic_comment_mode}) {
		if ($mode eq 'dthreaded') {
			$selected_dt = ' SELECTED';
		} elsif ($mode eq 'dminimal') {
			$selected_dm = ' SELECTED';
		}
	}
	
	my $select = qq|<SELECT NAME="commentmode" SIZE=1>
		<OPTION VALUE="threaded">Threaded
		<OPTION VALUE="minimal"$selected_m>Minimal
		<OPTION VALUE="nested"$selected_n>Nested
		<OPTION VALUE="flat"$selected_f>Flat|;
	if ($S->{UI}->{VARS}->{allow_dynamic_comment_mode}) {
		$select .= qq|<OPTION VALUE="dthreaded"$selected_dt>Dynamic Threaded|;
		$select .= qq|<OPTION VALUE="dminimal"$selected_dm>Dynamic Minimal|;
	}
	$select .= qq|</SELECT>|;
	
	return $select;
}

sub _comment_type_select {
	my $S = shift;
	my $type = $S->session('commenttype');
	
	my ($editorial_s, $all_s, $none_s, $topical_s);
	
	if ($type eq 'editorial') {
		$editorial_s = ' SELECTED';
	} elsif ($type eq 'all') {
		$all_s = ' SELECTED';
	} elsif ($type eq 'none') {
		$none_s = ' SELECTED';
	} elsif ($type eq 'topical') {
		$topical_s = ' SELECTED';
	}
	
	
	my $select = qq|<SELECT NAME="commenttype" SIZE=1>
		<OPTION VALUE="mixed">Mixed (default)
		<OPTION VALUE="topical"$topical_s>Topical Only
		<OPTION VALUE="editorial"$editorial_s>Editorial Only
		<OPTION VALUE="all"$all_s>All Comments
		<OPTION VALUE="none"$none_s>No Comments</SELECT>|;
	
	return $select;	
}

sub _comment_order_select {
	my $S = shift;
	my $order = $S->session('commentorder') || 'newest';
	
	my ($selected_o);
	if ($order eq 'oldest') {
		$selected_o = ' SELECTED';
	} 
	
	my $select = qq|<SELECT NAME="commentorder" SIZE=1>
		<OPTION VALUE="newest">Newest First
		<OPTION VALUE="oldest"$selected_o>Oldest First
		</SELECT>|;
	
	return $select;
} 



sub _set_comment_mode {
	my $S = shift;
	my $count = shift;
	return unless $count;
	
	# Dynamic subthreads should always be dynamic themselves
	if($S->{UI}->{VARS}->{allow_dynamic_comment_mode} && ($S->{CGI}->param('op') eq 'dynamic')) {
		return 'dynamic';
	}

	my $thismode = $S->cgi->param('commentmode');
	if ($thismode) {
		$S->session('commentmode', $thismode);
		return;
	}
	
	my @modeprefs = (
		'comment_flat_to',
		'comment_minimal_to',
		'comment_threaded_to',
		'comment_nested_to',
		'comment_dthreaded_to',
		'comment_dminimal_to');
	
	my $curr_diff;
	my $curr_mode;
	my $spill;
	foreach my $mode_p (@modeprefs) {
		if ($S->{prefs}->{$mode_p} eq '+') {
			$spill = $mode_p;
			$spill =~ s/^comment_//;
			$spill =~ s/_to$//;
			next;
		}
		my $diff = $S->{prefs}->{$mode_p} - $count;
		next unless ($diff >= 0);
		if ($diff < $curr_diff || !defined($curr_diff)) {
			$curr_diff = $diff;
			$curr_mode = $mode_p;
			$curr_mode =~ s/^comment_//;
			$curr_mode =~ s/_to$//;
		}
	}
	
	my $mode = $curr_mode || $spill;
	#my $mode = $S->{CGI}->param('commentmode');
	#return unless $mode;
	
	$S->session('commentmode', $mode);
	return;
}

sub _set_comment_type {
	my $S = shift;
	my $type = $S->{CGI}->param('commenttype') || $S->{prefs}->{comment_commenttype};
	#return unless $type;
	
	$S->session('commenttype', $type);
	return;
}

sub _set_comment_order {
	my $S = shift;
	my $mode = $S->{CGI}->param('commentorder') || $S->{prefs}->{comment_commentorder};
	return unless $mode;
	
	$S->session('commentorder', $mode);
	return;
}

sub _set_comment_rating_thresh {
	my $S = shift;
	my $mode = $S->{CGI}->param('commentrating') || $S->{prefs}->{comment_commentrating};
	return unless $mode;
	
	$S->session('commentrating', $mode);
	return;
}

sub _set_comment_rating_choice {
	my $S = shift;
	my $mode = $S->{CGI}->param('ratingchoice') || shift || $S->{prefs}->{comment_ratingchoice} || 'yes';
	unless ($S->have_perm('comment_rate')) {
		$mode = 'no';
	}
	return unless $mode;
	#warn "Mode is $mode\n";
	$S->session('ratingchoice', $mode);
	return;
}


1;
