/*
 * scamper_addr2mac.h: an implementation of two neighbour discovery methods
 *
 *     Matthew Luckie
 *
 *
 * $Id: scamper_addr2mac.h,v 1.3 2007/05/08 01:46:02 mjl Exp $
 *
 */

#ifndef __SCAMPER_ADDR2MAC_H
#define __SCAMPER_ADDR2MAC_H

void scamper_addr2mac_isat_v4(int ifindex, uint8_t *pkt, size_t len);
void scamper_addr2mac_isat_v6(int ifindex, uint8_t *pkt, size_t len);
int scamper_addr2mac_whohas(const int ifindex, const scamper_addr_t *src,
			    scamper_addr_t *dst, uint8_t *mac);
int scamper_addr2mac_init(void);
void scamper_addr2mac_cleanup(void);

#endif /* __SCAMPER_ADDR2MAC_H */
