#!/usr/bin/awk -f

function defomaencoding(xencoding) {
    
    if(toupper(xencoding)=="MICROSOFT-CP1251") {
	return "CP1251";
    } else {
	return toupper(xencoding);
    }
}

BEGIN {
    fontdirectory="/usr/share/fonts/type1/scalable-cyrfonts";
    print "category type1";
}

{
    file=$1;
    font=$2;
    family=$3;
    full=$4;
    weight=$5;
    foundry=$6;
    if (weight=="Book"||weight=="Normal"||weight=="Roman") {
	weight="Medium";
    }
    if (weight=="Demi") {
	weight="Demibold";
    }
    if (family=="Courier") {
	generalfamily="Typewriter";
    } else if (family=="Helvetica"||family=="Avant_Garde_Gothic") {
	generalfamily="SansSerif";
    } else {
	generalfamily="Roman";
    }
    if (family=="Courier") {
	width="Fixed";
    } else {
	width="Variable";
    }
    if (generalfamily=="SansSerif"||family=="Teams") {
	shape="NoSerif";
    } else {
	shape="Serif";
    }
    if (full ~ /Italic/) {
	shape=shape " Italic";
    } else if (full ~ /Oblique/) {
	shape=shape " Oblique";
    } else {
	shape=shape " Upright";
    }
    if (full ~ /Condensed/) {
	shape=shape " Condensed";
    }
    numxencodings=split($0,xencoding)-6;
    if (shape ~ /Upright/) {
	xslant="r";
    } else if (shape ~ /Italic/) {
	xslant="i";
    } else if (shape ~ /Oblique/) {
	xslant="o";
    } else {
	xslant="error";
    }
    if (shape ~ /Condensed/) {
	xwidth="condensed";
    } else {
	xwidth="normal";
    }
    if (width=="Fixed") {
	xspacing="c";
    } else {
	xspacing="p";
    }
    if (family=="Avant_Garde_Gothic") {
	texname="fag";
    } else if (family=="Bookman") {
	texname="fbk";
    } else if (family=="New_Century_Schoolbook") {
	texname="fnc";
    } else if (family=="Helvetica") {
	texname="fhv";
    } else if (family=="Times") {
	texname="ftm";
    } else if (family=="Courier") {
	texname="fcr";
    } else if (family=="Palatino") {
	texname="fpt";
    } else if (family="Teams") {
	texname="fta";
    } else {
	texname="error";
    }
    printf "begin %s/%s\n", fontdirectory, file ".pfb";
    printf "  FaceNum = %s\n", numxencodings;
    printf "  Inherit = Family GeneralFamily Weight Width Shape Priority\n";
    printf "  FontName = %s\n", font;
    printf "  Charset = %s\n", defomaencoding(xencoding[6+1]);
    printf "  Family = %s\n", family;
    printf "  GeneralFamily = %s\n", generalfamily;
    printf "  Weight = %s\n", weight;
    printf "  Width = %s\n", width;
    printf "  Shape = %s\n", shape;
    printf "  Priority = 20\n";
    printf "  X-FontName = -%s-%s-%s-%s-%s--0-0-0-0-%s-0-%s\n", foundry, family, weight, xslant, xwidth, xspacing, xencoding[6+1];
    for(i=2; i<=numxencodings; i++) {
	printf "\n";
	printf "  Charset%s = %s\n", i-1, defomaencoding(xencoding[6+i]);
	printf "  X-FontName%s = -%s-%s-%s-%s-%s--0-0-0-0-%s-0-%s\n", i-1, foundry, family, weight, xslant, xwidth, xspacing, xencoding[6+i];
    }
    printf "end\n";
}
