;;; -*- Lisp -*-

;;; This isn't really lisp, but it's definitely a source file.

;;; first, the headers necessary to find definitions of everything
(#||#
 "sys/types.h"
 "sys/stat.h"
 #-win32 "sys/socket.h"
 #-win32 "sys/un.h"
 #-win32 "netinet/in.h"
 #-win32 "netinet/in_systm.h"
 #-win32 "netinet/ip.h"
 #-win32 "net/if.h"
 #-win32 "netinet/tcp.h"
 #-win32 "sys/mman.h"
 #-win32 "sys/wait.h"
 "fcntl.h"
 #-win32 "netdb.h"
 "errno.h"
 "dirent.h" "signal.h"
 #-win32 "pwd.h"
 "unistd.h"
 #-win32 "termios.h")

;;; then the stuff we're looking for
((:integer af-inet "AF_INET" "IP Protocol family" t)

 ;; KLUDGE: These types simply do not seem to exist on Windows,
 ;; but we'll provide these anyways -- at least in a way that should
 ;; match with stat.
 (:type uid-t   #-win32 "uid_t"   #+win32 "short")
 (:type gid-t   #-win32 "gid_t"   #+win32 "short")
 (:type nlink-t #-win32 "nlink_t" #+win32 "short")

 (:type pid-t "pid_t")
 (:type ino-t "ino_t")

 (:type time-t "time_t")
 (:type dev-t "dev_t")

 ;; signals
 (:integer SIGHUP "SIGHUP" #+sb-doc "terminal line hangup." t)
 (:integer SIGINT "SIGINT" #+sb-doc "interrupt program." t)
 (:integer SIGQUIT "SIGQUIT" #+sb-doc "quit program." t)
 (:integer SIGILL "SIGILL" #+sb-doc "illegal instruction." t)
 (:integer SIGTRAP "SIGTRAP" #+sb-doc "trace trap." t)
 (:integer SIGABRT "SIGABRT" #+sb-doc "abort program (formerly SIGIOT)." t)
 (:integer SIGEMT "SIGEMT" #+sb-doc "emulate instruction executed." t)
 (:integer SIGFPE "SIGFPE" #+sb-doc "floating-point exception." t)
 (:integer SIGKILL "SIGKILL" #+sb-doc "kill program." t)
 (:integer SIGBUS "SIGBUS" #+sb-doc "bus error." t)
 (:integer SIGSEGV "SIGSEGV" #+sb-doc "segmentation violation." t)
 (:integer SIGSYS "SIGSYS" #+sb-doc "non-existent system call invoked." t)
 (:integer SIGPIPE "SIGPIPE" #+sb-doc "write on a pipe with no reader." t)
 (:integer SIGALRM "SIGALRM" #+sb-doc "real-time timer expired." t)
 (:integer SIGTERM "SIGTERM" #+sb-doc "software termination signal." t)
 (:integer SIGURG "SIGURG" #+sb-doc "urgent condition present on socket." t)
 (:integer SIGSTOP "SIGSTOP" #+sb-doc "stop (cannot be caught or ignored)." t)
 (:integer SIGTSTP "SIGTSTP" #+sb-doc "stop signal generated from keyboard." t)
 (:integer SIGCONT "SIGCONT" #+sb-doc "continue after stop." t)
 (:integer SIGCHLD "SIGCHLD" #+sb-doc "child status has changed." t)
 (:integer SIGTTIN "SIGTTIN"
           #+sb-doc "background read attempted from control terminal." t)
 (:integer SIGTTOU "SIGTTOU"
           #+sb-doc "background write attempted to control terminal." t)
 (:integer SIGIO "SIGIO"
           #+sb-doc "I/O is possible on a descriptor (see fcntl(2))." t)
 (:integer SIGXCPU "SIGXCPU"
           #+sb-doc "cpu time limit exceeded (see setrlimit(2))." t)
 (:integer SIGXFSZ "SIGXFSZ"
           #+sb-doc "file size limit exceeded (see setrlimit(2))." t)
 (:integer SIGVTALRM "SIGVTALRM"
           #+sb-doc "virtual time alarm (see setitimer(2))." t)
 (:integer SIGPROF "SIGPROF"
           #+sb-doc "profiling timer alarm (see setitimer(2))." t)
 (:integer SIGWINCH "SIGWINCH" #+sb-doc "Window size change." t)
 (:integer SIGINFO "SIGINFO" #+sb-doc "status request from keyboard." t)
 (:integer SIGUSR1 "SIGUSR1" #+sb-doc "User defined signal 1." t)
 (:integer SIGUSR2 "SIGUSR2" #+sb-doc "User defined signal 2." t)
 (:integer SIGRTMIN "SIGRTMIN" #+sb-doc "Smallest real-time signal number." t)
 (:integer SIGRTMAX "SIGRTMAX" #+sb-doc "Largest real-time signal number." t)

 ;; error numbers
 (:integer eperm "EPERM" nil t)
 (:integer enoent "ENOENT" nil t)
 (:integer esrch "ESRCH" nil t)
 (:integer eintr "EINTR" nil t)
 (:integer eio "EIO" nil t)
 (:integer enxio "ENXIO" nil t)
 (:integer e2big "E2BIG" nil t)
 (:integer enoexec "ENOEXEC" nil t)
 (:integer ebadf "EBADF" nil t)
 (:integer echild "ECHILD" nil t)
 (:integer eagain "EAGAIN" nil t)
 (:integer enomem "ENOMEM" nil t)
 (:integer eacces "EACCES" nil t)
 (:integer efault "EFAULT" nil t)
 (:integer enotblk "ENOTBLK" nil t)
 (:integer ebusy "EBUSY" nil t)
 (:integer eexist "EEXIST" nil t)
 (:integer exdev "EXDEV" nil t)
 (:integer enodev "ENODEV" nil t)
 (:integer enotdir "ENOTDIR" nil t)
 (:integer eisdir "EISDIR" nil t)
 (:integer einval "EINVAL" nil t)
 (:integer enfile "ENFILE" nil t)
 (:integer emfile "EMFILE" nil t)
 (:integer enotty "ENOTTY" nil t)
 (:integer etxtbsy "ETXTBSY" nil t)
 (:integer efbig "EFBIG" nil t)
 (:integer enospc "ENOSPC" nil t)
 (:integer espipe "ESPIPE" nil t)
 (:integer erofs "EROFS" nil t)
 (:integer emlink "EMLINK" nil t)
 (:integer epipe "EPIPE" nil t)
 (:integer edom "EDOM" nil t)
 (:integer erange "ERANGE" nil t)
 (:integer edeadlk "EDEADLK" nil t)
 (:integer enametoolong "ENAMETOOLONG" nil t)
 (:integer enolck "ENOLCK" nil t)
 (:integer enosys "ENOSYS" nil t)
 (:integer enotempty "ENOTEMPTY" nil t)
 (:integer eloop "ELOOP" nil t)
 (:integer ewouldblock "EWOULDBLOCK" nil t)
 (:integer enomsg "ENOMSG" nil t)
 (:integer eidrm "EIDRM" nil t)
 (:integer echrng "ECHRNG" nil t)
 (:integer el2nsync "EL2NSYNC" nil t)
 (:integer el3hlt "EL3HLT" nil t)
 (:integer el3rst "EL3RST" nil t)
 (:integer elnrng "ELNRNG" nil t)
 (:integer eunatch "EUNATCH" nil t)
 (:integer enocsi "ENOCSI" nil t)
 (:integer el2hlt "EL2HLT" nil t)
 (:integer ebade "EBADE" nil t)
 (:integer ebadr "EBADR" nil t)
 (:integer exfull "EXFULL" nil t)
 (:integer enoano "ENOANO" nil t)
 (:integer ebadrqc "EBADRQC" nil t)
 (:integer ebadslt "EBADSLT" nil t)
 (:integer edeadlock "EDEADLOCK" nil t)
 (:integer ebfont "EBFONT" nil t)
 (:integer enostr "ENOSTR" nil t)
 (:integer enodata "ENODATA" nil t)
 (:integer etime "ETIME" nil t)
 (:integer enosr "ENOSR" nil t)
 (:integer enonet "ENONET" nil t)
 (:integer enopkg "ENOPKG" nil t)
 (:integer eremote "EREMOTE" nil t)
 (:integer enolink "ENOLINK" nil t)
 (:integer eadv "EADV" nil t)
 (:integer esrmnt "ESRMNT" nil t)
 (:integer ecomm "ECOMM" nil t)
 (:integer eproto "EPROTO" nil t)
 (:integer emultihop "EMULTIHOP" nil t)
 (:integer edotdot "EDOTDOT" nil t)
 (:integer ebadmsg "EBADMSG" nil t)
 (:integer eoverflow "EOVERFLOW" nil t)
 (:integer enotuniq "ENOTUNIQ" nil t)
 (:integer ebadfd "EBADFD" nil t)
 (:integer eremchg "EREMCHG" nil t)
 (:integer elibacc "ELIBACC" nil t)
 (:integer elibbad "ELIBBAD" nil t)
 (:integer elibscn "ELIBSCN" nil t)
 (:integer elibmax "ELIBMAX" nil t)
 (:integer elibexec "ELIBEXEC" nil t)
 (:integer eilseq "EILSEQ" nil t)
 (:integer erestart "ERESTART" nil t)
 (:integer estrpipe "ESTRPIPE" nil t)
 (:integer eusers "EUSERS" nil t)
 (:integer enotsock "ENOTSOCK" nil t)
 (:integer edestaddrreq "EDESTADDRREQ" nil t)
 (:integer emsgsize "EMSGSIZE" nil t)
 (:integer eprototype "EPROTOTYPE" nil t)
 (:integer enoprotoopt "ENOPROTOOPT" nil t)
 (:integer eprotonosupport "EPROTONOSUPPORT" nil t)
 (:integer esocktnosupport "ESOCKTNOSUPPORT" nil t)
 (:integer eopnotsupp "EOPNOTSUPP" nil t)
 (:integer epfnosupport "EPFNOSUPPORT" nil t)
 (:integer eafnosupport "EAFNOSUPPORT" nil t)
 (:integer eaddrinuse "EADDRINUSE" nil t)
 (:integer eaddrnotavail "EADDRNOTAVAIL" nil t)
 (:integer enetdown "ENETDOWN" nil t)
 (:integer enetunreach "ENETUNREACH" nil t)
 (:integer enetreset "ENETRESET" nil t)
 (:integer econnaborted "ECONNABORTED" nil t)
 (:integer econnreset "ECONNRESET" nil t)
 (:integer enobufs "ENOBUFS" nil t)
 (:integer eisconn "EISCONN" nil t)
 (:integer enotconn "ENOTCONN" nil t)
 (:integer eshutdown "ESHUTDOWN" nil t)
 (:integer etoomanyrefs "ETOOMANYREFS" nil t)
 (:integer etimedout "ETIMEDOUT" nil t)
 (:integer econnrefused "ECONNREFUSED" nil t)
 (:integer ehostdown "EHOSTDOWN" nil t)
 (:integer ehostunreach "EHOSTUNREACH" nil t)
 (:integer ealready "EALREADY" nil t)
 (:integer einprogress "EINPROGRESS" nil t)
 (:integer estale "ESTALE" nil t)
 (:integer euclean "EUCLEAN" nil t)
 (:integer enotnam "ENOTNAM" nil t)
 (:integer enavail "ENAVAIL" nil t)
 (:integer eremoteio "EREMOTEIO" nil t)
 (:integer edquot "EDQUOT" nil t)
 (:integer enomedium "ENOMEDIUM" nil t)
 (:integer emediumtype "EMEDIUMTYPE" nil t)

 ;; wait
 (:integer wnohang "WNOHANG")
 (:integer wuntraced "WUNTRACED")

 ;; mode_t
 (:type mode-t "mode_t")
 (:integer s-isuid "S_ISUID" nil t)
 (:integer s-isgid "S_ISGID" nil t)
 (:integer s-isvtx "S_ISVTX" nil t)
 (:integer s-irusr "S_IRUSR" nil t)
 (:integer s-iwusr "S_IWUSR" nil t)
 (:integer s-ixusr "S_IXUSR" nil t)
 (:integer s-iread "S_IRUSR" nil t)
 (:integer s-iwrite "S_IWUSR" nil t)
 (:integer s-iexec "S_IXUSR" nil t)
 (:integer s-irgrp "S_IRGRP" nil t)
 (:integer s-iwgrp "S_IWGRP" nil t)
 (:integer s-ixgrp "S_IXGRP" nil t)
 (:integer s-iroth "S_IROTH" nil t)
 (:integer s-iwoth "S_IWOTH" nil t)
 (:integer s-ixoth "S_IXOTH" nil t)

 ;; access()
 (:integer r-ok "R_OK" nil t)
 (:integer w-ok "W_OK" nil t)
 (:integer x-ok "X_OK" nil t)
 (:integer f-ok "F_OK" nil t)

 ;; mmap()
 (:type off-t "off_t")
 (:integer prot-none "PROT_NONE" #+sb-doc "mmap: no protection" t)
 (:integer prot-read "PROT_READ" #+sb-doc "mmap: read protection" t)
 (:integer prot-write "PROT_WRITE" #+sb-doc "mmap: write protection" t)
 (:integer prot-exec "PROT_EXEC" #+sb-doc "mmap: execute protection" t)
 (:integer map-shared "MAP_SHARED" #+sb-doc "mmap: shared memory" t)
 (:integer map-private "MAP_PRIVATE" #+sb-doc "mmap: private mapping" t)
 (:integer map-fixed "MAP_FIXED" #+sb-doc "mmap: map at given location" t)

 ;; msync()
 (:integer ms-async "MS_ASYNC" #+sb-doc "msync: return immediately" t)
 (:integer ms-sync "MS_SYNC" #+sb-doc "msync: perform synchronous writes" t)
 (:integer ms-invalidate "MS_INVALIDATE"
           #+sb-doc "msync: invalidate all cached data" t)

 ;; opendir()
 (:structure dirent
             ("struct dirent"
              (:c-string name "char *" "d_name"
                         :distrust-length #+sunos t #-sunos nil)) t)

 ;; password database
 #-win32
 (:structure alien-passwd
             ("struct passwd"
              (c-string-pointer name "char *" "pw_name")
              (c-string-pointer passwd "char *" "pw_passwd")
              (uid-t uid "uid_t" "pw_uid")
              (gid-t gid "gid_t" "pw_gid")
              ;; 'change', 'class', and 'expire' are not supported on Linux
              #+nil
              (time-t change "time_t" "pw_change")
              #+nil
              (c-string-pointer class "char *" "pw_class")
              (c-string-pointer gecos "char *" "pw_gecos")
              (c-string-pointer dir "char *" "pw_dir")
              (c-string-pointer shell "char *" "pw_shell")
              #+nil
              (time-t expire "time_t" "pw_expire")
              ;; OS X manpages say this exists.  they lie!
              #+nil
              (:integer fields "int" "pw_fields")))

 (:structure alien-stat
             ("struct stat"
              (mode-t mode "mode_t" "st_mode")
              (ino-t ino "ino_t" "st_ino")
              ;; Linux/MIPS uses unsigned long instead of dev_t here.
              #-mips
              (dev-t dev "dev_t" "st_dev")
              #+mips
              ((unsigned 32) dev "dev_t" "st_dev")
              (nlink-t nlink "nlink_t" "st_nlink")
              (uid-t uid "uid_t" "st_uid")
              (gid-t gid "gid_t" "st_gid")
              (off-t size "off_t" "st_size")
              (time-t atime "time_t" "st_atime")
              (time-t mtime "time_t" "st_mtime")
              (time-t ctime "time_t" "st_ctime")))

 ;; open()
 (:integer o-rdonly "O_RDONLY" nil t)
 (:integer o-wronly "O_WRONLY" nil t)
 (:integer o-rdwr "O_RDWR" nil t)
 (:integer o-creat "O_CREAT" nil t)
 (:integer o-excl "O_EXCL" nil t)
 (:integer o-noctty "O_NOCTTY" nil t)
 (:integer o-trunc "O_TRUNC" nil t)
 (:integer o-append "O_APPEND" nil t)
 (:integer o-nonblock "O_NONBLOCK" nil t)
 (:integer o-ndelay "O_NDELAY" nil t)
 (:integer o-sync "O_SYNC" nil t)
 (:integer o-nofollow "O_NOFOLLOW" nil t)
 (:integer o-directory "O_DIRECTORY" nil t)
 (:integer o-direct "O_DIRECT" nil t)
 (:integer o-async "O_ASYNC" nil t)
 (:integer o-largefile "O_LARGEFILE" nil t)     ; hmm...
 (:integer o-dsync "O_DSYNC" nil t)
 (:integer o-rsync "O_RSYNC" nil t)

 ;; lseek()
 (:integer seek-set "SEEK_SET" nil t)
 (:integer seek-cur "SEEK_CUR" nil t)
 (:integer seek-end "SEEK_END" nil t)

 ;; fcntl()
 (:integer f-dupfd "F_DUPFD" nil t)
 (:integer f-getfd "F_GETFD" nil t)
 (:integer f-setfd "F_SETFD" nil t)
 (:integer f-getfl "F_GETFL" nil t)
 (:integer f-setfl "F_SETFL" nil t)
 (:integer f-getlk "F_GETLK" nil t)
 (:integer f-setlk "F_SETLK" nil t)
 (:integer f-setlkw "F_SETLKW" nil t)
 (:integer f-getown "F_GETOWN" nil t)
 (:integer f-setown "F_SETOWN" nil t)

 ;; tcgetattr(), tcsetattr()
 #-win32
 (:type cc-t "cc_t")
 #-win32
 (:type speed-t "speed_t" nil t)
 #-win32
 (:type tcflag-t "tcflag_t" nil t)
 (:integer nccs "NCCS" nil t)
 #-win32
 (:structure alien-termios
             ("struct termios"
              (tcflag-t iflag "tcflag_t" "c_iflag")
              (tcflag-t oflag "tcflag_t" "c_oflag")
              (tcflag-t cflag "tcflag_t" "c_cflag")
              (tcflag-t lflag "tcflag_t" "c_lflag")
              ((array cc-t) cc "cc_t" "c_cc")))

 (:integer veof "VEOF" nil t)
 (:integer veol "VEOL" nil t)
 (:integer verase "VERASE" nil t)
 (:integer vintr "VINTR" nil t)
 (:integer vkill "VKILL" nil t)
 (:integer vmin "VMIN" nil t)
 (:integer vquit "VQUIT" nil t)
 (:integer vstart "VSTART" nil t)
 (:integer vstop "VSTOP" nil t)
 (:integer vsusp "VSUSP" nil t)
 (:integer vtime "VTIME" nil t)

 (:integer brkint "BRKINT" nil t)
 (:integer icrnl "ICRNL" nil t)
 (:integer ignbrk "IGNBRK" nil t)
 (:integer igncr "IGNCR" nil t)
 (:integer ignpar "IGNPAR" nil t)
 (:integer inlcr "INLCR" nil t)
 (:integer inpck "INPCK" nil t)
 (:integer istrip "ISTRIP" nil t)
 #+xsi                               ; FIXME: an extension, apparently
 (:integer ixany "IXANY" nil t)
 (:integer ixoff "IXOFF" nil t)
 (:integer ixon "IXON" nil t)
 (:integer parmrk "PARMRK" nil t)

 (:integer opost "OPOST" nil t)
 #+xsi
 (:integer onlcr "ONLCR" nil t)
 (:integer ocrnl "OCRNL" nil t)
 (:integer onlret "ONLRET" nil t)
 (:integer ofill "OFILL" nil t)
 (:integer nldly "NLDLY" nil t)
 (:integer nl0 "NL0" nil t)
 (:integer nl1 "NL1" nil t)
 (:integer crdly "CRDLY" nil t)
 (:integer cr0 "CR0" nil t)
 (:integer cr1 "CR1" nil t)
 (:integer cr2 "CR2" nil t)
 (:integer cr3 "CR3" nil t)
 (:integer tabdly "TABDLY" nil t)
 (:integer tab0 "TAB0" nil t)
 (:integer tab1 "TAB1" nil t)
 (:integer tab2 "TAB2" nil t)
 (:integer tab3 "TAB3" nil t)
 (:integer bsdly "BSDLY" nil t)
 (:integer bs0 "BS0" nil t)
 (:integer bs1 "BS1" nil t)
 (:integer vtdly "VTDLY" nil t)
 (:integer vt0 "VT0" nil t)
 (:integer vt1 "VT1" nil t)
 (:integer ffdly "FFDLY" nil t)
 (:integer ff0 "FF0" nil t)
 (:integer ff1 "FF1" nil t)

 (:integer b0 "B0" nil t)
 (:integer b50 "B50" nil t)
 (:integer b75 "B75" nil t)
 (:integer b110 "B110" nil t)
 (:integer b134 "B134" nil t)
 (:integer b150 "B150" nil t)
 (:integer b200 "B200" nil t)
 (:integer b300 "B300" nil t)
 (:integer b600 "B600" nil t)
 (:integer b1200 "B1200" nil t)
 (:integer b1800 "B1800" nil t)
 (:integer b2400 "B2400" nil t)
 (:integer b4800 "B4800" nil t)
 (:integer b9600 "B9600" nil t)
 (:integer b19200 "B19200" nil t)
 (:integer b38400 "B38400" nil t)

 (:integer csize "CSIZE" nil t)
 (:integer cs5 "CS5" nil t)
 (:integer cs6 "CS6" nil t)
 (:integer cs7 "CS7" nil t)
 (:integer cs8 "CS8" nil t)
 (:integer cstopb "CSTOPB" nil t)
 (:integer cread "CREAD" nil t)
 (:integer parenb "PARENB" nil t)
 (:integer parodd "PARODD" nil t)
 (:integer hupcl "HUPCL" nil t)
 (:integer clocal "CLOCAL" nil t)

 (:integer echo "ECHO" nil t)
 (:integer echoe "ECHOE" nil t)
 (:integer echok "ECHOK" nil t)
 (:integer echonl "ECHONL" nil t)
 (:integer icanon "ICANON" nil t)
 (:integer iexten "IEXTEN" nil t)
 (:integer isig "ISIG" nil t)
 (:integer noflsh "NOFLSH" nil t)
 (:integer tostop "TOSTOP" nil t)

 (:integer tcsanow "TCSANOW" nil t)
 (:integer tcsadrain "TCSADRAIN" nil t)
 (:integer tcsaflush "TCSAFLUSH" nil t)

 (:integer tciflush "TCIFLUSH" nil t)
 (:integer tcioflush "TCIOFLUSH" nil t)
 (:integer tcoflush "TCOFLUSH" nil t)
 (:integer tcioff "TCIOFF" nil t)
 (:integer tcion "TCION" nil t)
 (:integer tcooff "TCOOFF" nil t)
 (:integer tcoon "TCOON" nil t)

 )
