/*
 * SARG Squid Analysis Report Generator      http://sarg.sourceforge.net
 *                                                            1998, 2011
 *
 * SARG donations:
 *      please look at http://sarg.sourceforge.net/donations.php
 * Support:
 *     http://sourceforge.net/projects/sarg/forums/forum/363374
 * ---------------------------------------------------------------------
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
 *
 */

#include "include/conf.h"
#include "include/defs.h"

void tmpsort(const struct userinfostruct *uinfo)
{
	int cstatus;
	char csort[MAXLEN];
	char arqou[MAXLEN], arqin[MAXLEN];
	const char *field1="2,2";
	const char *field2="1,1";
	const char *field3="3,3";
	const char *order;

	if((UserSort & USER_SORT_CONNECT) != 0) {
		field1="1,1";
		field2="2,2";
		field3="3,3";
	} else if((UserSort & USER_SORT_SITE) != 0) {
		field1="3,3";
		field2="2,2";
		field3="1,1";
	} else if((UserSort & USER_SORT_TIME) != 0) {
		field1="5,5";
		field2="2,2";
		field3="1,1";
	}

	if((UserSort & USER_SORT_REVERSE) == 0)
		order="";
	else
		order="-r";

	if (snprintf(arqin,sizeof(arqin),"%s/%s.utmp",tmp,uinfo->filename)>=sizeof(arqin)) {
		debuga(_("file name too long: %s/%s.utmp\n"),tmp,uinfo->filename);
		exit(EXIT_FAILURE);
	}
	if (snprintf(arqou,sizeof(arqou),"%s/htmlrel.txt",tmp)>=sizeof(arqou)) {
		debuga(_("file name too long: %s/htmlrel.txt\n"),tmp);
		exit(EXIT_FAILURE);
	}

	if(debug) {
		debuga(_("Sorting file: %s\n"),arqin);
	}

	if (snprintf(csort,sizeof(csort),"sort -n -T \"%s\" -t \"\t\" %s -k %s -k %s -k %s -o \"%s\" \"%s\"",tmp,order,field1,field2,field3,arqou,arqin)>=sizeof(csort)) {
		debuga(_("Sort command too long when sorting file \"%s\" to \"%s\"\n"),arqin,arqou);
		exit(EXIT_FAILURE);
	}
	cstatus=system(csort);
	if (!WIFEXITED(cstatus) || WEXITSTATUS(cstatus)) {
		debuga(_("sort command return status %d\n"),WEXITSTATUS(cstatus));
		debuga(_("sort command: %s\n"),csort);
		exit(EXIT_FAILURE);
	}
	if (unlink(arqin)) {
		debuga(_("Cannot delete %s - %s\n"),arqin,strerror(errno));
		exit(EXIT_FAILURE);
	}

	return;
}

void sort_users_log(const char *tmp, int debug)
{
	DIR *dirp;
	struct dirent *direntp;
	char csort[MAXLEN];
	char user[MAXLEN];
	char wdname[MAXLEN];
	int cstatus;
	int dlen;
	int clen;
	const char unsortext[]=".unsort";

	if(debug) {
		debuga(_("pre-sorting files\n"));
	}

	if ((dirp = opendir(tmp)) == NULL) {
		debuga(_("Failed to open directory %s - %s\n"),tmp,strerror(errno));
		exit(EXIT_FAILURE);
	}
	while ( (direntp = readdir( dirp )) != NULL ){
		dlen=strlen(direntp->d_name)-(sizeof(unsortext)-1);
		if (dlen<0) continue;
		if(strcmp(direntp->d_name+dlen,unsortext) != 0)
			continue;
		if(strcmp(direntp->d_name,"authfail.log.unsort") == 0)
			continue;

		if (dlen>0) {
			if (dlen>=sizeof(user)) continue;
			safe_strcpy(user,direntp->d_name,dlen+1);
		} else {
			user[0]='\0';
		}

		if(strcmp(direntp->d_name,"download.unsort") == 0)
			clen=snprintf(csort,sizeof(csort),"sort -T \"%s\" -t \"\t\" -k 3,3 -k 1,1 -k 2,2 -k 5,5 -o \"%s/%s.log\" \"%s/%s.unsort\"",
			    tmp, tmp, user, tmp, user);
		else
			clen=snprintf(csort,sizeof(csort),"sort -T \"%s\" -t \"\t\" -k 4,4 -k 1,1 -k 2,2 -o \"%s/%s.log\" \"%s/%s.unsort\"",
			    tmp, tmp, user, tmp, user);
		if (clen>=sizeof(csort)) {
			debuga(_("user name too long to sort %s\n"),csort);
			exit(EXIT_FAILURE);
		}
		cstatus=system(csort);
		if (!WIFEXITED(cstatus) || WEXITSTATUS(cstatus)) {
			debuga(_("sort command return status %d\n"),WEXITSTATUS(cstatus));
			debuga(_("sort command: %s\n"),csort);
			exit(EXIT_FAILURE);
		}
		if (snprintf(wdname,sizeof(wdname),"%s/%s.unsort",tmp,user)>=sizeof(wdname)) {
			debuga(_("user name too long for %s/%s.unsort\n"),tmp,user);
			exit(EXIT_FAILURE);
		}
		if (unlink(wdname)) {
			debuga(_("Cannot delete %s - %s\n"),wdname,strerror(errno));
			exit(EXIT_FAILURE);
		}
	}
	(void)closedir( dirp );

	return;
}

void sort_labels(const char **label,const char **order)
{
	if((UserSort & USER_SORT_CONNECT) != 0) {
		*label=_("connect");
	} else if((UserSort & USER_SORT_SITE) != 0) {
		*label=_("site");
	} else if((UserSort & USER_SORT_TIME) != 0) {
		*label=_("time");
	} else {
		*label=_("bytes");
	}

	if((UserSort & USER_SORT_REVERSE) == 0)
		*order=_("normal");
	else
		*order=_("reverse");
}
