#! /bin/sh

echo "Command Line Options Tests"

initit () {
    echo "Testing $1"
    unset opt
}

testit () {
    echo "$1"
    opt="$opt $1 -sleep .1"
}

doit () {
    eval ds9 -zscale img16.fits "$opt" -exit
    echo "PASSED"
}

# must be invoked
#         -prefs
#         -samp

# not tested
#	  -geometry
#	  -private
#	  -visual

if [ "$1" = "2mass" -o -z "$1" ]; then
initit "2mass"
testit "-2mass open"
testit "-2mass close"
testit "-2mass survey h"
testit "-2mass size 30 30 arcsec"
testit "-2mass save no"
testit "-2mass frame new"
testit "-2mass update frame"
testit "-2mass m1"
testit "-2mass name m51"
testit "-2mass name ''"
testit "-2mass coord 00:42:44.404 +41:16:08.78 sexagesimal"
testit "-2mass update frame"
testit "-mode crosshair"
testit "-2mass update crosshair"
testit "-2mass close"
testit "-mode pointer"
doit
fi

if [ "$1" = "3d" -o -z "$1" ]; then
initit "3d"
testit "-3d open"
testit "-3d close"
testit "-3d"
testit "-3d vp 45 30"
testit "-3d az 45"
testit "-3d el 30"
testit "-3d method mip"
testit "-3d highlite yes"
testit "-3d highlite color red"
testit "-3d close"
doit
fi

if [ "$1" = "about" -o -z "$1" ]; then
initit "about"
testit "-about"
doit
fi

if [ "$1" = "align" -o -z "$1" ]; then
initit "align"
testit "-align"
doit
fi

if [ "$1" = "analysis" -o -z "$1" ]; then
initit "analysis"
testit "-analysis clear"
testit "-analysis analysis.ans"
testit "-analysis 0"
testit "-analysis clear"
testit "-analysis load analysis.ans"
testit "-analysis clear load analysis.ans"
testit "-analysis clear"
#testit "-analysis message 'This is a message'"
#testit "-analysis message yesno 'This is a message'"
testit "-analysis text 'This is text'"
doit
fi

if [ "$1" = "array" -o -z "$1" ]; then
initit "array"
testit "-frame clear"
testit "-array 'array.arr[dim=512,bitpix=-32,arch=bigendian]'"
doit
fi

if [ "$1" = "bg" -o -z "$1" ]; then
initit "bg"
testit "-background red"
testit "-bg blue"
testit "-background white"
doit
fi

if [ "$1" = "bin" -o -z "$1" ]; then
initit "bin"
testit "-frame clear"
testit "table.fits"
testit "-single"
testit "-bin open"
testit "-bin factor 4"
testit "-bin factor 8 8"
testit "-scale log"
testit "-scale minmax"
testit "-bin buffersize 1024"
testit "-bin filter 'circle(4096,4096,200)'"
testit "-bin filter ''"
testit "-bin cols rawx rawy"
testit "-bin about center"
testit "-bin colsz x y pha"
testit "-bin depth 10"
testit "-bin about 4096 4096"
testit "-bin depth 1"
testit "-bin function sum"
testit "-bin to fit"
testit "-bin match"
testit "-bin lock yes"
testit "-bin lock no"
testit "-bin close"
doit
fi

if [ "$1" = "catalog" -o -z "$1" ]; then
initit "catalog"
testit "-catalog cds 2mass"

testit "-catalog clear"
testit "-catalog close"

testit "-catalog"
testit "-catalog close"

testit "-catalog cds 'I/284'"
testit "-catalog clear"
testit "-catalog close"

testit "-catalog load sb ds9.cat"
testit "-catalog clear"
testit "-catalog close"

testit "-catalog cds 2mass"
testit "-raise"
testit "-catalog symbol condition '\$Jmag>15'"
testit "-catalog symbol shape 'boxcircle point'"
testit "-catalog symbol color red"
testit "-catalog symbol condition ''"
testit "-catalog symbol color red"
testit "-catalog symbol shape text"
testit "-catalog symbol font times"
testit "-catalog symbol fontsize 14"
testit "-catalog symbol fontweight bold"
testit "-catalog symbol fontslant italic"
testit "-catalog symbol add"
testit "-catalog symbol remove"
testit "-catalog symbol load ds9.sym"
testit "-catalog symbol save foo.sym"
testit "-catalog name m51"
testit "-catalog coordinate 202.48 47.21 fk5"
testit "-catalog system wcs"
testit "-catalog sky fk5"
testit "-catalog skyformat degrees"
testit "-catalog size 22 22 arcmin"
testit "-catalog retrieve"
testit "-catalog save foo.cat"
testit "-catalog filter '\$Jmag>15'"
testit "-catalog filter load ds9.flt"
testit "-catalog retrieve"
testit "-catalog cancel"
#testit "-catalog print"
testit "-catalog server sao"
testit "-catalog sort 'Jmag' incr"
testit "-catalog maxrows 3000"
testit "-catalog allcols"
testit "-catalog allrows"
testit "-catalog ra 'RAJ2000'"
testit "-catalog dec 'DEJ2000'"
testit "-catalog psystem wcs"
testit "-catalog psky fk5"
testit "-catalog hide"
testit "-catalog show"
testit "-catalog panto no"
#testit "-catalog edit yes"
testit "-catalog clear"
testit "-catalog close"
doit
rm -f foo.cat
fi

if [ "$1" = "cd" -o -z "$1" ]; then
initit "cd"
testit "-cd ."
doit
fi

if [ "$1" = "cmap" -o -z "$1" ]; then
initit "cmap"
testit "-cmap open"
testit "-cmap Heat"
testit "-cmap load ds9.sao"
testit "-cmap save foo.sao"
testit "-cmap invert yes"
testit "-cmap invert no"
testit "-invert"
testit "-cmap value 5 .2"
testit "-cmap tag load ds9.tag"
testit "-cmap tag save foo.tag"
testit "-cmap tag delete"
testit "-cmap match"
testit "-cmap lock yes"
testit "-cmap lock no"
testit "-cmap Grey"
testit "-cmap close"
doit
rm -f foo.sao foo.tag
fi

if [ "$1" = "colorbar" -o -z "$1" ]; then
initit "colorbar"
testit "-colorbar no"
testit "-colorbar yes"
testit "-colorbar vertical"
testit "-colorbar horizontal"
testit "-colorbar numerics no"
testit "-colorbar numerics yes"
testit "-colorbar space value"
testit "-colorbar space distance"
testit "-colorbar font times"
testit "-colorbar fontsize 30"
testit "-colorbar fontweight bold"
testit "-colorbar fontslant roman"
testit "-colorbar font helvetica"
testit "-colorbar fontsize 10"
testit "-colorbar fontweight normal"
testit "-colorbar fontslant roman"
testit "-colorbar size 30"
testit "-colorbar ticks 9"
testit "-colorbar size 20"
testit "-colorbar size 11"
doit
fi

if [ "$1" = "console" -o -z "$1" ]; then
initit "console"
testit "-console"
doit
fi

if [ "$1" = "contour" -o -z "$1" ]; then
initit "contour"
testit "-contour open"
testit "-contour"
testit "-contour yes"

testit "-contour clear"
testit "-contour yes"
testit "-contour load ds9.con wcs fk5 red 2"
testit "-contour save foo.con wcs fk5"

testit "-contour clear"
testit "-contour yes"
testit "-contour convert"
testit "-regions delete all"
testit "-contour loadlevels ds9.lev"
testit "-contour savelevels foo.lev"

testit "-contour clear"
testit "-contour yes"
testit "-contour copy"
testit "-contour paste wcs red 2"

testit "-contour clear"
testit "-contour yes"
testit "-contour color yellow"
testit "-contour width 2"
testit "-contour smooth 5"
testit "-contour method block"
testit "-contour nlevels 10"
testit "-contour width 2"
testit "-contour scale sqrt"
testit "-contour log exp 1000"
testit "-contour mode zscale"
testit "-contour limits 1 100"
testit "-contour levels '1 10 100 1000'"

testit "-contour clear"
testit "-contour close"
rm -f foo.con foo.lev
doit
fi

if [ "$1" = "crop" -o -z "$1" ]; then
initit "crop"
testit "-mode crop"
testit "-crop 978 970  356 308"
testit "-crop 13:29:52.908 +47:11:38.19  35.279606 30.522805 wcs fk5 arcsec"
testit "-crop reset"
testit "-3d 3d.fits"
testit "-3d vp 45 30"
testit "-crop 3d 25 75"
testit "-crop reset"
testit "-crop match wcs"
testit "-crop lock wcs"
testit "-crop lock none"
testit "-3d close"
testit "-frame delete"
testit "-mode pointer"
doit
fi

if [ "$1" = "crosshair" -o -z "$1" ]; then
initit "crosshair"
testit "-mode crosshair"
testit "-crosshair 13:29:55.287 +47:11:37.73 wcs fk5"
testit "-crosshair match wcs"
testit "-crosshair lock wcs"
testit "-crosshair lock none"
testit "-mode pointer"
doit
fi

if [ "$1" = "cursor" -o -z "$1" ]; then
initit "cursor"
testit "-mode crosshair"
testit "-cursor 10 10"
testit "-mode pointer"
doit
fi

if [ "$1" = "cube" -o -z "$1" ]; then
initit "cube"
testit "-cube open"
testit "-cube close"
testit "-file hst.fits"
testit "-single"
testit "-cube 2"
testit "-cube interval .5"
testit "-cube axis 2"
testit "-cube play"
testit "-cube stop"
testit "-cube match"
testit "-cube lock yes"
testit "-cube lock no"
testit "-cube close"
doit
fi

if [ "$1" = "dsssao" -o -z "$1" ]; then
initit "dsssao"
testit "-dsssao open"
testit "-dsssao close"
testit "-dsssao size 30 30 arcsec"
testit "-dsssao save no"
testit "-dsssao frame new"
testit "-dsssao update frame"
testit "-dsssao m1"
testit "-dsssao name m51"
testit "-dsssao name ''"
testit "-dsssao coord 00:42:44.404 +41:16:08.78 sexagesimal"
testit "-dsssao update frame"
testit "-mode crosshair"
testit "-dsssao update crosshair"
testit "-dsssao close"
testit "-mode pointer"
doit
fi

if [ "$1" = "dsseso" -o -z "$1" ]; then
initit "dsseso"
testit "-dsseso open"
testit "-dsseso close"
testit "-dsseso survey DSS2-red"
testit "-dsseso size 30 30 arcsec"
testit "-dsseso save no"
testit "-dsseso frame new"
testit "-dsseso update frame"
testit "-dsseso m1"
testit "-dsseso name m51"
testit "-dsseso name ''"
testit "-dsseso coord 00:42:44.404 +41:16:08.78 sexagesimal"
testit "-dsseso update frame"
testit "-mode crosshair"
testit "-dsseso update crosshair"
testit "-dsseso close"
testit "-mode pointer"
doit
fi

if [ "$1" = "dssstsci" -o -z "$1" ]; then
initit "dssstsci"
testit "-dssstsci open"
testit "-dssstsci close"
testit "-dssstsci survey all"
testit "-dssstsci size 30 30 arcsec"
testit "-dssstsci save no"
testit "-dssstsci frame new"
testit "-dssstsci update frame"
testit "-dssstsci m1"
testit "-dssstsci name m51"
testit "-dssstsci name ''"
testit "-dssstsci coord 00:42:44.404 +41:16:08.78 sexagesimal"
testit "-dssstsci update frame"
testit "-mode crosshair"
testit "-dssstsci update crosshair"
testit "-dssstsci close"
testit "-mode pointer"
doit
fi

if [ "$1" = "export" -o -z "$1" ]; then
initit "export"
testit "-export foo.fits"
testit "-export foo.gif"
testit "-export foo.tif"
testit "-export foo.tif none"
testit "-export foo.jpg"
testit "-export foo.jpg 100"
testit "-export foo.png"
testit "-export foo.ppm"

# backward compatability
testit "-savefits foo.fits"

rm -f foo.fits foo.gif foo.tif foo.jpg foo.png foo.ppm
doit
fi

if [ "$1" = "fifo" -o -z "$1" ]; then
initit "fifo"
testit "-fifo /dev/imt1"
testit "-fifo_only"
doit
fi

if [ "$1" = "file" -o -z "$1" ]; then
initit "file"
testit "-frame clear"
testit "-file img16.fits"
doit
fi

if [ "$1" = "first" ]; then
initit "first"
testit "-first open"
testit "-first close"
testit "-first size 30 30 arcsec"
testit "-first save no"
testit "-first frame new"
testit "-first update frame"
testit "-first m3"
testit "-first name m51"
testit "-first name ''"
testit "-first coord 13:29:52.37 +47:11:40.8 sexagesimal"
testit "-first update frame"
testit "-mode crosshair"
testit "-first update crosshair"
testit "-first close"
testit "-mode pointer"
doit
fi

if [ "$1" = "fits" -o -z "$1" ]; then
initit "fits"
testit "-frame clear"
testit "-fits img16.fits"
doit
fi

if [ "$1" = "sfits" -o -z "$1" ]; then
initit "sfits"
testit "-frame clear"
testit "-sfits sfits.hdr sfits.arr"
doit
fi

if [ "$1" = "frame" -o -z "$1" ]; then
initit "frame"
testit "-frame new rgb"
testit "-frame delete"
testit "-frame new 3d"
testit "-frame delete"
testit "-file img16.fits"
testit "-tile"
testit "-frame center"
testit "-frame center 1"
testit "-frame center all"
testit "-frame reset"
testit "-frame reset 1"
testit "-frame reset all"
testit "-frame refresh"
testit "-frame refresh 1"
testit "-frame refresh all"
testit "-frame hide"
testit "-frame hide 1"
testit "-frame hide all"
testit "-frame show"
testit "-frame show 1"
testit "-frame show all"
testit "-frame move first"
testit "-frame move back"
testit "-frame move forward"
testit "-frame move last"
testit "-frame first"
testit "-frame prev"
testit "-frame next"
testit "-frame last"
testit "-frame frameno 1"
testit "-frame 2"
testit "-frame match wcs"
testit "-frame lock wcs"
testit "-frame lock none"
testit "-frame clear"
testit "-frame clear 1"
testit "-frame clear all"
testit "-frame delete"
testit "-frame delete 1"
testit "-frame delete all"
doit
fi

if [ "$1" = "grid" -o -z "$1" ]; then
initit "grid"
testit "-grid open"
testit "-grid close"

testit "-grid"
testit "-grid yes"
 
testit "-grid type analysis"
testit "-grid system wcs"
testit "-grid sky fk5"
testit "-grid skyformat degrees"

testit "-grid grid yes"
testit "-grid grid color red"
testit "-grid grid width 2"
testit "-grid grid style 1"
testit "-grid grid gap1 .01"
testit "-grid grid gap2 .01"
 
testit "-grid axes yes"
testit "-grid axes color red"
testit "-grid axes width 2"
testit "-grid axes style 1"
testit "-grid axes type exterior"
testit "-grid axes origin lll"
 
testit "-grid format1 d.2"
testit "-grid format2 d.2"

testit "-grid tickmarks color red"
testit "-grid tickmarks width 2"
testit "-grid tickmarks style 1"

testit "-grid border yes"
testit "-grid border color red"
testit "-grid border width 2"
testit "-grid border style 1"

testit "-grid numerics yes"
testit "-grid numerics font courier"
testit "-grid numerics fontweight bold"
testit "-grid numerics fontslant roman"
testit "-grid numerics fontsize 12"
testit "-grid numerics color red"
testit "-grid numerics gap1 10"
testit "-grid numerics gap2 10"
testit "-grid numerics type exterior"
testit "-grid numerics vertical yes"

testit "-grid title yes"
testit "-grid title text 'Hello World'"
testit "-grid title def yes"
testit "-grid title gap 10"
testit "-grid title font courier"
testit "-grid title fontweight bold"
testit "-grid title fontslant roman"
testit "-grid title fontsize 12"
testit "-grid title color red"

testit "-grid labels yes"
testit "-grid labels text1 'Hello World'"
testit "-grid labels def1 yes"
testit "-grid labels gap1 10"
testit "-grid labels text2 'Hello World'"
testit "-grid labels def2 yes"
testit "-grid labels gap2 10"
testit "-grid labels font courier"
testit "-grid labels fontweight bold"
testit "-grid labels fontslant roman"
testit "-grid labels fontsize 12"
testit "-grid labels color red"

testit "-grid save foo.grd"
testit "-grid load foo.grd"
testit "-grid reset"

testit "-grid no"
testit "-grid close"
doit
fi

if [ "$1" = "header" -o -z "$1" ]; then
initit "header"
testit "-header"
testit "-header save foo.txt"
testit "-header close"
testit "-header 1"
testit "-header close 1"
doit
fi

if [ "$1" = "help" -o -z "$1" ]; then
initit "help"
testit "--help"
doit
fi

if [ "$1" = "height" -o -z "$1" ]; then
initit "height"
testit "-height 443"
doit
fi

if [ "$1" = "iconify" -o -z "$1" ]; then
initit "iconify"
testit "-iconify"
testit "-iconify yes"
testit "-iconify no"
doit
fi

if [ "$1" = "iis" -o -z "$1" ]; then
initit "iis"
testit "-iis filename foo.fits"
testit "-iis filename foo.fits 1"
doit
fi

if [ "$1" = "lock" -o -z "$1" ]; then
initit "lock"
testit "-file img16.fits"
testit "-tile"
testit "-mode crosshair"
testit "-lock frame wcs"
testit "-lock frame none"
testit "-lock crosshair wcs"
testit "-crosshair 13:29:56 +47:11:38 wcs fk5"
testit "-lock crosshair none"
testit "-lock crop wcs"
testit "-lock crop none"
testit "-lock slice yes"
testit "-lock slice no"
testit "-lock bin yes"
testit "-lock bin no"
testit "-lock scale yes"
testit "-lock scale no"
testit "-lock color yes"
testit "-lock color no"
testit "-mode pointer"
testit "-frame delete"
testit "-wcs align no"
testit "-single"
doit
fi

if [ "$1" = "lower" -o -z "$1" ]; then
initit "lower"
testit "-lower"
testit "-raise"
doit
fi

if [ "$1" = "magnifier" -o -z "$1" ]; then
initit "magnifier"
testit "-magnifier color white"
testit "-magnifier zoom 4"
testit "-magnifier cursor yes"
testit "-magnifier region yes"
doit
fi

if [ "$1" = "mask" -o -z "$1" ]; then
initit "mask"
testit "-mask open"
testit "-mask color red"
testit "-mask mask.fits"
testit "-mask color cyan"
testit "-mask mask2.fits"
testit "-mask clear"
testit "-mask color red"
testit "-mask close"
doit
fi

if [ "$1" = "match" -o -z "$1" ]; then
initit "match"
testit "-file img-32.fits"
testit "-tile"
testit "-mode crosshair"
testit "-match frame wcs"
testit "-match frame image"
testit "-match crosshair wcs"
testit "-match crop wcs"
testit "-match slice"
testit "-match bin"
testit "-match scale"
testit "-match color"
testit "-frame delete"
testit "-mode pointer"
testit "-single"
doit
fi

if [ "$1" = "mecube" -o -z "$1" ]; then
initit "mecube"
testit "-frame clear"
testit "-mecube mosaicimage.fits"
doit
fi

if [ "$1" = "minmax" -o -z "$1" ]; then
initit "minmax"
testit "-minmax scan"
testit "-minmax mode scan"
testit "-minmax interval 10"
doit
fi

if [ "$1" = "mode" -o -z "$1" ]; then
initit "mode"
testit "-mode none"
testit "-mode crosshair"
testit "-mode colorbar"
testit "-mode pan"
testit "-mode zoom"
testit "-mode rotate"
testit "-mode catalog"
testit "-mode examine"
testit "-mode pointer"
doit
fi

if [ "$1" = "mosaic" -o -z "$1" ]; then
initit "mosaic"
testit "-frame clear"
testit "-mosaic iraf mosaicimage.fits"
doit
fi

if [ "$1" = "smosaic" -o -z "$1" ]; then
initit "smosaic"
testit "-frame clear"
testit "-smosaic wcs sfits.hdr sfits.arr"
doit
fi

if [ "$1" = "mosaicimage" -o -z "$1" ]; then
initit "mosaicimage"
testit "-frame clear"
testit "-mosaicimage iraf mosaicimage.fits"
doit
fi

if [ "$1" = "movie" -o -z "$1" ]; then
initit "movie"
testit "-width 700 -height 400"
testit "-movie frame foo.mpg"
testit "-frame new 3d"
testit "-movie 3d foo.mpg number 1 azfrom 0 azto 0 elfrom 0 elto 0 slfrom 1 slto 1 repeat 1"
testit "-frame delete"

# backward compatibility
testit "-savempeg foo.mpg"

doit
rm -f foo.mpg
fi

if [ "$1" = "multiframe" -o -z "$1" ]; then
initit "multiframe"
testit "-frame clear"
testit "-multiframe mosaicimage.fits"
doit
fi

if [ "$1" = "nameserver" -o -z "$1" ]; then
initit "nameserver"
testit "-nameserver open"
testit "-nameserver close"
testit "-nameserver m51"
testit "-nameserver name m51"
testit "-nameserver server simbad-cds"
testit "-nameserver skyformat degrees"
testit "-mode crosshair"
testit "-nameserver crosshair"
testit "-nameserver pan"
testit "-nameserver close"
testit "-mode pointer"
testit "-frame reset"
doit
fi

if [ "$1" = "nan" -o -z "$1" ]; then
initit "nan"
testit "-nan blue"
testit "-nan white"
doit
fi

if [ "$1" = "nvss" -o -z "$1" ]; then
initit "nvss"
testit "-nvss open"
testit "-nvss close"
testit "-nvss size 30 30 arcsec"
testit "-nvss save no"
testit "-nvss frame new"
testit "-nvss update frame"
testit "-nvss m3"
testit "-nvss name m51"
testit "-nvss name ''"
testit "-nvss coord 13:29:52.37 +47:11:40.8 sexagesimal"
testit "-nvss update frame"
testit "-mode crosshair"
testit "-nvss update crosshair"
testit "-nvss close"
testit "-mode pointer"
doit
fi

if [ "$1" = "orient" -o -z "$1" ]; then
initit "orient"
testit "-orient open"
testit "-orient none"
testit "-orient x"
testit "-orient y"
testit "-orient xy"
testit "-orient close"
testit "-frame reset"
doit
fi

if [ "$1" = "pagesetup" -o -z "$1" ]; then
initit "pagesetup"
testit "-pspagesetup orient portrait"
testit "-pspagesetup scale 100"
testit "-pspagesetup size letter"
doit
fi

if [ "$1" = "pan" -o -z "$1" ]; then
initit "pan"
testit "-pan open"
testit "-pan 100 100 image"
testit "-pan to 13:29:55.666 +47:12:16.29 wcs fk5"
testit "-pan close"
testit "-frame reset"
doit
fi

if [ "$1" = "photo" -o -z "$1" ]; then
initit "photo"
testit "-frame new"
testit "-photo rose.jpg"
testit "-frame delete"
testit "-frame new rgb"
testit "-photo rose.tif"
testit "-frame delete"
doit
fi

if [ "$1" = "pixeltable" -o -z "$1" ]; then
initit "pixeltable"
testit "-pixeltable"
testit "-pixeltable yes"
testit "-pixeltable no"
testit "-pixeltable open"
testit "-pixeltable close"
doit
fi

if [ "$1" = "plot" -o -z "$1" ]; then
initit "plot"

echo "..empty plot"
testit "-plot"
testit "-plot new"
testit "-plot new name foo"
testit "-plot new name foo 'The Title' 'X Axis' 'Y Axis' xy"
testit "-plot close"
testit "-plot close"
testit "-plot close"
testit "-plot close"

echo "..4|5"
testit "-plot new 'The Title' 'X Axis' 'Y Axis' 4"
testit "-plot load 4.dat 4"
testit "-plot new 'The Title' 'X Axis' 'Y Axis' 5"
testit "-plot load 5.dat 5"
testit "-plot close"
testit "-plot close"

echo "..named 4|5"
testit "-plot new name foo 'The Title' 'X Axis' 'Y Axis' 4"
testit "-plot load 4.dat 4"
testit "-plot new name foo 'The Title' 'X Axis' 'Y Axis' 5"
testit "-plot load 5.dat 5"
testit "-plot close"
testit "-plot close"

echo "..xy|xyex|xyey|xyexey"
testit "-plot new 'The Title' 'X Axis' 'Y Axis' xy"
testit "-plot load xy.dat xy"
testit "-plot new 'The Title' 'X Axis' 'Y Axis' xyex"
testit "-plot load xyex.dat xyex"
testit "-plot new 'The Title' 'X Axis' 'Y Axis' xyey"
testit "-plot load xyey.dat xyey"
testit "-plot new 'The Title' 'X Axis' 'Y Axis' xyexey"
testit "-plot load xyexey.dat xyexey"
sleep "$delay"
testit "-plot close"
testit "-plot close"
testit "-plot close"
testit "-plot close"

echo "..name xy|xyex|xyey|xyexey"
testit "-plot new name foo 'The Title' 'X Axis' 'Y Axis' xy"
testit "-plot load xy.dat xy"
testit "-plot new name foo 'The Title' 'X Axis' 'Y Axis' xyex"
testit "-plot load xyex.dat xyex"
testit "-plot new name foo 'The Title' 'X Axis' 'Y Axis' xyey"
testit "-plot load xyey.dat xyey"
testit "-plot new name foo 'The Title' 'X Axis' 'Y Axis' xyexey"
testit "-plot load xyexey.dat xyexey"
sleep "$delay"
testit "-plot close"
testit "-plot close"
testit "-plot close"
testit "-plot close"

echo "..clear/close"
testit "-plot new"
testit "-plot load xy.dat xy"
testit "-plot clear"
testit "-plot close"

echo "..save/load"
testit "-plot new"
testit "-plot load xy.dat xy"
testit "-plot save foo.dat"
testit "-plot saveconfig foo.plt"
testit "-plot loadconfig foo.plt"
testit "-plot close"
rm -f foo.dat foo.plt

echo "..print"
testit "-plot new"
#testit "-plot print"
testit "-plot print destination printer"
testit "-plot print command 'lp'"
testit "-plot print filename 'foo.ps'"
testit "-plot print color rgb"
testit "-plot pagesetup orient portrait"
testit "-plot pagesetup pagesize letter"
testit "-plot close"
rm -f foo.ps

echo "..grid"
testit "-plot new"
testit "-plot graph grid yes"
testit "-plot graph scale loglog"
testit "-plot graph range x auto no"
testit "-plot graph range x min 1"
testit "-plot graph range x max 100"
testit "-plot graph range y auto no"
testit "-plot graph range y min 1"
testit "-plot graph range y max 100"
testit "-plot graph labels title 'The Title'"
testit "-plot graph labels xaxis 'X Axis'"
testit "-plot graph labels yaxis 'Y Axis'"

testit "-plot font numbers font times"
testit "-plot font numbers size 12"
testit "-plot font numbers weight bold"
testit "-plot font numbers slant roman"
testit "-plot font labels font times"
testit "-plot font labels size 12"
testit "-plot font labels weight bold"
testit "-plot font labels slant roman"
testit "-plot font title font times"
testit "-plot font title size 12"
testit "-plot font title weight bold"
testit "-plot font title slant roman"
testit "-plot close"

echo "..dataset"
testit "-plot new"
testit "-plot load xy.dat xy"
testit "-plot load xyey.dat xyey"
testit "-plot dataset 2"

testit "-plot view discrete yes"
testit "-plot view line yes"
testit "-plot view step yes"
testit "-plot view quadratic yes"
testit "-plot view errorbar yes"

testit "-plot color discrete red"
testit "-plot view line green"
testit "-plot view step blue"
testit "-plot view quadratic cyan"
testit "-plot view errorbar yellow"

testit "-plot line discrete cross"
testit "-plot line line width 2"
testit "-plot line line dash yes"
testit "-plot line step width 2"
testit "-plot line step dash yes"
testit "-plot line quadratic width 2"
testit "-plot line quadratic dash yes"
testit "-plot line errorbar width 2"
testit "-plot line errorbar style 2"
testit "-plot close"

doit
fi

if [ "$1" = "port" -o -z "$1" ]; then
initit "port"
testit "-port 5137"
testit "-port_only"
testit "-inet_only"
doit
fi

if [ "$1" = "prefs" -o -z "$1" ]; then
initit "prefs"
testit "-prefs clear"
doit
fi

if [ "$1" = "preserve" -o -z "$1" ]; then
initit "preserve"
testit "-preserve scale no"
testit "-preserve pan no"
testit "-preserve regions no"
doit
fi

if [ "$1" = "print" -o -z "$1" ]; then
initit "print"
#testit "-psprint"
testit "-psprint destination printer"
testit "-psprint command lp"
testit "-psprint filename ds9.ps"
testit "-psprint color rgb"
testit "-psprint level 2"
testit "-psprint resolution 75"
doit
fi

if [ "$1" = "regions" -o -z "$1" ]; then
initit "regions"
testit "-regions ds9.physical.reg"
testit "-regions delete all"
testit "-regions load ds9.physical.reg"
testit "-regions delete all"
testit "-regions load 'ds9.fk5*.reg'"
testit "-regions delete all"
testit "-regions load all ds9.physical.reg"
testit "-regions save foo.reg"
testit "-regions list"
testit "-regions list close"
testit "-regions delete all"
rm -f foo.reg

testit "-regions show yes"
testit "-regions showtext yes"
testit "-regions centroid auto no"
testit "-regions centroid radius 10"
testit "-regions centroid iteration 30"
#testit "-regions getinfo"
testit "-regions move front"
testit "-regions move back"
testit "-regions select all"
testit "-regions select none"
testit "-regions delete all"
testit "-regions delete select"
testit "-regions format ds9"
testit "-regions system physical"
testit "-regions sky fk5"
testit "-regions skyformat degrees"
testit "-regions delim nl"
testit "-regions strip no"
testit "-regions shape circle"
testit "-regions color green"
testit "-regions width 1"
testit "-regions edit yes"
testit "-regions include"
testit "-regions command 'circle 100 100 20'"

testit "-regions group new"
testit "-regions group foo new"
testit "-regions group foo update"
testit "-regions group foo select"
testit "-regions group foo color red"
testit "-regions group foo copy"
testit "-regions group foo delete"
testit "-regions group foo cut"
testit "-regions group foo font 'time 14 bold'"
testit "-regions group foo move 100 100"
testit "-regions group foo movefront"
testit "-regions group foo moveback"
testit "-regions group foo property delete no"

testit "-regions delete all"

testit "-regions command 'circle 100 100 20'"
testit "-regions select all"
testit "-regions copy"
testit "-regions cut"
testit "-regions paste"
testit "-regions undo"
testit "-regions delete all"

testit "-regions load ds9.physical.reg"
testit "-regions select all"
testit "-regions composite"
testit "-regions desolve"
testit "-regions delete all"

testit "-regions command 'circle 100 100 20'"
testit "-regions savetemplate foo.tpl"
testit "-regions delete all"
testit "-regions template foo.tpl"
testit "-regions delete all"
testit "-regions template foo.tpl at 202.46963 47.19556 fk5"
testit "-regions delete all"
rm -f foo.tpl

doit
fi

if [ "$1" = "rgb" -o -z "$1" ]; then
initit "rgb"
testit "-rgb open"
testit "-rgb close"
testit "-rgb"
testit "-rgb green"
testit "-rgb channel blue"
testit "-red"
testit "-green"
testit "-blue"
testit "-rgb view blue off"
testit "-rgb system wcs"
testit "-rgb lock wcs yes"
testit "-rgb lock crop yes"
testit "-rgb lock slice yes"
testit "-rgb lock bin yes"
testit "-rgb lock scale yes"
testit "-rgb lock colorbar yes"
testit "-rgb lock smooth yes"
testit "-rgb close"
doit
fi

if [ "$1" = "rgbarray" -o -z "$1" ]; then
initit "rgbarray"
testit "-rgbarray rgb.arr[dim=200,zdim=3,bitpix=8]"
doit
fi

if [ "$1" = "rgbcube" -o -z "$1" ]; then
initit "rgbcube"
testit "-rgbcube rgbcube.fits"
doit
fi

if [ "$1" = "srgbcube" -o -z "$1" ]; then
initit "srgbcube"
testit "-srgbcube rgb.hdr rgb.arr"
doit
fi

if [ "$1" = "rgbimage" -o -z "$1" ]; then
initit "rgbimage"
testit "-rgbimage rgbimage.fits"
doit
fi

if [ "$1" = "rotate" -o -z "$1" ]; then
initit "rotate"
testit "-rotate open"
testit "-rotate to 30"
testit "-rotate 15"
testit "-rotate close"
testit "-frame reset"
doit
fi

if [ "$1" = "samp" ]; then
initit "samp"
testit "-samp no"
testit "-samp yes"
testit "-samp broadcast"
testit "-samp broadcast image"
testit "-samp broadcast table"
testit "-samp send topcat"
testit "-samp send table topcat"
doit
fi

if [ "$1" = "save" -o -z "$1" ]; then
initit "save"
testit "-save foo.fits"
testit "-save foo.fits image"
doit
rm -f foo.fits
fi

if [ "$1" = "saveimage" -o -z "$1" ]; then
initit "saveimage"
testit "-saveimage foo.fits"
testit "-saveimage foo.gif"
testit "-saveimage foo.tif"
testit "-saveimage foo.tif none"
testit "-saveimage foo.jpg"
testit "-saveimage foo.jpg 100"
testit "-saveimage foo.png"
testit "-saveimage foo.ppm"

# backward compatibility
testit "-saveimage fits foo.fits"
testit "-saveimage jpeg foo.jpg"
testit "-saveimage jpeg 100 foo.jpg"
testit "-saveimage tiff foo.tif"
testit "-saveimage tiff deflate foo.tif"
testit "-saveimage png foo.png"
testit "-saveimage ppm foo.ppm"
testit "-saveimage mpeg foo.mpg"

doit
rm -f foo.fits foo.jpg foo.tif foo.png foo.ppm foo.mpg
fi

if [ "$1" = "scale" -o -z "$1" ]; then
initit "scale"
testit "-scale open"
testit "-scale minmax"
testit "-scale linear"
testit "-scale log"
testit "-scale pow"
testit "-scale sqrt"
testit "-scale squared"
testit "-scale histequ"
testit "-scale log exp 1000"
testit "-scale log exp 10000"
testit "-linear"
testit "-log"
testit "-pow"
testit "-sqrt"
testit "-squared"
testit "-asinh"
testit "-sinh"
testit "-histequ"
testit "-scale linear"
testit "-scale minmax"
testit "-scale zscale"
testit "-scale zmax"
testit "-scale user"
testit "-scale mode minmax"
testit "-scale mode zscale"
testit "-scale mode zmax"
testit "-scale mode 95"
testit "-minmax"
testit "-zscale"
testit "-zmax"
testit "-scale minmax"
testit "-scale limits 0 100"
testit "-scale global"
testit "-scale local"
testit "-scale scope global"
testit "-scale scope local"
testit "-scale mode minmax"
testit "-scale linear"
testit "-scale zscale"
testit "-scale datasec yes"
testit "-scale match"
testit "-scale lock yes"
testit "-scale lock no"
testit "-scale close"
doit
fi

if [ "$1" = "single" -o -z "$1" ]; then
initit "single"
testit "-file hst.fits"
testit "-file img16.fits"
testit "-blink"
testit "-blink yes"
testit "-blink interval .5"
testit "-single"
testit "-tile"
testit "-tile yes"
testit "-tile row"
testit "-tile column"
testit "-tile grid"
testit "-single"
doit
fi

if [ "$1" = "skyview" -o -z "$1" ]; then
initit "skyview"
testit "-skyview open"
testit "-skyview close"
testit "-skyview survey sdssi"
testit "-skyview size 30 30 arcsec"
testit "-skyview save no"
testit "-skyview frame new"
testit "-skyview update frame"
testit "-skyview m3"
testit "-skyview name m51"
testit "-skyview name ''"
testit "-skyview coord 13:29:55.301 +47:11:37.73 sexagesimal"
testit "-skyview update frame"
testit "-mode crosshair"
testit "-skyview update crosshair"
testit "-skyview close"
testit "-mode pointer"
doit
fi

if [ "$1" = "sleep" -o -z "$1" ]; then
initit "sleep"
testit "-sleep"
testit "-sleep 2"
doit
fi

if [ "$1" = "slice" -o -z "$1" ]; then
initit "slice"
testit "-frame clear"
testit "-slice img*.fits"
testit "-frame clear"
testit "-photo -slice rose.*"
doit
fi

if [ "$1" = "smooth" -o -z "$1" ]; then
initit "smooth"
testit "-smooth open"
testit "-smooth"
testit "-smooth yes"
testit "-smooth function tophat"
testit "-smooth radius 5"
testit "-smooth no"
testit "-smooth close"
doit
fi

if [ "$1" = "source" -o -z "$1" ]; then
initit "source"
testit "-source source.tcl"
doit
fi

if [ "$1" = "tcl" -o -z "$1" ]; then
initit "tcl"
testit "-tcl yes"
doit
fi

if [ "$1" = "theme" -o -z "$1" ]; then
initit "theme"
testit "-theme native"
doit
fi

if [ "$1" = "threads" -o -z "$1" ]; then
initit "threads"
testit "-threads 8"
doit
fi

if [ "$1" = "title" -o -z "$1" ]; then
initit "title"
testit "-title foobar"
doit
fi

if [ "$1" = "unix" -o -z "$1" ]; then
initit "unix"
testit "-unix /tmp/.IMT%d"
testit "-unix_only"
doit
fi

if [ "$1" = "update" -o -z "$1" ]; then
initit "update"
testit "-update"
testit "-update 1 100 100 300 400"
testit "-update now"
testit "-update now 1 100 100 300 400"
testit "-update off"
testit "-update on"
doit
fi

if [ "$1" = "url" -o -z "$1" ]; then
initit "url"
testit "-frame clear"
testit "-url 'http://hea-www.harvard.edu/saord/download/ds9/data/img-32.fits'"
doit
fi

if [ "$1" = "version" -o -z "$1" ]; then
initit "version"
testit "-version"
doit
fi

if [ "$1" = "view" -o -z "$1" ]; then
initit "view"
testit "-frame delete"
testit "-view layout vertical"
testit "-view layout horizontal"
testit "-view info no"
testit "-view info yes"
testit "-view panner no"
testit "-view panner yes"
testit "-view magnifier no"
testit "-view magnifier yes"
testit "-view buttons no"
testit "-view buttons yes"
testit "-view colorbar no"
testit "-view colorbar yes"
testit "-view graph horizontal yes"
testit "-view graph horizontal no"
testit "-view graph vertical yes"
testit "-view graph vertical no"
testit "-view filename no"
testit "-view filename yes"
testit "-view object no"
testit "-view object yes"
testit "-view minmax yes"
testit "-view minmax no"
testit "-view lowhigh yes"
testit "-view lowhigh no"
testit "-view frame no"
testit "-view frame yes"
testit "-view wcs no"
testit "-view wcs yes"
testit "-view wcsa yes"
testit "-view wcsa no"
testit "-view detector yes"
testit "-view detector no"
testit "-view amplifier yes"
testit "-view amplifier no"
testit "-view physical no"
testit "-view physical yes"
testit "-view image no"
testit "-view image yes"
testit "-frame new rgb"
testit "-view red no"
testit "-view red yes"
testit "-view green no"
testit "-view green yes"
testit "-view blue no"
testit "-view blue yes"
doit
fi

if [ "$1" = "vo" -o -z "$1" ]; then
initit "vo"
testit "-vo method open"
testit "-vo method xpa"
testit "-vo server 'http://cxc.harvard.edu/chandraed/list.txt'"
testit "-vo internal yes"
testit "-vo delay 10"
testit "-vo connect foo"
testit "-vo chandra-ed"
testit "-vo disconnect chandra-ed"
testit "-vo method close"
testit "-web close"
doit
fi

if [ "$1" = "wcs" -o -z "$1" ]; then
initit "wcs"
testit "-wcs open"
testit "-wcs wcs"
testit "-wcs align yes"
testit "-wcs system wcs"
testit "-wcs sky galactic"
testit "-wcs skyformat sexagesimal"
testit "-wcs align no"
testit "-wcs sky fk5"
testit "-wcs skyformat degrees"
testit "-wcs append image.wcs"
testit "-wcs replace image.wcs"
testit "-wcs reset"
testit "-frame new"
testit "-mosaicimage wcs ds9_8amp_2x2.fits"
testit "-wcs append 2 linear.wcs"
testit "-wcs replace 2 linear.wcs"
testit "-wcs reset 2"
testit "-wcs close"
doit
fi

if [ "$1" = "web" -o -z "$1" ]; then
initit "web"
testit "-web hea-www.harvard.edu/RD/ds9/"
testit "-web hea-www.harvard.edu/RD/ds9/beta.html"
testit "-web hvweb click back"
testit "-web click forward"
testit "-web clear"
testit "-web close"
doit
fi

if [ "$1" = "width" -o -z "$1" ]; then
initit "width"
testit "-width 600"
doit
fi

if [ "$1" = "xpa" -o -z "$1" ]; then
initit "xpa"
testit "-xpa yes"
testit "-xpa local"
testit "-xpa noxpans"
doit
fi

if [ "$1" = "zscale" -o -z "$1" ]; then
initit "zscale"
testit "-zscale contrast .25"
testit "-zscale sample 600"
testit "-zscale line 120"
doit
fi

if [ "$1" = "zoom" -o -z "$1" ]; then
initit "zoom"
testit "-zoom open"
testit "-zoom 2"
testit "-zoom 2 4"
testit "-zoom to 4"
testit "-zoom to 2 4"
testit "-zoom to fit"
testit "-zoom close"
testit "-frame reset"
doit
fi

if [ "$1" = "exit" -o -z "$1" ]; then
initit "exit"
testit "-quit"
doit
fi

echo "DONE"
