#! /bin/sh

KillIt () {
    i=1
    while [ "$i" -le 15 ]; do
      sleep 1
      if [ `xpaaccess ds9` = yes ]; then
	  if [ $slow = "1" ]; then
	      sleep 1
	  fi
	  xpaset -p ds9 quit
	  break
      fi
      
      i=`expr $i + 1`
    done
}

DoXPA () {
    echo "$1"
    xpaset -p ds9 scale $4
    xpaset -p ds9 scale mode $5
    xpaset -p ds9 file $2 $3
    if [ $slow = "1" ]; then
	sleep 1
    fi
    xpaset -p ds9 frame clear
}

DoXPA2 () {
    echo "$1"
    xpaset -p ds9 scale $5
    xpaset -p ds9 scale mode $6
    cat $3 | xpaset ds9 $2 $4
    if [ $slow = "1" ]; then
	sleep 1
    fi
    xpaset -p ds9 frame clear
}

StartDS9 () {
    if [ `xpaaccess ds9` = no ]; then
	ds9&

	i=1
	while [ "$i" -le 30 ]
	    do
	    sleep 2
	    if [ `xpaaccess ds9` = yes ]; then
		break
	    fi

	    i=`expr $i + 1`
	done
    fi
}

# slow down?
slow=1
if [ "$1" = "slow" ]; then
    slow=1
    shift
fi

# Command Line

if [ "$1" = "command" -o  -z "$1" ]; then
echo "Testing Command Line File"

echo "..rgb array"
ds9 -rgbarray rgb.arr[dim=200,zdim=3,bitpix=8] &
KillIt

echo "..array"
ds9 -array 'array.arr[dim=512,bitpix=-32,arch=bigendian]' &
KillIt

echo "..array cube"
ds9 -array 'cube.arr[dim=512,zdim=3,bitpix=-32,arch=bigendian]' &
KillIt

echo "PASSED"
fi

# Stdin

if [ "$1" = "stdin" -o  -z "$1" ]; then
echo "Testing Stdin File"

echo "..array"
cat array.arr | ds9 -array '-[dim=512,bitpix=-32,arch=bigendian]' &
KillIt

echo "..array cube"
cat cube.arr | ds9 -array '-[dim=512,zdim=3,bitpix=-32,arch=bigendian]' &
KillIt

echo "..rgb array"
cat rgb.arr | ds9 -rgbarray -[dim=200,zdim=3,bitpix=8] &
KillIt

echo "PASSED"
fi

# XPA
if [ "$1" = "xpa" -o  -z "$1" ]; then
echo "Testing XPA File"

StartDS9

xpaset -p ds9 scale linear
xpaset -p ds9 scale mode minmax
xpaset -p ds9 rgb
DoXPA "..rgbarray" rgbarray rgb.arr[dim=200,zdim=3,bitpix=8] linear minmax
xpaset -p ds9 frame delete

DoXPA "..array" array 'array.arr[dim=512,bitpix=-32,arch=bigendian]' linear minmax
DoXPA "..array cube" array 'cube.arr[dim=512,zdim=3,bitpix=-32,arch=bigendian]' linear minmax

xpaset -p ds9 frame delete

xpaset -p ds9 quit
echo "PASSED"
fi

# XPA
if [ "$1" = "xpa2" -o  -z "$1" ]; then
echo "Testing XPA Fits"

StartDS9

echo "Testing Array"
DoXPA2 "..array" array array.arr 'array.arr[dim=512,bitpix=-32,arch=bigendian]' linear minmax
DoXPA2 "..array cube" array cube.arr 'arraycube.arr[dim=512,zdim=3,bitpix=-32,arch=bigendian]' linear minmax

xpaset -p ds9 scale linear
xpaset -p ds9 scale mode minmax
xpaset -p ds9 rgb
DoXPA2 "..array rgb" "array rgb" rgb.arr 'rgb.arr[dim=200,zdim=3,bitpix=8]' linear minmax
xpaset -p ds9 frame delete

xpaset -p ds9 quit
echo "PASSED"
fi

echo "DONE"
