#  Copyright (C) 1999-2012
#  Smithsonian Astrophysical Observatory, Cambridge, MA, USA
#  For conditions of distribution and use, see copyright notice in "copyright"

package provide DS9 1.0

proc APUpdateState {varname} {
    upvar #0 $varname var
    global $varname

    if {$var(data,total) > 0} {
	set nn $var(data,current)

	set var($nn,discrete) $var(discrete)
	set var($nn,discrete,symbol) $var(discrete,symbol)
	set var($nn,discrete,color) $var(discrete,color)

	set var($nn,linear) $var(linear)
	set var($nn,linear,width) $var(linear,width)
	set var($nn,linear,color) $var(linear,color)
	set var($nn,linear,dash) $var(linear,dash)

	set var($nn,step) $var(step)
	set var($nn,step,width) $var(step,width)
	set var($nn,step,color) $var(step,color)
	set var($nn,step,dash) $var(step,dash)

	set var($nn,quadratic) $var(quadratic)
	set var($nn,quadratic,width) $var(quadratic,width)
	set var($nn,quadratic,color) $var(quadratic,color)
	set var($nn,quadratic,dash) $var(quadratic,dash)

	set var($nn,error) $var(error)
	set var($nn,error,width) $var(error,width)
	set var($nn,error,color) $var(error,color)
	set var($nn,error,style) $var(error,style)
    }
    APUpdateElement $varname
}

proc APNextColor {which} {
    switch -- $which {
	black {return white}
	white {return black}
	red {return green}
	green {return blue}
	blue {return red}
	cyan {return magenta}
	magenta {return yellow}
	yellow {return cyan}
    }
}

proc APPing {varname} {
    upvar #0 $varname var
    global $varname

    if {[info exists var(top)]} {
	if {[winfo exists $var(top)]} {
	    return 1
	}
    }
    return 0
}

proc APRaise {varname} {
    upvar #0 $varname var
    global $varname

    if {[APPing $varname]} {
	raise $var(top)
    }
}

proc APDataSet {varname dim data} {
    upvar #0 $varname var
    global $varname

    switch -- $dim {
	4 {
	    # first data set
	    APOneDataSet $varname "4.1" $data

	    # set color
	    set dc $var(discrete,color)
	    set lc $var(linear,color)
	    set sc $var(step,color)
	    set qc $var(quadratic,color)

	    set var(discrete,color) [APNextColor $var(discrete,color)]
	    set var(linear,color) [APNextColor $var(linear,color)]
	    set var(step,color) [APNextColor $var(step,color)]
	    set var(quadratic,color) [APNextColor $var(quadratic,color)]

	    # second data set
	    APOneDataSet $varname "4.2" $data

	    # rest colors
	    set var(discrete,color) $dc
	    set var(linear,color) $lc
	    set var(step,color) $sc
	    set var(quadratic,color) $qc
	}
	5 {
	    # first data set
	    APOneDataSet $varname "5.1" $data

	    # set color
	    set dc $var(discrete,color)
	    set lc $var(linear,color)
	    set sc $var(step,color)
	    set qc $var(quadratic,color)

	    set var(discrete,color) [APNextColor $var(discrete,color)]
	    set var(linear,color) [APNextColor $var(linear,color)]
	    set var(step,color) [APNextColor $var(step,color)]
	    set var(quadratic,color) [APNextColor $var(quadratic,color)]

	    # second data set
	    APOneDataSet $varname "5.2" $data

	    # rest colors
	    set var(discrete,color) $dc
	    set var(linear,color) $lc
	    set var(step,color) $sc
	    set var(quadratic,color) $qc
	}
	default {APOneDataSet $varname $dim $data}
    }

    APStats $varname
}

proc APOneDataSet {varname dim data} {
    upvar #0 $varname var
    global $varname

    # look for no data
    if {[string length $data] == 0} {
	return
    }

    # incr count
    incr ${varname}(data,total) 
    set nn $var(data,total)
    set var(data,current) $nn

    # new vectors
    set var(xdata) ap${varname}xx${nn}
    set var(ydata) ap${varname}yy${nn}
    set var(xedata) ap${varname}xe${nn}
    set var(yedata) ap${varname}ye${nn}

    global $var(xdata) $var(ydata) $var(xedata) $var(yedata)

    blt::vector create $var(xdata) $var(ydata) \
	$var(xedata) $var(yedata)

    # substitute all separtors
    regsub -all {[\n\r\t, ]+} $data { } data
    # remove all non-numeric data
    regsub -all {[^0-9.e\- ]+} $data {} data

    set l [llength $data]
    switch -- $dim {
	2 -
	xy {
	    set x {}
	    set y {}
	    for {set i 0} {$i<$l} {incr i 2} {
		lappend x [lindex $data $i]
		lappend y [lindex $data [expr $i+1]]
	    }
	    $var(xdata) set $x
	    $var(ydata) set $y
	}

	xyex {
	    set x {}
	    set y {}
	    set xe {}
	    for {set i 0} {$i<$l} {incr i 3} {
		lappend x [lindex $data $i]
		lappend y [lindex $data [expr $i+1]]
		lappend xe [lindex $data [expr $i+2]]
	    }
	    $var(xdata) set $x
	    $var(ydata) set $y
	    $var(xedata) set $xe
	}

	3 -
	xyey {
	    set x {}
	    set y {}
	    set ye {}
	    for {set i 0} {$i<$l} {incr i 3} {
		lappend x [lindex $data $i]
		lappend y [lindex $data [expr $i+1]]
		lappend ye [lindex $data [expr $i+2]]
	    }
	    $var(xdata) set $x
	    $var(ydata) set $y
	    $var(yedata) set $ye
	}

	xyexey {
	    set x {}
	    set y {}
	    set xe {}
	    set ye {}
	    for {set i 0} {$i<$l} {incr i 4} {
		lappend x [lindex $data $i]
		lappend y [lindex $data [expr $i+1]]
		lappend xe [lindex $data [expr $i+2]]
		lappend ye [lindex $data [expr $i+3]]
	    }
	    $var(xdata) set $x
	    $var(ydata) set $y
	    $var(xedata) set $xe
	    $var(yedata) set $ye
	}

	4.1 {
	    set x {}
	    set y {}
	    set ye {}
	    for {set i 0} {$i<$l} {incr i 4} {
		lappend x [lindex $data $i]
		lappend y [lindex $data [expr $i+1]]
		lappend ye [lindex $data [expr $i+2]]
	    }
	    $var(xdata) set $x
	    $var(ydata) set $y
	    $var(yedata) set $ye
	}

	4.2 {
	    set x {}
	    set y {}
	    for {set i 0} {$i<$l} {incr i 4} {
		lappend x [lindex $data $i]
		lappend y [lindex $data [expr $i+3]]
	    }
	    $var(xdata) set $x
	    $var(ydata) set $y
	}

	5.1 {
	    set x {}
	    set y {}
	    set ye {}
	    for {set i 0} {$i<$l} {incr i 5} {
		lappend x [lindex $data $i]
		lappend y [lindex $data [expr $i+1]]
		lappend ye [lindex $data [expr $i+2]]
	    }
	    $var(xdata) set $x
	    $var(ydata) set $y
	    $var(yedata) set $ye
	}

	5.2 {
	    set x {}
	    set y {}
	    set ye {}
	    for {set i 0} {$i<$l} {incr i 5} {
		lappend x [lindex $data $i]
		lappend y [lindex $data [expr $i+3]]
		lappend ye [lindex $data [expr $i+4]]
	    }
	    $var(xdata) set $x
	    $var(ydata) set $y
	    $var(yedata) set $ye
	}

    }

    # set menu options
    set var($nn,manage) 1
    set var($nn,xdata) $var(xdata) 
    set var($nn,ydata) $var(ydata) 
    set var($nn,xedata) $var(xedata) 
    set var($nn,yedata) $var(yedata) 

    set var($nn,discrete) $var(discrete) 
    set var($nn,discrete,symbol) $var(discrete,symbol) 
    set var($nn,discrete,color) $var(discrete,color) 

    set var($nn,linear) $var(linear) 
    set var($nn,linear,width) $var(linear,width) 
    set var($nn,linear,color) $var(linear,color) 
    set var($nn,linear,dash) $var(linear,dash) 

    set var($nn,step) $var(step) 
    set var($nn,step,width) $var(step,width) 
    set var($nn,step,color) $var(step,color) 
    set var($nn,step,dash) $var(step,dash) 

    set var($nn,quadratic) $var(quadratic) 
    set var($nn,quadratic,width) $var(quadratic,width) 
    set var($nn,quadratic,color) $var(quadratic,color) 
    set var($nn,quadratic,dash) $var(quadratic,dash) 

    set var($nn,error) $var(error) 
    set var($nn,error,width) $var(error,width) 
    set var($nn,error,color) $var(error,color) 
    set var($nn,error,style) $var(error,style) 

    # update data set menu
    $var(mb).dataset add radiobutton -label "[msgcat::mc {Dataset}] $nn" \
	-variable ${varname}(data,current) -value $nn \
	-command "APCurrentData $varname"

    APUpdateGraph $varname
    APUpdateElement $varname
}

proc APExternal {varname} {
    upvar #0 $varname var
    global $varname

    # incr count
    incr ${varname}(data,total) 
    set nn $var(data,total)
    set var(data,current) $nn

    # set menu options
    set var($nn,manage) 0
    set var($nn,xdata) $var(xdata) 
    set var($nn,ydata) $var(ydata) 
    set var($nn,xedata) $var(xedata) 
    set var($nn,yedata) $var(yedata) 

    set var($nn,discrete) $var(discrete) 
    set var($nn,discrete,symbol) $var(discrete,symbol) 
    set var($nn,discrete,color) $var(discrete,color) 

    set var($nn,linear) $var(linear) 
    set var($nn,linear,width) $var(linear,width) 
    set var($nn,linear,color) $var(linear,color) 
    set var($nn,linear,dash) $var(linear,dash) 

    set var($nn,step) $var(step) 
    set var($nn,step,width) $var(step,width) 
    set var($nn,step,color) $var(step,color) 
    set var($nn,step,dash) $var(step,dash) 

    set var($nn,quadratic) $var(quadratic) 
    set var($nn,quadratic,width) $var(quadratic,width) 
    set var($nn,quadratic,color) $var(quadratic,color) 
    set var($nn,quadratic,dash) $var(quadratic,dash) 

    set var($nn,error) $var(error) 
    set var($nn,error,width) $var(error,width) 
    set var($nn,error,color) $var(error,color) 
    set var($nn,error,style) $var(error,style) 

    # update data set menu
    $var(mb).dataset add radiobutton -label "[msgcat::mc {Dataset}] $nn" \
	-variable ${varname}(data,current) -value $nn \
	-command "APCurrentData $varname"

    APUpdateGraph $varname
    APUpdateElement $varname
}

proc APUpdateGraph {varname} {
    upvar #0 $varname var
    global $varname

    global ds9

    switch -- $var(grid,log) {
	linearlinear {set xlog false; set ylog false}
	linearlog {set xlog false; set ylog true}
	loglinear {set xlog true; set ylog false}
	loglog {set xlog true; set ylog true}
    }

    if {$var(graph,x,auto)} {
	set xmin {}
	set xmax {}
    } else {
	set xmin $var(graph,x,min)
	set xmax $var(graph,x,max)
    }

    if {$var(graph,y,auto)} {
	set ymin {}
	set ymax {}
    } else {
	set ymin $var(graph,y,min)
	set ymax $var(graph,y,max)
    }

    $var(graph) configure -plotpadx 0 -plotpady 0 \
	-title $var(graph,title) \
	-font "{$ds9($var(titleFont))} $var(titleSize) $var(titleWeight) $var(titleSlant)"
    $var(graph) xaxis configure -grid $var(grid) -logscale $xlog \
	-min $xmin -max $xmax -title $var(graph,xaxis) \
	-tickfont "{$ds9($var(numlabFont))} $var(numlabSize) $var(numlabWeight) $var(numlabSlant)" \
	-titlefont "{$ds9($var(textlabFont))} $var(textlabSize) $var(textlabWeight) $var(textlabSlant)"
    $var(graph) yaxis configure -grid $var(grid) -logscale $ylog \
	-min $ymin -max $ymax -title $var(graph,yaxis) \
	-tickfont "{$ds9($var(numlabFont))} $var(numlabSize) $var(numlabWeight) $var(numlabSlant)" \
	-titlefont "{$ds9($var(textlabFont))} $var(textlabSize) $var(textlabWeight) $var(textlabSlant)"

    if {$var(format)} {
	if {$var(format,x) != {}} {
	    $var(graph) xaxis configure -command [list APAxisFormat $varname x]
	} else {
	    $var(graph) xaxis configure -command {}
	}
	if {$var(format,y) != {}} {
	    $var(graph) yaxis configure -command [list APAxisFormat $varname y]
	} else {
	    $var(graph) yaxis configure -command {}
	}
    }

    # windows: we're on top of the image window, so set focus to this window
    global ds9
    switch $ds9(wm) {
	x11 {}
	win32 {focus $var(top)}
	aqua {}
    }
}

proc APUpdateElement {varname} {
    upvar #0 $varname var
    global $varname

    # warning: uses current vars
    if {$var(data,total) == 0} {
	return
    }

    global $var(xdata) $var(ydata) $var(xedata) $var(yedata)

    set nn $var(data,current)
    # create data elements
    foreach el [$var(graph) element names] {
	set f [split $el -]
	if {[lindex $f 1] == $nn} {
	    $var(graph) element delete $el
	}
    }

    if {$var(discrete)} {
	$var(graph) element create "d1-${nn}" \
	    -linewidth 0 -fill {} -pixels 5 \
	    -xdata $var(xdata) -ydata $var(ydata) \
	    -trace increasing \
	    -symbol $var(discrete,symbol) \
	    -outline $var(discrete,color) \
	    -color $var(discrete,color)
    }
    if {$var(linear)} {
	if {$var(linear,dash) == {yes}} {
	    set dash {8 3}
	} else {
	    set dash { }
	}
	$var(graph) element create "d2-${nn}" \
	    -smooth linear -symbol {} \
	    -xdata $var(xdata) -ydata $var(ydata) \
	    -trace increasing \
	    -linewidth $var(linear,width) \
	    -color $var(linear,color) \
	    -dashes $dash
    }
    if {$var(step)} {
	if {$var(step,dash) == {yes}} {
	    set dash {8 3}
	} else {
	    set dash { }
	}
	$var(graph) element create "d3-${nn}" \
	    -smooth step -symbol {} \
	    -xdata $var(xdata) -ydata $var(ydata) \
	    -trace increasing \
	    -linewidth $var(step,width) \
	    -color $var(step,color) \
	    -dashes $dash
    }
    if {$var(quadratic)} {
	if {$var(quadratic,dash) == {yes}} {
	    set dash {8 3}
	} else {
	    set dash { }
	}
	$var(graph) element create "d4-${nn}" \
	    -smooth quadratic -symbol {} \
	    -xdata $var(xdata) -ydata $var(ydata) \
	    -trace increasing \
	    -linewidth $var(quadratic,width) \
	    -color $var(quadratic,color) \
	    -dashes $dash
    }

    # yerror
    if {$var(error) && 
	[$var(yedata) length] > 0} {

	set min [expr "$$var(xdata)\(min\)"]
	set max [expr "$$var(xdata)\(max\)"]
	set errdelt [expr ($max-$min)*.0125]

	set err1 {}
	set err2 {}
	set err3 {}

	set l [$var(yedata) length]
	for {set i 0} {$i<$l} {incr i} {
	    set x [expr "$$var(xdata)\($i\)"]
	    set y [expr "$$var(ydata)\($i\)"]
	    set e [expr "$$var(yedata)\($i\)"]

	    append err1  "$x [expr $y-$e] $x [expr $y+$e] "
	    append err2  \
	    "[expr $x+$errdelt] [expr $y+$e] [expr $x-$errdelt] [expr $y+$e] "
	    append err3  \
	    "[expr $x+$errdelt] [expr $y-$e] [expr $x-$errdelt] [expr $y-$e] "
	}

	$var(graph) element create "err1-${nn}" \
	    -smooth linear -symbol {} \
	    -data $err1 \
	    -trace decreasing \
	    -linewidth $var(error,width) \
	    -color $var(error,color)
	if {$var(error,style) == 2} {
	    $var(graph) element create "err2-${nn}" \
		-smooth linear -symbol {} \
		-data $err2 \
		-trace decreasing \
		-linewidth $var(error,width) \
		-color $var(error,color)
	    $var(graph) element create "err3-${nn}" \
		-smooth linear -symbol {} \
		-data $err3 \
		-trace decreasing \
		-linewidth $var(error,width) \
		-color $var(error,color)
	}
    }

    # xerror
    if {$var(error) && 
	[$var(xedata) length] > 0} {

	set min [expr "$$var(ydata)\(min\)"]
	set max [expr "$$var(ydata)\(max\)"]
	set errdelt [expr ($max-$min)*.0125]

	set err4 {}
	set err5 {}
	set err6 {}

	set l [$var(xedata) length]
	for {set i 0} {$i<$l} {incr i} {
	    set x [expr "$$var(xdata)\($i\)"]
	    set y [expr "$$var(ydata)\($i\)"]
	    set e [expr "$$var(xedata)\($i\)"]

	    append err4 "[expr $x+$e] $y [expr $x-$e] $y "
	    append err5 \
	    "[expr $x-$e] [expr $y+$errdelt] [expr $x-$e] [expr $y-$errdelt] "
	    append err6 \
	    "[expr $x+$e] [expr $y+$errdelt] [expr $x+$e] [expr $y-$errdelt] "
	}

	$var(graph) element create "err4-${nn}" \
	    -smooth linear -symbol {} \
	    -trace decreasing \
	    -data $err4 \
	    -linewidth $var(error,width) \
	    -color $var(error,color)
	if {$var(error,style) == 2} {
	    $var(graph) element create "err5-${nn}" \
		-smooth linear -symbol {} \
		-data $err5 \
		-trace decreasing \
		-linewidth $var(error,width) \
		-color $var(error,color)
	    $var(graph) element create "err6-${nn}" \
		-smooth linear -symbol {} \
		-data $err6 \
		-trace decreasing \
		-linewidth $var(error,width) \
		-color $var(error,color)
	}
    }
}

