// Copyright (C) 1999-2012
// Smithsonian Astrophysical Observatory, Cambridge, MA, USA
// For conditions of distribution and use, see copyright notice in "copyright"

#ifndef __fitscompress_h__
#define __fitscompress_h__

#include "file.h"

class FitsCompress : public FitsFile {
 protected:
  int bitpix_;
  int width_;
  int height_;
  int depth_;
  int ww_;
  int hh_;
  int dd_;
  double bscale_;
  double bzero_;
  unsigned int blank_;
  char* zmaskcmp_;
  
  off_t tilesize_;
  off_t size_;

  FitsColumn* compress_;
  FitsColumn* uncompress_;
  FitsColumn* zscale_;
  FitsColumn* zzero_;
  FitsColumn* zblank_;
  FitsColumn* null_;

  int hasScaling_;
  int hasBlank_;

 protected:
  int initHeader(FitsFile*);

 public:
  FitsCompress(FitsFile*);
  virtual ~FitsCompress();
};

template<class T>
class FitsCompressm : public FitsCompress {
 private:
  int inflate(FitsFile*);
  void swapBytes();

 protected:
  T swap(T* ptr);

 protected:
  void uncompress(FitsFile* fits);
  virtual int compressed(T*, char*, char*, int, int, int, int, int, int) =0;
  T getValue(char*, double, double, int);
  T getValue(short*, double, double, int);
  T getValue(int*, double, double, int);
  T getValue(long long*, double, double, int);
  T getValue(float*, double, double, int);
  T getValue(double*, double, double, int);
  
 public:
  FitsCompressm(FitsFile*);
};

class FitsCompressNext : public FitsFile {
public:
  FitsCompressNext(FitsFile* prev);
};

#endif

