// Copyright (C) 1999-2005
// Smithsonian Astrophysical Observatory, Cambridge, MA, USA
// For conditions of distribution and use, see copyright notice in "copyright"

#ifndef __point_h__
#define __point_h__

#include "marker.h"

class Point : public Marker {
 protected:
  char pointtype[16];

 protected:
  virtual void render(Drawable, const Matrix&, RenderMode);
  void setLineDash();
  void psLineDash();

 public:
  Point(const Point&);
  Point(FrameBase* p, const Vector& ctr, 
	const char* clr, int wth, const char* fnt, const char* txt,
	unsigned short prop, const char* cmt,
	const List<Tag>& tg, const List<CallBack>& cb);

  virtual Marker* dup() =0;
  void updateBBox();

  void editBegin(int) {}
  void edit(const Vector& v, int h) {}
  void editEnd() {}

  void rotateBegin() {}
  void rotate(const Vector& v, int h) {}
  void rotateEnd() {}

  virtual void ps(int);

  void list(ostream&, CoordSystem, SkyFrame, SkyFormat, int, int);
  void listPost(ostream&, int, int);
  void listCiao(ostream&, CoordSystem, int, int);
  void listPros(ostream&, CoordSystem, SkyFrame, SkyFormat, int);
  void listSAOtng(ostream&, CoordSystem, SkyFrame, SkyFormat, int);
  void listSAOimage(ostream&, int);
};

class CirclePoint : public Point {
 private:
  void render(Drawable, const Matrix&, RenderMode);

 public:
  CirclePoint(const CirclePoint&);
  CirclePoint(FrameBase* p, const Vector& ctr, 
	      const char* clr, int wth, 
	      const char* fnt, const char* txt,
	      unsigned short prop, const char* cmt,
	      const List<Tag>& tg, const List<CallBack>& cb);

  Marker* dup() {return new CirclePoint(*this);}
  void ps(int);
};

class BoxPoint : public Point {
 private:
  void render(Drawable, const Matrix&, RenderMode);

 public:
  BoxPoint(const BoxPoint&);
  BoxPoint(FrameBase* p, const Vector& ctr, 
	   const char* clr, int wth, 
	   const char* fnt, const char* txt,
	   unsigned short prop, const char* cmt,
	   const List<Tag>& tg, const List<CallBack>& cb);

  Marker* dup() {return new BoxPoint(*this);}
  void ps(int);
};

class DiamondPoint : public Point {
 private:
  void render(Drawable, const Matrix&, RenderMode);

 public:
  DiamondPoint(const DiamondPoint&);
  DiamondPoint(FrameBase* p, const Vector& ctr, 
	       const char* clr, int wth, 
	       const char* fnt, const char* txt,
	       unsigned short prop, const char* cmt,
	       const List<Tag>& tg, const List<CallBack>& cb);

  Marker* dup() {return new DiamondPoint(*this);}
  void ps(int);
};

class CrossPoint : public Point {
 private:
  void render(Drawable, const Matrix&, RenderMode);

 public:
  CrossPoint(const CrossPoint&);
  CrossPoint(FrameBase* p, const Vector& ctr, 
	     const char* clr, int wth, 
	     const char* fnt, const char* txt,
	     unsigned short prop, const char* cmt,
	     const List<Tag>& tg, const List<CallBack>& cb);

  Marker* dup() {return new CrossPoint(*this);}
  void ps(int);
};

class ExPoint : public Point {
 private:
  void render(Drawable, const Matrix&, RenderMode);

 public:
  ExPoint(const ExPoint&);
  ExPoint(FrameBase* p, const Vector& ctr, 
	  const char* clr, int wth, 
	  const char* fnt, const char* txt,
	  unsigned short prop, const char* cmt,
	  const List<Tag>& tg, const List<CallBack>& cb);

  Marker* dup() {return new ExPoint(*this);}
  void ps(int);
};

class ArrowPoint : public Point {
 private:
  void render(Drawable, const Matrix&, RenderMode);

 public:
  ArrowPoint(const ArrowPoint&);
  ArrowPoint(FrameBase* p, const Vector& ctr, 
	     const char* clr, int wth, 
	     const char* fnt, const char* txt,
	     unsigned short prop, const char* cmt,
	     const List<Tag>& tg, const List<CallBack>& cb);

  Marker* dup() {return new ArrowPoint(*this);}
  void ps(int);
};

class BoxCirclePoint : public Point {
 private:
  void render(Drawable, const Matrix&, RenderMode);

 public:
  BoxCirclePoint(const BoxCirclePoint&);
  BoxCirclePoint(FrameBase* p, const Vector& ctr, 
		 const char* clr, int wth, 
		 const char* fnt, const char* txt,
		 unsigned short prop, const char* cmt,
		 const List<Tag>& tg, const List<CallBack>& cb);

  Marker* dup() {return new BoxCirclePoint(*this);}
  void ps(int);
};

#endif
