// Copyright (C) 1999-2005
// Smithsonian Astrophysical Observatory, Cambridge, MA, USA
// For conditions of distribution and use, see copyright notice in "copyright"

#include "coord.h"

char *coordSystemStr_[] = {
  "image",
  "physical",
  "amplifier",
  "detector",
  "wcs",
  "wcsA",
  "wcsB",
  "wcsC",
  "wcsD",
  "wcsE",
  "wcsF",
  "wcsG",
  "wcsH",
  "wcsI",
  "wcsJ",
  "wcsK",
  "wcsL",
  "wcsM",
  "wcsN",
  "wcsO",
  "wcsP",
  "wcsQ",
  "wcsR",
  "wcsS",
  "wcsT",
  "wcsU",
  "wcsV",
  "wcsW",
  "wcsX",
  "wcsY",
  "wcsZ",
  "wcs0"
};

char *skyFrameStr_[] = { 
  "fk4",
  "fk5",
  "icrs",
  "galactic",
  "ecliptic"
};

char *skyFormatStr_[] = { 
  "degrees",
  "sexagesimal",
  "hms",
  "arcmin",
  "arcsec"
};

void listCoordSystem(ostream& str, CoordSystem sys, SkyFrame sky, int wcsequ)
{
  switch (sys) {
  case IMAGE:
    str << "image";
    return;
  case PHYSICAL:
    str << "physical";
    return;
  case DETECTOR:
    str << "detector";
    return;
  case AMPLIFIER:
    str << "amplifier";
    return;
  default:
    {
      if (sys == WCS0)
	str << "wcs0" << ';';
      else if (sys > WCS)
	str << "wcs" << (char)(sys-WCS+'`') << ';';

      if (wcsequ)
	switch (sky) {
	case FK4:
	  str << "fk4";
	  return;
	case FK5:
	  str << "fk5";
	  return;
	case ICRS:
	  str << "icrs";
	  return;
	case GALACTIC:
	  str << "galactic";
	  return;
	case ECLIPTIC:
	  str << "ecliptic";
	  return;
	}
      else {
	str << "linear";
	return;
      }
    }
  }
}

void listDistSystem(ostream& str, CoordSystem sys, SkyFormat format, 
		    int wcsequ)
{
  switch (sys) {
  case IMAGE:
    str << "image";
    return;
  case PHYSICAL:
    str << "physical";
    return;
  case DETECTOR:
    str << "detector";
    return;
  case AMPLIFIER:
    str << "amplifier";
    return;
  default:
    if (wcsequ)
      switch (format) {
      case DEGREES:
	str << "degrees";
	return;
      case ARCMIN:
	str << "arcmin";
	return;
      case ARCSEC:
	str << "arcsec";
	return;
      }
    else {
      str << "pixels";
      return;
    }
  }
}

void listProsCoordSystem(ostream& str, CoordSystem sys, SkyFrame sky)
{
  switch (sys) {
  case IMAGE:
    str << "logical";
    return;
  case PHYSICAL:
    str << "physical";
    return;
  case DETECTOR:
    str << "detector";
    return;
  case AMPLIFIER:
    str << "amplifier";
    return;
  default:
    switch (sky) {
    case FK4:
      str << "b1950";
      return;
    case FK5:
      str << "j2000";
      return;
    case ICRS:
      str << "icrs";
      return;
    case GALACTIC:
      str << "galactic";
      return;
    case ECLIPTIC:
      str << "ecliptic";
      return;
    default:
      str << "linear";
      return;
    }
  }
}

