// Copyright (C) 1999-2005
// Smithsonian Astrophysical Observatory, Cambridge, MA, USA
// For conditions of distribution and use, see copyright notice in "copyright"

#ifndef __contour_h__
#define __contour_h__

#include "vector.h"
#include "list.h"
#include "contourscale.h"

class FitsImage;
class FrameBase;

static char *methodName[] = { 
  "smooth",
  "block"
};

class Contour {
 public:
  enum Method {SMOOTH, BLOCK};

 protected:
  FrameBase* parent;
  List<Vertex> contours_;

  char* colorName;
  int color;
  int lineWidth;

  ContourScale* scale;
  Method method;

  Contour* previous_;
  Contour* next_;

 public:
  Contour(FrameBase*, const char*, int, int);
  Contour(FrameBase*, const char*, int, const List<Vertex>&);
  virtual ~Contour();

  void render(Pixmap, const Matrix&, const BBox&);
  void ps(int);
  const List<Vertex>& contours() {return contours_;}
  void updateCoords(const Matrix&);

  const char* getColorName() {return colorName;}
  void setColor(const char*);

  void setLineWidth(int);
  int getLineWidth() {return lineWidth;}

  virtual void append(FitsImage*) {}
  ContourScale* getScale() {return scale;}

  int getMethod() {return method;}
  const char* getMethodName() {return methodName[method];}

  Contour* previous() {return previous_;}
  void setPrevious(Contour* m) {previous_ = m;}
  Contour* next() {return next_;}
  void setNext(Contour* m) {next_ = m;}
};

#endif




