// Copyright (C) 1999-2004
// Smithsonian Astrophysical Observatory, Cambridge, MA, USA
// For conditions of distribution and use, see copyright notice in "copyright"

#ifndef __ellipse_h__
#define __ellipse_h__

#include "baseellipse.h"

class Ellipse : public BaseEllipse {
private:
  void updateHandles();

public:
  Ellipse(const Ellipse&);
  Ellipse(FrameBase* p, const Vector& ctr, const Vector& r, double a,
	  const char* clr,  int w, const char* f, 
	  const char* t, unsigned short prop, const char* c,
	  const List<Tag>& tag);

  Marker* dup() {return new Ellipse(*this);}
  void edit(const Vector&, int);

  const Vector& getRadius() {return radii[0];}
  void setRadius(const Vector&);

  void list(ostream&, CoordSystem, SkyFrame, SkyFormat, char);
  void listCiao(ostream&, CoordSystem, SkyFrame, SkyFormat, char);
  void listSAOtng(ostream&, CoordSystem, SkyFrame, SkyFormat, char);
  void listSAOimage(ostream&, CoordSystem, SkyFrame, SkyFormat, char);
  void listPros(ostream&, CoordSystem, SkyFrame, SkyFormat, char);
};

#endif


