// Copyright (C) 1999-2004
// Smithsonian Astrophysical Observatory, Cambridge, MA, USA
// For conditions of distribution and use, see copyright notice in "copyright"

#ifndef __annulus_h__
#define __annulus_h__

#include "basecircle.h"

class Annulus : public BaseCircle {
 protected:
  void sortRadii();

 public:
  Annulus(FrameBase* p, const Vector& ctr, 
	  double start, double stop, int num,
	  const char* clr, int w, const char* f, 
	  const char* t, unsigned short prop, const char* c, 
	  const List<Tag>& tag);

  Annulus(FrameBase* p, const Vector& ctr, double* r, int n,
	  const char* clr, int w, const char* f, 
	  const char* t, unsigned short prop, const char* c,
	  const List<Tag>& tag);

  Annulus(const Annulus&);

  Marker* dup() {return new Annulus(*this);}
  void updateBBox();
  void edit(const Vector&, int);
  void editEnd();

  void setRadii(double, double, int);
  void setRadii(const double*, int);
  const double* getRadii() {return radii;}
  int addRadii(const Vector&);
  void deleteRadii(int h);

  void list(ostream&, CoordSystem, SkyFrame, SkyFormat, char);
  void listCiao(ostream&, CoordSystem, SkyFrame, SkyFormat, char);
  void listSAOimage(ostream&, CoordSystem, SkyFrame, SkyFormat, char);
  void listPros(ostream&, CoordSystem, SkyFrame, SkyFormat, char);
};

#endif
