// Copyright (C) 1999-2004
// Smithsonian Astrophysical Observatory, Cambridge, MA, USA
// For conditions of distribution and use, see copyright notice in "copyright"

#include <stdlib.h>
#include <limits.h>

#include "lut.h"

// LUTColorMap

LUTColorMap::LUTColorMap()
{
  size = 0;
  colors = NULL;
}

LUTColorMap::~LUTColorMap()
{
  if (colors)
    delete [] colors;
}

int LUTColorMap::load()
{
  // Determine if we can read the file
  {
    ifstream f(fileName);
    if (!f)
      return 0;
  
    // Figure out the number of colors

    float junk;
    while (1) {
      for (int i=0; i<3; i++)
	f >> junk;
      if (f.eof())
	break;
      size++;
    }
    f.close();
  }

  // allocate space for our colors
  colors = new RGBColor[size];

  // and read the colors
  {
    ifstream f(fileName);
    for (int i=0; i<size; i++)
      f >> colors[i];
    f.close();
  }

  return 1;
}

int LUTColorMap::save(const char* fn)
{
  ofstream f(fn);
  if (!f)
    return 0;

  f << *this;

  return 1;
}

unsigned char LUTColorMap::getRedChar(int i, int count)
{
  int index = (int)((i * size / count) + .5);
  if (index >=0 && index < size)
    return (unsigned char)(colors[index].getRed() * UCHAR_MAX);
  else
    return 0;
}

unsigned char LUTColorMap::getGreenChar(int i, int count)
{
  int index = (int)((i * size / count) + .5);
  if (index >=0 && index < size)
    return (unsigned char)(colors[index].getGreen() * UCHAR_MAX);
  else
    return 0;
}

unsigned char LUTColorMap::getBlueChar(int i, int count)
{
  int index = (int)((i * size / count) + .5);
  if (index >=0 && index < size)
    return (unsigned char)(colors[index].getBlue() * UCHAR_MAX);
  else
    return 0;
}

unsigned short LUTColorMap::getRedShrt(int i, int count)
{
  int index = (int)((i * size / count) + .5);
  if (index >=0 && index < size)
    return (unsigned short)(colors[index].getRed() * USHRT_MAX);
  else
    return 0;
}

unsigned short LUTColorMap::getGreenShrt(int i, int count)
{
  int index = (int)((i * size / count) + .5);
  if (index >=0 && index < size)
    return (unsigned short)(colors[index].getGreen() * USHRT_MAX);
  else
    return 0;
}

unsigned short LUTColorMap::getBlueShrt(int i, int count)
{
  int index = (int)((i * size / count) + .5);
  if (index >=0 && index < size)
    return (unsigned short)(colors[index].getBlue() * USHRT_MAX);
  else
    return 0;
}

ostream& operator<<(ostream& s, LUTColorMap& c)
{
  if (c.colors)
    for (int i=0; i<c.size; i++)
      s << c.colors[i];

  return s;
}
