#! /bin/sh

if [ "$2" = "val" ]; then
#    CMD="valgrind --leak-check=yes --show-reachable=yes ../ds9val"
    CMD="valgrind --leak-check=yes ../ds9val"
    XPA=ds9val
else
    CMD=../ds9
    XPA=ds9
fi

KillIt () {
    i=1
    while [ "$i" -le 15 ]
    do
        sleep 1
        if [ `xpaaccess $XPA` = yes ]
        then
	    sleep 1
	    xpaset -p $XPA quit
	    break
        fi

        i=`expr $i + 1`
    done
}

StartDS9 () {
    if [ `xpaaccess $XPA` = no ]; then
	$CMD&

	i=1
	while [ "$i" -le 30 ]
	    do
	    sleep 2
	    if [ `xpaaccess $XPA` = yes ]; then
		break
	    fi

	    i=`expr $i + 1`
	done
    fi
}

# Fits

if [ "$1" = "fits" -o  -z "$1" ]; then
echo "Testing Fits"

StartDS9
xpaset -p $XPA scale zscale

echo "..Bitpix = 8"
xpaset -p $XPA file fits img8.fits
sleep 1
xpaset -p $XPA frame clear

echo "..Bitpix = 16"
xpaset -p $XPA file fits img16.fits
sleep 1
xpaset -p $XPA frame clear

echo "..Bitpix = 32"
xpaset -p $XPA file fits img32.fits
sleep 1
xpaset -p $XPA frame clear

echo "..Bitpix = -32"
xpaset -p $XPA file fits img-32.fits
sleep 1
xpaset -p $XPA frame clear

echo "..Bitpix = -64"
xpaset -p $XPA file fits img-64.fits
sleep 1
xpaset -p $XPA frame clear

echo "..BSCALE"
xpaset -p $XPA file fits imgbscale.fits
sleep 1
xpaset -p $XPA frame clear

echo "..BLANK"
xpaset -p $XPA file fits imgblank.fits
sleep 1
xpaset -p $XPA frame clear

echo "..NaN"
xpaset -p $XPA file fits imgnan.fits
sleep 1
xpaset -p $XPA frame clear

echo "..INF"
xpaset -p $XPA file fits imginf.fits
sleep 1
xpaset -p $XPA frame clear

xpaset -p $XPA quit
echo "PASSED"

fi

# Command Line

if [ "$1" = "command" -o  -z "$1" ]; then
echo "Testing Command Line File"

echo "..fits"
$CMD -zscale img16.fits&
KillIt

echo "..fits gz"
$CMD -zscale img16.fits.gz &
KillIt

echo "..fits"
$CMD -zscale -fits img16.fits&
KillIt

echo "..sfits"
$CMD -zscale -sfits sfits.hdr sfits.arr&
KillIt

echo "..table"
$CMD -zscale table.fits &
KillIt

echo "..table filter"
$CMD -zscale table.fits[bin=rawx,rawy] &
KillIt

echo "..multiple extension data cube"
$CMD -zscale -medatacube mosaicimage.fits &
KillIt

echo "..mosaic image iraf"
$CMD -zscale -mosaicimage iraf mosaicimage.fits &
KillIt

echo "..mosaic image wcs"
$CMD -zscale -mosaicimage wcs mosaicimage.fits &
KillIt

echo "..mosaic image next wcs"
$CMD -zscale -mosaicimage wcs mosaicimage.fits -mosaicimagenext wcs mosaicimage.fits &
KillIt

echo "..mosaic image wcsp"
$CMD -zscale -mosaicimage wcsp ds9_8amp_2x2.fits&
KillIt

echo "..mosaic image wfpc2"
$CMD -zscale -mosaicimage wfpc2 hst.fits &
KillIt

echo "..mosaic iraf"
$CMD -zscale -mosaic iraf mosaicimage.fits &
KillIt

echo "..mosaic wcs"
$CMD -zscale -mosaic wcs mosaicimage.fits &
KillIt

echo "..mosaic wcsp"
$CMD -zscale -mosaic wcsp ds9_8amp_2x2.fits &
KillIt

echo "..mosaic wcs sfits"
$CMD -zscale -smosaic wcs sfits.hdr sfits.arr &
KillIt

echo "..mosaic image iraf(bc)"
$CMD -zscale -mosaicimageiraf mosaicimage.fits &
KillIt

echo "..mosaic image wcs(bc)"
$CMD -zscale -mosaicimagewcs mosaicimage.fits &
KillIt

echo "..mosaic image wfpc2(bc)"
$CMD -zscale -mosaicimagewfpc2 hst.fits &
KillIt

echo "..mosaic image next wcs(bc)"
$CMD -zscale -mosaicimagewcs mosaicimage.fits -mosaicimagenextwcs mosaicimage.fits &
KillIt

echo "..mosaic iraf(bc)"
$CMD -zscale -mosaiciraf mosaicimage.fits &
KillIt

echo "..mosaic wcs(bc)"
$CMD -zscale -mosaicwcs mosaicimage.fits &
KillIt

echo "..rgb cube"
$CMD -rgbcube rgbcube.fits &
KillIt

echo "..rgb cube sfits"
$CMD -srgbcube rgb.hdr rgb.arr &
KillIt

echo "..rgb image"
$CMD -rgbimage rgbimage.fits &
KillIt

echo "..rgb array"
$CMD -rgbarray rgb.arr[dim=200,zdim=3,bitpix=8] &
KillIt

echo "..array"
 $CMD -array 'array.arr[dim=512,bitpix=-32,arch=bigendian]' &
KillIt

echo "..array cube"
 $CMD -array 'cube.arr[dim=512,zdim=3,bitpix=-32,arch=bigendian]' &
KillIt

#echo "..url ftp"
#$CMD -zscale -url 'ftp://sao-ftp.harvard.edu/pub/rd/ds9/data/img-32.fits' &
#KillIt

#echo "..url http"
#$CMD -zscale -url 'http://hea-www.harvard.edu/RD/ds9/data/img-32.fits' &
#KillIt

echo "..external"
$CMD foo.bar&
KillIt

echo "PASSED"
fi

# Stdin

if [ "$1" = "stdin" -o  -z "$1" ]; then
echo "Testing Stdin File"

echo "..fits"
cat img16.fits | $CMD -zscale - &
KillIt

echo "..fits gz"
cat img16.fits.gz | $CMD -zscale - &
KillIt

echo "..table"
cat table.fits | $CMD -zscale - &
KillIt

echo "..table filter"
cat table.fits | $CMD -zscale -[bin=rawx,rawy] &
KillIt

echo "..array"
cat array.arr | $CMD -array '-[dim=512,bitpix=-32,arch=bigendian]' &
KillIt

echo "..array cube"
cat cube.arr | $CMD -array '-[dim=512,zdim=3,bitpix=-32,arch=bigendian]' &
KillIt

echo "..multiple extension data cube"
cat mosaicimage.fits | $CMD -zscale -medatacube - &
KillIt

echo "..mosaic image iraf"
cat mosaicimage.fits | $CMD -zscale -mosaicimage iraf - &
KillIt

echo "..mosaic image wcs"
cat mosaicimage.fits | $CMD -zscale -mosaicimage wcs - &
KillIt

echo "..mosaic image wcsp"
cat ds9_8amp_2x2.fits | $CMD -zscale -mosaicimage wcsp - &
KillIt

echo "..mosaic image wfpc2"
cat hst.fits | $CMD -zscale -mosaicimage wfpc2 - &
KillIt

echo "..mosaic iraf"
cat mosaicimage.fits | $CMD -zscale -mosaic iraf - &
KillIt

echo "..mosaic wcs"
cat mosaicimage.fits | $CMD -zscale -mosaic wcs - &
KillIt

echo "..mosaic wcsp"
cat ds9_8amp_2x2.fits | $CMD -zscale -mosaic wcsp - &
KillIt

echo "..mosaic image iraf(bc)"
cat mosaicimage.fits | $CMD -zscale -mosaicimageiraf - &
KillIt

echo "..mosaic image wcs(bc)"
cat mosaicimage.fits | $CMD -zscale -mosaicimagewcs - &
KillIt

echo "..mosaic image wfpc2(bc)"
cat hst.fits | $CMD -zscale -mosaicimagewfpc2 - &
KillIt

echo "..mosaic iraf(bc)"
cat mosaicimage.fits | $CMD -zscale -mosaiciraf - &
KillIt

echo "..mosaic wcs(bc)"
cat mosaicimage.fits | $CMD -zscale -mosaicwcs - &
KillIt

echo "..rgb cube"
cat rgbcube.fits | $CMD -rgbcube - &
KillIt

echo "..rgb image"
cat rgbimage.fits | $CMD -rgbimage - &
KillIt

echo "..rgb array"
cat rgb.arr | $CMD -rgbarray -[dim=200,zdim=3,bitpix=8] &
KillIt

echo "PASSED"
fi

# XPA
if [ "$1" = "xpa" -o  -z "$1" ]; then
echo "Testing XPA"

StartDS9
xpaset -p $XPA scale zscale

echo "Testing file"
echo "..fits"
xpaset -p $XPA file fits img16.fits
sleep 1
xpaset -p $XPA frame clear

echo "..fits gz"
xpaset -p $XPA file fits img16.fits.gz
sleep 1
xpaset -p $XPA frame clear

echo "..sfits"
xpaset -p $XPA file sfits sfits.hdr sfits.arr
sleep 1
xpaset -p $XPA frame clear

echo "..table"
xpaset -p $XPA scale log
xpaset -p $XPA scale minmax
xpaset -p $XPA file fits table.fits
xpaset -p $XPA bin factor 8
sleep 1
xpaset -p $XPA frame clear

echo "..table filter"
xpaset -p $XPA file fits table.fits[bin=rawx,rawy]
sleep 1
xpaset -p $XPA frame clear
xpaset -p $XPA scale linear
xpaset -p $XPA scale zscale

echo "..multiple extension data cube"
xpaset -p $XPA file medatacube mosaicimage.fits
sleep 1
xpaset -p $XPA frame clear

echo "..mosaic image iraf"
xpaset -p $XPA file mosaicimage iraf mosaicimage.fits
sleep 1
xpaset -p $XPA frame clear

echo "..mosaic image wcs"
xpaset -p $XPA file mosaicimage wcs mosaicimage.fits
sleep 1

echo "..mosaic image next wcs"
xpaset -p $XPA file mosaicimagenext wcs mosaicimage.fits
sleep 1
xpaset -p $XPA frame clear

echo "..mosaic image wcsp"
xpaset -p $XPA file mosaicimage wcsp ds9_8amp_2x2.fits
sleep 1

echo "..mosaic image wfpc2"
xpaset -p $XPA file mosaicimage wfpc2 hst.fits
sleep 1
xpaset -p $XPA frame clear

echo "..mosaic iraf"
xpaset -p $XPA file mosaic iraf mosaicimage.fits
sleep 1
xpaset -p $XPA frame clear

echo "..mosaic wcs"
xpaset -p $XPA file mosaic wcs mosaicimage.fits
sleep 1
xpaset -p $XPA frame clear

echo "..mosaic wcsp"
xpaset -p $XPA file mosaic wcsp ds9_8amp_2x2.fits
sleep 1
xpaset -p $XPA frame clear

echo "..mosaic wcs sfits"
xpaset -p $XPA file smosaic wcs sfits.hdr sfits.arr
sleep 1
xpaset -p $XPA frame clear

echo "..mosaic image iraf(bc)"
xpaset -p $XPA file mosaicimageiraf mosaicimage.fits
sleep 1
xpaset -p $XPA frame clear

echo "..mosaic image wcs(bc)"
xpaset -p $XPA file mosaicimagewcs mosaicimage.fits
sleep 1

echo "..mosaic image next wcs(bc)"
xpaset -p $XPA file mosaicimagenextwcs mosaicimage.fits
sleep 1
xpaset -p $XPA frame clear

echo "..mosaic image wfpc2(bc)"
xpaset -p $XPA file mosaicwfpc2 hst.fits
sleep 1
xpaset -p $XPA frame clear

echo "..mosaic iraf(bc)"
xpaset -p $XPA file mosaiciraf mosaicimage.fits
sleep 1
xpaset -p $XPA frame clear

echo "..mosaic wcs(bc)"
xpaset -p $XPA file mosaicwcs mosaicimage.fits
sleep 1
xpaset -p $XPA frame clear

echo "..rgb cube"
xpaset -p $XPA scale minmax
xpaset -p $XPA rgb
xpaset -p $XPA file rgbcube rgbcube.fits
sleep 1
xpaset -p $XPA frame clear

echo "..rgb cube sfits"
xpaset -p $XPA scale minmax
xpaset -p $XPA rgb
xpaset -p $XPA file srgbcube rgb.hdr rgb.arr
sleep 1
xpaset -p $XPA frame clear

echo "..rgb image"
xpaset -p $XPA file rgbimage rgbimage.fits
sleep 1
xpaset -p $XPA frame clear

echo "..rgb array"
xpaset -p $XPA file rgbarray rgb.arr[dim=200,zdim=3,bitpix=8]
sleep 1
xpaset -p $XPA frame clear
xpaset -p $XPA frame delete
xpaset -p $XPA scale zscale

echo "..array"
xpaset -p $XPA file array 'array.arr[dim=512,bitpix=-32,arch=bigendian]'
sleep 1
xpaset -p $XPA frame clear

echo "..array cube"
xpaset -p $XPA file array 'cube.arr[dim=512,zdim=3,bitpix=-32,arch=bigendian]'
sleep 1
xpaset -p $XPA frame clear

#echo "..url ftp"
#xpaset -p $XPA file url 'ftp://sao-ftp.harvard.edu/pub/rd/ds9/data/img-32.fits'&
#sleep 5
#xpaset -p $XPA frame clear

#echo "..url http"
#xpaset -p $XPA file url 'http://hea-www.harvard.edu/RD/ds9/data/img-32.fits'&
#sleep 5
#xpaset -p $XPA frame clear

echo "..external"
xpaset -p $XPA file foo.bar
sleep 5
xpaset -p $XPA frame clear

echo "Testing Array"
echo "..array"

xpaset -p $XPA scale minmax

cat array.arr | xpaset $XPA array 'array.arr[dim=512,bitpix=-32,arch=bigendian]'
sleep 1
xpaset -p $XPA frame clear

echo "..array cube"
cat cube.arr | xpaset $XPA array 'arraycube.arr[dim=512,zdim=3,bitpix=-32,arch=bigendian]'
sleep 1
xpaset -p $XPA frame clear

echo "..array rgb"
cat rgb.arr | xpaset $XPA array new rgb 'rgb.arr[dim=200,zdim=3,bitpix=8]'
sleep 1
xpaset -p $XPA frame delete

xpaset -p $XPA scale zscale

echo "Testing Fits"
echo "..fits"
cat img16.fits | xpaset $XPA fits
sleep 1
xpaset -p $XPA frame clear

echo "..fits gz"
cat img16.fits.gz | xpaset $XPA fits
sleep 1
xpaset -p $XPA frame clear

echo "..table"
xpaset -p $XPA scale log
xpaset -p $XPA scale minmax
cat table.fits | xpaset $XPA fits
xpaset -p $XPA bin factor 8
sleep 1
xpaset -p $XPA frame clear

echo "..table filter"
cat table.fits | xpaset $XPA fits 'table.fits[bin=rawx,rawy]'
sleep 1
xpaset -p $XPA frame clear
xpaset -p $XPA scale linear
xpaset -p $XPA scale zscale

echo "..multiple extension data cube"
cat mosaicimage.fits | xpaset $XPA fits medatacube foo
sleep 1
xpaset -p $XPA frame clear

echo "..mosaic image iraf"
cat mosaicimage.fits | xpaset $XPA fits mosaicimage iraf foo
sleep 1
xpaset -p $XPA frame clear

echo "..mosaic image wcs"
cat mosaicimage.fits | xpaset $XPA fits mosaicimage wcs foo
sleep 1

echo "..mosaic image next wcs"
cat mosaicimage.fits | xpaset $XPA fits mosaicimagenext wcs foo
sleep 1
xpaset -p $XPA frame clear

echo "..mosaic image wcsp"
cat ds9_8amp_2x2.fits | xpaset $XPA fits mosaicimage wcsp foo
sleep 1

echo "..mosaic image wfpc2"
cat hst.fits | xpaset $XPA fits mosaicimage wfpc2 foo
sleep 1
xpaset -p $XPA frame clear

echo "..mosaic iraf"
cat mosaicimage.fits | xpaset $XPA fits mosaic iraf bar
sleep 1
xpaset -p $XPA frame clear

echo "..mosaic wcs"
cat mosaicimage.fits | xpaset $XPA fits mosaic wcs bar
sleep 1
xpaset -p $XPA frame clear

echo "..mosaic wcsp"
cat ds9_8amp_2x2.fits | xpaset $XPA fits mosaic wcsp bar
sleep 1
xpaset -p $XPA frame clear

echo "..mosaic image iraf(bc)"
cat mosaicimage.fits | xpaset $XPA fits mosaicimageiraf foo
sleep 1
xpaset -p $XPA frame clear

echo "..mosaic image wcs(bc)"
cat mosaicimage.fits | xpaset $XPA fits mosaicimagewcs foo
sleep 1

echo "..mosaic image next wcs(bc)"
cat mosaicimage.fits | xpaset $XPA fits mosaicimagenextwcs foo
sleep 1
xpaset -p $XPA frame clear

echo "..mosaic image wfpc2(bc)"
cat hst.fits | xpaset $XPA fits mosaicimagewfpc2 foo
sleep 1
xpaset -p $XPA frame clear

echo "..mosaic iraf(bc)"
cat mosaicimage.fits | xpaset $XPA fits mosaiciraf bar
sleep 1
xpaset -p $XPA frame clear

echo "..mosaic wcs(bc)"
cat mosaicimage.fits | xpaset $XPA fits mosaicwcs bar
sleep 1
xpaset -p $XPA frame clear

echo "..rgb cube"
xpaset -p $XPA scale minmax
xpaset -p $XPA rgb
cat rgbcube.fits | xpaset $XPA fits rgbcube
sleep 1
xpaset -p $XPA frame clear

echo "..rgb image"
cat rgbimage.fits | xpaset $XPA fits rgbimage
sleep 1
xpaset -p $XPA frame delete

xpaset -p $XPA quit
echo "PASSED"
fi

echo "DONE"
