#  Copyright (C) 1999-2004
#  Smithsonian Astrophysical Observatory, Cambridge, MA, USA
#  For conditions of distribution and use, see copyright notice in "copyright"

package provide DS9 1.0

proc PointDialog {frame id} {
    # see if we already have a header window visible

    set w ".marker$id"
    set mb ".mb$id"

    if [winfo exist $w] {
	raise $w
	return
    }

    # Init common items

    InitMarkerDialog $frame $id
    PropMenuPointDialog $frame $mb $id
    CoordMenuMarkerDialog $frame $mb $id CoordPointCB
    CoordMarkerCB $frame $id

    # file menu items

    $mb.file add command -label "Apply" \
	-command "ApplyPointDialog $frame $id"
    $mb.file add separator
    $mb.file add command -label "Close" \
	-command "ClosePointDialog $frame $id"

    # Point specific callbacks

    $frame marker $id callback delete DeletePointDialog $frame

    # Dialog

    CommonMarkerDialog $frame $id
    wm protocol $w WM_DELETE_WINDOW "ClosePointDialog $frame $id"

    # Buttons

    button $w.buttons.apply -text "Apply" \
	-command "ApplyPointDialog $frame $id"
    button $w.buttons.close -text "Close" \
	-command "ClosePointDialog $frame $id"
    pack $w.buttons.apply $w.buttons.close -side left -padx 10 -expand true

    bind $w <Return> "ApplyPointDialog $frame $id"

    # some window managers need a hint
    raise $w
}

proc PropMenuPointDialog {frame mb id} {
    global menu
    global marker

    menu $mb.properties -tearoff 0 -selectcolor $menu(selectcolor)
    $mb.properties add checkbutton -label "Can Move" \
	-variable marker($frame,$id,move) \
	-command "PropertyMarkerDialog $frame $id move"
    $mb.properties add checkbutton -label "Can Delete" \
	-variable marker($frame,$id,delete) \
	-command "PropertyMarkerDialog $frame $id delete"
    $mb.properties add separator
    $mb.properties add radiobutton -label Include \
	-variable marker($frame,$id,include) -value 1 \
	-command "PropertyMarkerDialog $frame $id include"
    $mb.properties add radiobutton -label Exclude \
	-variable marker($frame,$id,include) -value 0 \
	-command "PropertyMarkerDialog $frame $id include"
    $mb.properties add separator
    $mb.properties add radiobutton -label Source \
	-variable marker($frame,$id,source) -value 1 \
	-command "PropertyMarkerDialog $frame $id source"
    $mb.properties add radiobutton -label Background \
	-variable marker($frame,$id,source) -value 0 \
	-command "PropertyMarkerDialog $frame $id source"
}

proc ApplyPointDialog {frame id} {
    ApplyMarkerDialog $frame $id
}

proc ClosePointDialog {frame id} {
    $frame marker $id delete callback delete DeletePointDialog
    DeleteMarkerCBs $frame $id

    DeletePointDialog $frame $id
}

proc DeletePointDialog {frame id} {
    DeleteMarkerDialog $frame $id
}

proc CoordPointCB {frame id} {
    CoordMarkerCB $frame $id

    MoveMarkerCB $frame $id
}

