// Copyright (C) 1999-2004
// Smithsonian Astrophysical Observatory, Cambridge, MA, USA
// For conditions of distribution and use, see copyright notice in "copyright"

#if __GNUC__ >= 3
#include <iostream>
using namespace std;
#else
#include <iostream.h>
#endif

#include "ds9tk.h"

extern "C" {
  int Blt_Init(Tcl_Interp*);
  int Ast_Init(Tcl_Interp*);
  int Checkdns_Init(Tcl_Interp*);
  int Saotk_Init(Tcl_Interp*);
  int Tkhtml_Init(Tcl_Interp*);
  int Tkmpeg_Init(Tcl_Interp*);

  int Tkimg_Init(Tcl_Interp*);
  int Zlibtcl_Init(Tcl_Interp*);
  int Jpegtcl_Init(Tcl_Interp*);
  int Tkimgjpeg_Init(Tcl_Interp*);
  int Tifftcl_Init(Tcl_Interp*);
  int Tkimgtiff_Init(Tcl_Interp*);
  int Pngtcl_Init(Tcl_Interp*);
  int Tkimgpng_Init(Tcl_Interp*);
  int Tkimggif_Init(Tcl_Interp*);
  int Tkimgppm_Init(Tcl_Interp*);
  int Tkimgbmp_Init(Tcl_Interp*);
  int Tkimgxbm_Init(Tcl_Interp*);
  int Tkimgwindow_Init(Tcl_Interp*);

  int Tclxpa_Init(Tcl_Interp*);
  int Iis_Init(Tcl_Interp*);
}

// just so that mktclapp will see it
int Et_AppInit();

extern "C" {
int Et_AppInit(Tcl_Interp *interp)
{
  if (Blt_Init(interp) == TCL_ERROR)
    return TCL_ERROR;
  Tcl_StaticPackage (interp, "BLT", Blt_Init, (Tcl_PackageInitProc*)NULL);

  if (Ast_Init(interp) == TCL_ERROR)
    return TCL_ERROR;
  Tcl_StaticPackage (interp, "Ast", Ast_Init, (Tcl_PackageInitProc*)NULL);

  if (Checkdns_Init(interp) == TCL_ERROR)
    return TCL_ERROR;
  Tcl_StaticPackage (interp, "checkdns", Checkdns_Init, (Tcl_PackageInitProc*)NULL);

  if (Saotk_Init(interp) == TCL_ERROR)
    return TCL_ERROR;
  Tcl_StaticPackage (interp, "saotk", Saotk_Init,(Tcl_PackageInitProc*)NULL);

  if (Tkhtml_Init(interp) == TCL_ERROR)
    return TCL_ERROR;
  Tcl_StaticPackage (interp, "tkhtml", Tkhtml_Init,(Tcl_PackageInitProc*)NULL);

  if (Tclxpa_Init(interp) == TCL_ERROR)
    return TCL_ERROR;
  Tcl_StaticPackage (interp, "tclxpa", Tclxpa_Init,(Tcl_PackageInitProc*)NULL);

  if (Iis_Init(interp) == TCL_ERROR)
    return TCL_ERROR;
  Tcl_StaticPackage (interp, "iis", Iis_Init, (Tcl_PackageInitProc*)NULL);

  if (Tkmpeg_Init(interp) == TCL_ERROR)
    return TCL_ERROR;
  Tcl_StaticPackage (interp, "tkmpeg", Tkmpeg_Init, 
		     (Tcl_PackageInitProc*)NULL);

  // Tkimg _inits

  if (Tkimg_Init(interp) == TCL_ERROR)
    return TCL_ERROR;
  Tcl_StaticPackage (interp, "img", Tkimg_Init,(Tcl_PackageInitProc*)NULL);

  if (Zlibtcl_Init(interp) == TCL_ERROR)
    return TCL_ERROR;
  Tcl_StaticPackage (interp, "zlibtcl", Zlibtcl_Init,(Tcl_PackageInitProc*)NULL);

  if (Jpegtcl_Init(interp) == TCL_ERROR)
    return TCL_ERROR;
  Tcl_StaticPackage (interp, "jpegtcl", Jpegtcl_Init,(Tcl_PackageInitProc*)NULL);

  if (Tkimgjpeg_Init(interp) == TCL_ERROR)
    return TCL_ERROR;
  Tcl_StaticPackage (interp, "jpeg", Tkimgjpeg_Init,(Tcl_PackageInitProc*)NULL);

  if (Tifftcl_Init(interp) == TCL_ERROR)
    return TCL_ERROR;
  Tcl_StaticPackage (interp, "tifftcl", Tifftcl_Init,(Tcl_PackageInitProc*)NULL);

  if (Tkimgtiff_Init(interp) == TCL_ERROR)
    return TCL_ERROR;
  Tcl_StaticPackage (interp, "tiff", Tkimgtiff_Init,(Tcl_PackageInitProc*)NULL);

  if (Pngtcl_Init(interp) == TCL_ERROR)
    return TCL_ERROR;
  Tcl_StaticPackage (interp, "pngtcl", Pngtcl_Init,(Tcl_PackageInitProc*)NULL);

  if (Tkimgpng_Init(interp) == TCL_ERROR)
    return TCL_ERROR;
  Tcl_StaticPackage (interp, "png", Tkimgpng_Init,(Tcl_PackageInitProc*)NULL);

  if (Tkimggif_Init(interp) == TCL_ERROR)
    return TCL_ERROR;
  Tcl_StaticPackage (interp, "gif", Tkimggif_Init,(Tcl_PackageInitProc*)NULL);

  if (Tkimgppm_Init(interp) == TCL_ERROR)
    return TCL_ERROR;
  Tcl_StaticPackage (interp, "ppm", Tkimgppm_Init,(Tcl_PackageInitProc*)NULL);

  if (Tkimgbmp_Init(interp) == TCL_ERROR)
    return TCL_ERROR;
  Tcl_StaticPackage (interp, "bmp", Tkimgbmp_Init,(Tcl_PackageInitProc*)NULL);

  if (Tkimgxbm_Init(interp) == TCL_ERROR)
    return TCL_ERROR;
  Tcl_StaticPackage (interp, "xbm", Tkimgxbm_Init,(Tcl_PackageInitProc*)NULL);

  if (Tkimgwindow_Init(interp) == TCL_ERROR)
    return TCL_ERROR;
  Tcl_StaticPackage (interp, "window", Tkimgwindow_Init,(Tcl_PackageInitProc*)NULL);

  return TCL_OK;
}
}

int main(int argc, char** argv)
{
  ios::sync_with_stdio();    // sync C++ io calls with C io calls
  Et_Init(argc, argv);
  return 0;
}

