#  Copyright (C) 1999-2004
#  Smithsonian Astrophysical Observatory, Cambridge, MA, USA
#  For conditions of distribution and use, see copyright notice in "copyright"

package provide DS9 1.0

proc BoxAnnulusDialog {frame id} {
    global marker
    global ds9

    # see if we already have a header window visible

    set w ".marker$id"
    set mb ".mb$id"

    if [winfo exist $w] {
	raise $w
	return
    }

    # Init common items

    InitMarkerDialog $frame $id
    PropMenuBoxAnnulusDialog $frame $mb $id
    CoordMenuMarkerDialog $frame $mb $id CoordBoxAnnulusCB
    CoordMarkerCB $frame $id

    # file menu items

    $mb.file add command -label "Apply" \
	-command "ApplyBoxAnnulusDialog $frame $id"
    $mb.file add separator
    $mb.file add command -label "Close" \
	-command "CloseBoxAnnulusDialog $frame $id"

    # annulus menu items

    set marker($frame,$id,scoord) $marker(dialog,dist,system)
    set marker($frame,$id,slabel) $marker(dialog,dist,system)
    set marker($frame,$id,sformat) $marker(dialog,dist,format)

    DistMenuMarkerDialog $frame $mb $id DistBoxAnnulusCB size scoord sformat
    $mb add cascade -label Size -menu $mb.size

    set marker($frame,$id,method) dist
    AnnuliMenuMarkerDialog $frame $mb $id method
    $mb add cascade -label Method -menu $mb.method

    # annulus specific callbacks

    $frame marker $id callback edit EditBoxAnnulusCB $frame
    $frame marker $id callback edit MoveMarkerCB $frame
    $frame marker $id callback rotate RotateMarkerCB $frame
    $frame marker $id callback delete DeleteBoxAnnulusDialog $frame

    # Dialog

    set type [string toupper "[$frame get marker $id type]"]

    toplevel $w -colormap $ds9(main)
    wm title $w $type
    wm iconname $w $type
    wm group $w $ds9(top)
    wm protocol $w WM_DELETE_WINDOW "CloseBoxAnnulusDialog $frame $id"

    $w configure -menu $mb

    frame $w.ref
    frame $w.buttons -relief groove -borderwidth 2
    pack $w.ref -fill x
    pack $w.buttons -fill x -ipadx 4 -ipady 4

    frame $w.ref.left
    frame $w.ref.right -relief groove -borderwidth 2
    pack $w.ref.left $w.ref.right -side left -fill y

    frame $w.ref.left.top -relief groove -borderwidth 2
    frame $w.ref.left.top.f
    frame $w.ref.left.bottom -relief groove -borderwidth 2
    frame $w.ref.left.bottom.f
    pack $w.ref.left.top.f $w.ref.left.bottom.f -anchor w -padx 4 -pady 4
    pack $w.ref.left.top $w.ref.left.bottom -fill both -expand true

    # ID

    label $w.ref.left.top.f.idTitle -text "Id"
    label $w.ref.left.top.f.idValue -text "$id"

    # Text

    label $w.ref.left.top.f.textTitle -text "Text"
    entry $w.ref.left.top.f.textValue -textvariable marker($frame,$id,text) \
	-width 40 

    grid $w.ref.left.top.f.idTitle $w.ref.left.top.f.idValue -padx 4 -sticky w
    grid $w.ref.left.top.f.textTitle $w.ref.left.top.f.textValue \
	-padx 4 -sticky w

    # Center

    label $w.ref.left.bottom.f.centerTitle -text "Center"
    entry $w.ref.left.bottom.f.centerX -textvariable marker($frame,$id,x) \
	-width 13 
    entry $w.ref.left.bottom.f.centerY -textvariable marker($frame,$id,y) \
	-width 13 
    label $w.ref.left.bottom.f.centerCoord -relief groove -width 9 \
	-padx 4 -textvariable marker($frame,$id,system)

    # Size

    label $w.ref.left.bottom.f.majorTitle -text "Width"
    label $w.ref.left.bottom.f.minorTitle -text "Height"

    label $w.ref.left.bottom.f.innerTitle -text "Outer Size"
    entry $w.ref.left.bottom.f.size1 -textvariable marker($frame,$id,size1) \
	-width 13 
    entry $w.ref.left.bottom.f.size2 -textvariable marker($frame,$id,size2) \
	-width 13 
    label $w.ref.left.bottom.f.sizeformat \
	-textvariable marker($frame,$id,slabel) -relief groove -width 9 -padx 4

    label $w.ref.left.bottom.f.outerTitle -text "Inner Size"
    entry $w.ref.left.bottom.f.size3 -textvariable marker($frame,$id,size3) \
	-width 13 

    label $w.ref.left.bottom.f.annuliTitle -text "Annuli"
    entry $w.ref.left.bottom.f.annuli -textvariable marker($frame,$id,annuli) \
	-width 13 

    label $w.ref.left.bottom.f.angleTitle -text "Angle"
    entry $w.ref.left.bottom.f.angle -textvariable marker($frame,$id,angle) \
	-width 13 
    label $w.ref.left.bottom.f.angleUnit -relief groove -width 9 \
	-padx 4 -text "degrees"

    grid $w.ref.left.bottom.f.centerTitle $w.ref.left.bottom.f.centerX \
	$w.ref.left.bottom.f.centerY $w.ref.left.bottom.f.centerCoord \
	-padx 4 -sticky w
    grid x $w.ref.left.bottom.f.majorTitle $w.ref.left.bottom.f.minorTitle \
	-padx 4 -sticky w
    grid $w.ref.left.bottom.f.innerTitle $w.ref.left.bottom.f.size1 \
	$w.ref.left.bottom.f.size2 $w.ref.left.bottom.f.sizeformat \
	-padx 4 -sticky w
    grid $w.ref.left.bottom.f.outerTitle $w.ref.left.bottom.f.size3 \
	-padx 4 -sticky w
    grid $w.ref.left.bottom.f.annuliTitle $w.ref.left.bottom.f.annuli \
	-padx 4 -sticky w
    grid $w.ref.left.bottom.f.angleTitle $w.ref.left.bottom.f.angle x \
	$w.ref.left.bottom.f.angleUnit -padx 4 -sticky w

    # Right

    frame $w.ref.right.title
    frame $w.ref.right.value
    pack $w.ref.right.title $w.ref.right.value -side top -padx 4 -pady 4

    label $w.ref.right.title.title -text "Annuli"
    label $w.ref.right.title.sizeformat \
	-textvariable marker($frame,$id,slabel) -relief groove -width 9 -padx 4

    grid $w.ref.right.title.title $w.ref.right.title.sizeformat \
	-padx 4 -sticky news

    set txtscr $w.ref.right.value.yscroll
    set marker($frame,$id,annulitxt) $w.ref.right.value.txt
    text $marker($frame,$id,annulitxt) -height 10 -width 15 -wrap none \
	-font {courier 12} -yscrollcommand "$txtscr set"
    scrollbar $txtscr -command [list $marker($frame,$id,annulitxt) yview] \
	-orient vertical

    grid $marker($frame,$id,annulitxt) $txtscr -sticky news

    # Buttons

    button $w.buttons.apply -text "Apply" \
	-command "ApplyBoxAnnulusDialog $frame $id"
    button $w.buttons.generate -text "Generate" \
	-command "BoxAnnulusUpdateSize $frame $id"
    button $w.buttons.close -text "Close" \
	-command "CloseBoxAnnulusDialog $frame $id"
    pack $w.buttons.apply $w.buttons.generate $w.buttons.close \
	-side left -padx 10 -expand true

    # some window managers need a hint
    raise $w

    # Init annulus variables

    EditBoxAnnulusCB $frame $id
    RotateMarkerCB $frame $id
    DistBoxAnnulusCB $frame $id
}

proc PropMenuBoxAnnulusDialog {frame mb id} {
    global menu
    global marker

    menu $mb.properties -tearoff 0 -selectcolor $menu(selectcolor)
    $mb.properties add checkbutton -label "Can Edit" \
	-variable marker($frame,$id,edit) \
	-command "PropertyMarkerDialog $frame $id edit"
    $mb.properties add checkbutton -label "Can Move" \
	-variable marker($frame,$id,move) \
	-command "PropertyMarkerDialog $frame $id move"
    $mb.properties add checkbutton -label "Can Delete" \
	-variable marker($frame,$id,delete) \
	-command "PropertyMarkerDialog $frame $id delete"
    $mb.properties add checkbutton -label "Fixed in Size" \
	-variable marker($frame,$id,fixed) \
	-command "PropertyMarkerDialog $frame $id fixed"
    $mb.properties add separator
    $mb.properties add radiobutton -label Include \
	-variable marker($frame,$id,include) -value 1 \
	-command "PropertyMarkerDialog $frame $id include"
    $mb.properties add radiobutton -label Exclude \
	-variable marker($frame,$id,include) -value 0 \
	-command "PropertyMarkerDialog $frame $id include"
    $mb.properties add separator
    $mb.properties add radiobutton -label Source \
	-variable marker($frame,$id,source) -value 1 \
	-command "PropertyMarkerDialog $frame $id source"
    $mb.properties add radiobutton -label Background \
	-variable marker($frame,$id,source) -value 0 \
	-command "PropertyMarkerDialog $frame $id source"
}

proc ApplyBoxAnnulusDialog {frame id} {
    # do this first, since editbox will do a MoveMarkerCB
    ApplyMarkerDialog $frame $id

    EditBoxAnnulusDialog $frame $id
    RotateMarkerDialog $frame $id
}

proc CloseBoxAnnulusDialog {frame id} {
    global marker

    $frame marker $id delete callback edit EditBoxAnnulusCB
    $frame marker $id delete callback edit MoveMarkerCB
    $frame marker $id delete callback rotate RotateMarkerCB
    $frame marker $id delete callback delete DeleteBoxAnnulusDialog
    DeleteMarkerCBs $frame $id

    DeleteBoxAnnulusDialog $frame $id
}

proc DeleteBoxAnnulusDialog {frame id} {
    global marker

    DeleteMarkerDialog $frame $id

    unset marker($frame,$id,size1)
    unset marker($frame,$id,size2)
    unset marker($frame,$id,size3)
    unset marker($frame,$id,annuli)
    unset marker($frame,$id,annulitxt)
    unset marker($frame,$id,scoord)
    unset marker($frame,$id,sformat)
    unset marker($frame,$id,slabel)
    unset marker($frame,$id,angle)
    unset marker($frame,$id,method)
}

proc EditBoxAnnulusDialog {frame id} {
    global marker

    set levels ""
    regsub -all "\n" "[$marker($frame,$id,annulitxt) get 1.0 end]" " " levels
    # and trim any trailing spaces
    set levels [string trimright $levels " "]

    if {$levels != ""} {
	$frame marker $id box annulus size "\{$levels\}" \
	    $marker($frame,$id,scoord) $marker($frame,$id,sformat)
    }
}

proc EditBoxAnnulusCB {frame id} {
    global marker

    set t [$frame get marker $id box annulus size \
	       $marker($frame,$id,scoord) $marker($frame,$id,sformat)]

    set last [llength $t]
    set marker($frame,$id,annuli) [expr $last/2-1]
    set marker($frame,$id,size1) [lindex $t [expr $last-2]]
    set marker($frame,$id,size2) [lindex $t [expr $last-1]]
    set marker($frame,$id,size3) [lindex $t 0]

    $marker($frame,$id,annulitxt) delete 1.0 end
    $marker($frame,$id,annulitxt) insert end "$t"
}

proc CoordBoxAnnulusCB {frame id} {
    CoordMarkerCB $frame $id

    MoveMarkerCB $frame $id
    EditBoxAnnulusCB $frame $id
    RotateMarkerCB $frame $id
}

proc DistBoxAnnulusCB {frame id} {
    global marker
    set mb ".mb$id"

    AdjustDist $frame marker($frame,$id,scoord)

    set marker($frame,$id,slabel) $marker($frame,$id,scoord)
    switch -- $marker($frame,$id,scoord) {
	image -
	physical -
	amplifier -
	detector {}
	default {
	    if [$frame has wcs $marker($frame,$id,scoord)] {
		if [$frame has wcs equatorial $marker($frame,$id,scoord)] {
		    set marker($frame,$id,slabel) $marker($frame,$id,sformat)
		} else {
		    set name [$frame get wcs name $marker($frame,$id,scoord)]
		    if {$name != ""} {
			set marker($frame,$id,slabel) $name
		    }
		}
	    }
	}
    }

    MoveMarkerCB $frame $id
    EditBoxAnnulusCB $frame $id
}

proc BoxAnnulusUpdateSize {frame id} {
    global marker

    $marker($frame,$id,annulitxt) delete 1.0 end

    if {$marker($frame,$id,annuli) < 1} {
	set marker($frame,$id,annuli) 1
    }

    set size1 $marker($frame,$id,size1)
    set size2 $marker($frame,$id,size2)
    set size3 $marker($frame,$id,size3)
    set annuli $marker($frame,$id,annuli)

    if {($size1 != "") && ($size2 != "") && \
        ($size3 != "") && ($annuli != "")} {

	if {$size1<=0} {
	    set size1 1
	}
	if {$size2<=0} {
	    set size2 1
	}

	switch -- $marker($frame,$id,method) {
	    dist {
		for {set i 0} {$i<=$annuli} {incr i} {
		    set major [expr ((($size1-$size3)/$annuli)*$i)+$size3]
		    set minor [expr $major*$size2/$size1]
		    $marker($frame,$id,annulitxt) insert end "$major $minor\n"
		}
	    }

	    area {
		set r [expr double($size2)/$size1]
		set area [expr (($size1*$size2)-($size3*$size3*$r)) \
			      /$annuli]

		set major0 $size3
		set minor0 [expr $size3*$r]
		$marker($frame,$id,annulitxt) insert end "$major0 $minor0\n"
		for {set i 0} {$i<$annuli} {incr i} {
		    set major1 [expr sqrt(($area+($major0*$minor0))/$r)]
		    set minor1 [expr $major1*$r]
		    $marker($frame,$id,annulitxt) insert end \
			[format "%.4f %.4f\n" $major1 $minor1]
		    set major0 $major1
		    set minor0 $minor1
		}
	    }
	}
    }
}

proc BoxAnnulusDefaultDialog {} {
    global marker
    global ed

    set w ".boxannulus"

    set ed(ok) 0
    set ed(size1) $marker(boxannulus,size1)
    set ed(size2) $marker(boxannulus,size2)
    set ed(size3) $marker(boxannulus,size3)
    set ed(annuli) $marker(boxannulus,annuli)

    DialogCreate $w "Default Box Annulus" -borderwidth 2
    frame $w.ed  -relief groove -borderwidth 2
    frame $w.buttons -relief groove -borderwidth 2
    pack $w.ed $w.buttons -fill x -ipadx 4 -ipady 4

    label $w.ed.majorTitle -text "Major"
    label $w.ed.minorTitle -text "Minor"

    label $w.ed.innerTitle -text "Inner Size"
    entry $w.ed.size1 -textvariable ed(size1) -width 10 
    entry $w.ed.size2 -textvariable ed(size2) -width 10 
    label $w.ed.unit -text "image" -relief groove -width 8

    label $w.ed.outerTitle -text "Outer Size"
    entry $w.ed.size3 -textvariable ed(size3) -width 10 

    label $w.ed.annuliTitle -text "Annuli"
    entry $w.ed.annuli -textvariable ed(annuli) -width 10 
    
    grid x $w.ed.majorTitle $w.ed.minorTitle -padx 4 -sticky w
    grid $w.ed.innerTitle $w.ed.size1 $w.ed.size2 $w.ed.unit -padx 4 -sticky w
    grid $w.ed.outerTitle $w.ed.size3 -padx 4 -sticky w
    grid $w.ed.annuliTitle $w.ed.annuli -padx 4 -sticky w

    button $w.buttons.ok -text "OK" -default active \
	-command {set ed(ok) 1}
    button $w.buttons.cancel -text "Cancel" -command {set ed(ok) 0}
    pack $w.buttons.ok -side left -padx 10
    pack $w.buttons.cancel -side right -padx 10

    bind $w <Return> {set ed(ok) 1}
    bind $w <Alt-o> "tkButtonInvoke $w.buttons.ok"
    bind $w <Alt-c> "tkButtonInvoke $w.buttons.cancel"

    DialogCenter $w 
    $w.ed.size1 select range 0 end
    DialogWait $w ed(ok) $w.ed.size1
    DialogDismiss $w

    if {$ed(ok)} {
	set marker(boxannulus,size1) $ed(size1)
	set marker(boxannulus,size2) $ed(size2)
	set marker(boxannulus,size3) $ed(size3)
	set marker(boxannulus,annuli) $ed(annuli)
    }

    unset ed
}
